/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.umdm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jboss.ws.NativeMessages;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.InitalizableMetaData;
import org.jboss.ws.metadata.umdm.SecurityActions;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedInitParamMetaData;

public abstract class HandlerMetaData
implements InitalizableMetaData,
Serializable {
    private transient EndpointMetaData epMetaData;
    private String handlerName;
    private String handlerClassName;
    private UnifiedHandlerMetaData.HandlerType handlerType;
    private Set<QName> soapHeaders = new HashSet<QName>();
    private List<UnifiedInitParamMetaData> initParams = new ArrayList<UnifiedInitParamMetaData>();
    private Class<?> handlerClass;

    public HandlerMetaData(UnifiedHandlerMetaData.HandlerType type) {
        this.handlerType = type;
    }

    public void setEndpointMetaData(EndpointMetaData epMetaData) {
        this.epMetaData = epMetaData;
    }

    public EndpointMetaData getEndpointMetaData() {
        return this.epMetaData;
    }

    public void setHandlerName(String value) {
        this.handlerName = value;
    }

    public String getHandlerName() {
        return this.handlerName;
    }

    public void setHandlerClassName(String handlerClass) {
        this.handlerClassName = handlerClass;
    }

    public String getHandlerClassName() {
        return this.handlerClassName;
    }

    public Class<?> getHandlerClass() {
        if (this.handlerClassName == null) {
            throw NativeMessages.MESSAGES.handlerClassNameCannotBeNull();
        }
        Class<?> localClass = this.handlerClass;
        if (localClass == null) {
            try {
                ClassLoader loader = this.getClassLoader();
                localClass = loader.loadClass(this.handlerClassName);
            }
            catch (ClassNotFoundException ex) {
                throw new WSException(ex);
            }
        }
        return localClass;
    }

    private ClassLoader getClassLoader() {
        ClassLoader ctxLoader = SecurityActions.getContextClassLoader();
        return this.epMetaData != null ? this.epMetaData.getClassLoader() : ctxLoader;
    }

    public UnifiedHandlerMetaData.HandlerType getHandlerType() {
        return this.handlerType;
    }

    public void setSoapHeaders(Set<QName> soapHeaders) {
        this.soapHeaders = soapHeaders;
    }

    public Set<QName> getSoapHeaders() {
        return this.soapHeaders;
    }

    public void setInitParams(List<UnifiedInitParamMetaData> initParams) {
        this.initParams = initParams;
    }

    public List<UnifiedInitParamMetaData> getInitParams() {
        return this.initParams;
    }

    @Override
    public void eagerInitialize() {
        this.handlerClass = this.getHandlerClass();
    }
}

