/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.builder.jaxrpc;

import java.io.IOException;
import java.net.URL;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jboss.ws.NativeLoggers;
import org.jboss.ws.NativeMessages;
import org.jboss.ws.WSException;
import org.jboss.ws.common.ResourceLoaderAdapter;
import org.jboss.ws.metadata.builder.jaxrpc.JAXRPCMetaDataBuilder;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMappingFactory;
import org.jboss.ws.metadata.jaxrpcmapping.ServiceEndpointInterfaceMapping;
import org.jboss.ws.metadata.umdm.ClientEndpointMetaData;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.HandlerMetaDataJAXRPC;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.umdm.UnifiedMetaData;
import org.jboss.ws.metadata.wsdl.WSDLBinding;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;

public class JAXRPCClientMetaDataBuilder
extends JAXRPCMetaDataBuilder {
    public ServiceMetaData buildMetaData(QName serviceQName, URL wsdlURL, URL mappingURL, UnifiedServiceRefMetaData serviceRefMetaData, ClassLoader loader) {
        try {
            JavaWsdlMapping javaWsdlMapping = null;
            if (mappingURL != null) {
                JavaWsdlMappingFactory mappingFactory = JavaWsdlMappingFactory.newInstance();
                javaWsdlMapping = mappingFactory.parse(mappingURL);
            }
            return this.buildMetaData(serviceQName, wsdlURL, javaWsdlMapping, serviceRefMetaData, loader);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new WSException(ex);
        }
    }

    public ServiceMetaData buildMetaData(QName serviceQName, URL wsdlURL, JavaWsdlMapping javaWsdlMapping, UnifiedServiceRefMetaData usrMetaData, ClassLoader loader) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("START buildMetaData: [service=" + serviceQName + "]"));
        }
        try {
            ResourceLoaderAdapter vfsRoot = new ResourceLoaderAdapter(loader);
            UnifiedMetaData wsMetaData = new UnifiedMetaData((UnifiedVirtualFile)vfsRoot);
            wsMetaData.setClassLoader(loader);
            ServiceMetaData serviceMetaData = new ServiceMetaData(wsMetaData, serviceQName);
            wsMetaData.addService(serviceMetaData);
            serviceMetaData.setWsdlLocation(wsdlURL);
            WSDLDefinitions wsdlDefinitions = serviceMetaData.getWsdlDefinitions();
            if (javaWsdlMapping != null) {
                URL mappingURL = new URL("http://www.jboss.org/jbossws/dummy-mapping-file");
                if (usrMetaData != null && usrMetaData.getMappingLocation() != null) {
                    mappingURL = usrMetaData.getMappingLocation();
                }
                wsMetaData.addMappingDefinition(mappingURL.toExternalForm(), javaWsdlMapping);
                serviceMetaData.setMappingLocation(mappingURL);
            }
            this.buildMetaDataInternal(serviceMetaData, wsdlDefinitions, javaWsdlMapping, usrMetaData);
            wsMetaData.eagerInitialize();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("END buildMetaData: " + wsMetaData));
            }
            return serviceMetaData;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new WSException(ex);
        }
    }

    private void buildMetaDataInternal(ServiceMetaData serviceMetaData, WSDLDefinitions wsdlDefinitions, JavaWsdlMapping javaWsdlMapping, UnifiedServiceRefMetaData serviceRefMetaData) throws IOException {
        QName serviceQName = serviceMetaData.getServiceName();
        WSDLService wsdlService = null;
        if (serviceQName == null) {
            wsdlService = wsdlDefinitions.getServices()[0];
            serviceMetaData.setServiceName(wsdlService.getName());
        } else {
            wsdlService = wsdlDefinitions.getService(serviceQName);
        }
        if (wsdlService == null) {
            throw NativeMessages.MESSAGES.cannotObtainWSDLService(serviceQName);
        }
        this.setupTypesMetaData(serviceMetaData);
        for (WSDLEndpoint wsdlEndpoint : wsdlService.getEndpoints()) {
            QName bindingName = wsdlEndpoint.getBinding();
            WSDLBinding wsdlBinding = wsdlEndpoint.getWsdlService().getWsdlDefinitions().getBinding(bindingName);
            String bindingType = wsdlBinding.getType();
            if (!"http://schemas.xmlsoap.org/wsdl/soap/".equals(bindingType) && !"http://schemas.xmlsoap.org/wsdl/soap12/".equals(bindingType)) continue;
            QName portName = wsdlEndpoint.getName();
            QName interfaceQName = wsdlEndpoint.getInterface().getName();
            ClientEndpointMetaData epMetaData = new ClientEndpointMetaData(serviceMetaData, portName, interfaceQName);
            epMetaData.setEndpointAddress(wsdlEndpoint.getAddress());
            serviceMetaData.addEndpoint(epMetaData);
            this.initEndpointBinding(wsdlBinding, (EndpointMetaData)epMetaData);
            this.initEndpointEncodingStyle(epMetaData);
            ServiceEndpointInterfaceMapping seiMapping = null;
            if (javaWsdlMapping != null) {
                QName portType = wsdlEndpoint.getInterface().getName();
                seiMapping = javaWsdlMapping.getServiceEndpointInterfaceMappingByPortType(portType);
                if (seiMapping != null) {
                    epMetaData.setServiceEndpointInterfaceName(seiMapping.getServiceEndpointInterface());
                } else {
                    NativeLoggers.ROOT_LOGGER.cannotObtainSEIMappingFor(portType.toString());
                }
            }
            this.setupOperationsFromWSDL(epMetaData, wsdlEndpoint, seiMapping);
            this.setupHandlers(serviceRefMetaData, portName, epMetaData);
        }
    }

    private void setupHandlers(UnifiedServiceRefMetaData serviceRefMetaData, QName portName, EndpointMetaData epMetaData) {
        if (serviceRefMetaData != null) {
            for (UnifiedHandlerMetaData uhmd : serviceRefMetaData.getHandlers()) {
                Set portNames = uhmd.getPortNames();
                if (portNames.size() != 0 && !portNames.contains(portName.getLocalPart())) continue;
                HandlerMetaDataJAXRPC hmd = HandlerMetaDataJAXRPC.newInstance(uhmd, UnifiedHandlerMetaData.HandlerType.ENDPOINT);
                epMetaData.addHandler(hmd);
            }
        }
    }
}

