/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.BigDecimalHolder;
import javax.xml.rpc.holders.BigIntegerHolder;
import javax.xml.rpc.holders.BooleanHolder;
import javax.xml.rpc.holders.BooleanWrapperHolder;
import javax.xml.rpc.holders.ByteArrayHolder;
import javax.xml.rpc.holders.ByteHolder;
import javax.xml.rpc.holders.ByteWrapperHolder;
import javax.xml.rpc.holders.CalendarHolder;
import javax.xml.rpc.holders.DoubleHolder;
import javax.xml.rpc.holders.DoubleWrapperHolder;
import javax.xml.rpc.holders.FloatHolder;
import javax.xml.rpc.holders.FloatWrapperHolder;
import javax.xml.rpc.holders.Holder;
import javax.xml.rpc.holders.IntHolder;
import javax.xml.rpc.holders.IntegerWrapperHolder;
import javax.xml.rpc.holders.LongHolder;
import javax.xml.rpc.holders.LongWrapperHolder;
import javax.xml.rpc.holders.ObjectHolder;
import javax.xml.rpc.holders.QNameHolder;
import javax.xml.rpc.holders.ShortHolder;
import javax.xml.rpc.holders.ShortWrapperHolder;
import javax.xml.rpc.holders.StringHolder;
import org.jboss.ws.NativeMessages;
import org.jboss.ws.common.JavaUtils;

public class HolderUtils {
    public static boolean isHolderType(Class<?> javaType) {
        return Holder.class.isAssignableFrom(javaType);
    }

    public static boolean isHolderType(Type javaType) {
        return HolderUtils.isHolderType(JavaUtils.erasure((Type)javaType));
    }

    public static Class<?> getJAXRPCHolderType(Class<?> valueType) {
        if (valueType == null) {
            throw NativeMessages.MESSAGES.illegalNullArgument("valueType");
        }
        if (Holder.class.isAssignableFrom(valueType)) {
            throw NativeMessages.MESSAGES.alreadyAHolder(valueType.getName());
        }
        if (valueType == BigDecimal.class) {
            return BigDecimalHolder.class;
        }
        if (valueType == BigInteger.class) {
            return BigIntegerHolder.class;
        }
        if (valueType == Boolean.TYPE) {
            return BooleanHolder.class;
        }
        if (valueType == Boolean.class) {
            return BooleanWrapperHolder.class;
        }
        if (valueType == byte[].class) {
            return ByteArrayHolder.class;
        }
        if (valueType == Byte.TYPE) {
            return ByteHolder.class;
        }
        if (valueType == Byte.class) {
            return ByteWrapperHolder.class;
        }
        if (valueType == Calendar.class) {
            return CalendarHolder.class;
        }
        if (valueType == Double.TYPE) {
            return DoubleHolder.class;
        }
        if (valueType == Double.class) {
            return DoubleWrapperHolder.class;
        }
        if (valueType == Float.TYPE) {
            return FloatHolder.class;
        }
        if (valueType == Float.class) {
            return FloatWrapperHolder.class;
        }
        if (valueType == Integer.TYPE) {
            return IntHolder.class;
        }
        if (valueType == Integer.class) {
            return IntegerWrapperHolder.class;
        }
        if (valueType == Long.TYPE) {
            return LongHolder.class;
        }
        if (valueType == Long.class) {
            return LongWrapperHolder.class;
        }
        if (valueType == QName.class) {
            return QNameHolder.class;
        }
        if (valueType == Short.TYPE) {
            return ShortHolder.class;
        }
        if (valueType == Short.class) {
            return ShortWrapperHolder.class;
        }
        if (valueType == String.class) {
            return StringHolder.class;
        }
        if (valueType == Object.class) {
            return ObjectHolder.class;
        }
        return null;
    }

    public static Class getValueType(Type holderType) {
        Field field;
        Class holderClass = JavaUtils.erasure((Type)holderType);
        boolean jaxrpcHolder = Holder.class.isAssignableFrom(holderClass);
        if (!jaxrpcHolder) {
            throw NativeMessages.MESSAGES.notAHolder(holderClass.getName());
        }
        try {
            field = holderClass.getField("value");
        }
        catch (NoSuchFieldException e) {
            throw NativeMessages.MESSAGES.cannotFindOrAccessPublicFieldValue(holderClass);
        }
        return field.getType();
    }

    public static Class getValueType(Class holderClass) {
        Field field;
        boolean jaxrpcHolder = Holder.class.isAssignableFrom(holderClass);
        if (!jaxrpcHolder) {
            throw NativeMessages.MESSAGES.notAHolder(holderClass.getName());
        }
        try {
            field = holderClass.getField("value");
        }
        catch (NoSuchFieldException e) {
            throw NativeMessages.MESSAGES.cannotFindOrAccessPublicFieldValue(holderClass);
        }
        return field.getType();
    }

    public static Object getHolderValue(Object holder) {
        if (holder == null) {
            throw NativeMessages.MESSAGES.illegalNullArgument("holder");
        }
        if (!Holder.class.isInstance(holder)) {
            throw NativeMessages.MESSAGES.notAHolder(holder);
        }
        try {
            Field valueField = holder.getClass().getField("value");
            Object obj = valueField.get(holder);
            return obj;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw NativeMessages.MESSAGES.cannotFindOrAccessPublicFieldValue(holder);
        }
    }

    public static void setHolderValue(Object holder, Object value) {
        if (holder == null) {
            throw NativeMessages.MESSAGES.illegalNullArgument("holder");
        }
        if (!Holder.class.isInstance(holder)) {
            throw NativeMessages.MESSAGES.notAHolder(holder);
        }
        Class valueType = HolderUtils.getValueType(holder.getClass());
        if (value != null && !JavaUtils.isAssignableFrom((Class)valueType, value.getClass())) {
            throw NativeMessages.MESSAGES.holderValueNotAssignable(holder.getClass().getName(), value);
        }
        if (valueType.isArray()) {
            value = JavaUtils.syncArray((Object)value, (Class)valueType);
        }
        try {
            Field valueField = holder.getClass().getField("value");
            if (value != null || !valueType.isPrimitive()) {
                valueField.set(holder, value);
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw NativeMessages.MESSAGES.cannotFindOrAccessPublicFieldValue(holder);
        }
    }

    public static Object createHolderInstance(Object value, Class<?> holderType) {
        Object holder;
        if (!HolderUtils.isHolderType(holderType)) {
            throw NativeMessages.MESSAGES.notAHolder(holderType);
        }
        try {
            holder = holderType.newInstance();
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        HolderUtils.setHolderValue(holder, value);
        return holder;
    }
}

