/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.Service;
import org.jboss.logging.Logger;
import org.jboss.ws.NativeLoggers;
import org.jboss.ws.NativeMessages;
import org.jboss.ws.core.jaxrpc.client.ServiceExt;
import org.jboss.ws.core.jaxrpc.client.ServiceImpl;

public class ServiceProxy
implements InvocationHandler,
Serializable,
Externalizable {
    private static final Logger log = Logger.getLogger(ServiceProxy.class);
    private ServiceImpl jaxrpcService;
    private Class siClass;
    private transient List objectMethods = new ArrayList();
    private transient List jaxrpcServiceMethods = new ArrayList();
    private transient List serviceInterfaceMethods = new ArrayList();
    private transient Method getPortMethod;

    public ServiceProxy() {
    }

    public ServiceProxy(ServiceImpl service, Class siClass) {
        this.jaxrpcService = service;
        this.siClass = siClass;
        this.init();
    }

    private void init() {
        this.objectMethods.addAll(Arrays.asList(Object.class.getMethods()));
        this.jaxrpcServiceMethods.addAll(Arrays.asList(ServiceExt.class.getMethods()));
        if (!this.siClass.getName().equals("javax.xml.rpc.Service")) {
            this.serviceInterfaceMethods.addAll(Arrays.asList(this.siClass.getDeclaredMethods()));
        }
        try {
            this.getPortMethod = Service.class.getMethod("getPort", Class.class);
        }
        catch (NoSuchMethodException e) {
            throw new JAXRPCException(e.toString());
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        try {
            Object retObj = null;
            if (this.jaxrpcServiceMethods.contains(method)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Invoke on jaxrpc service: " + methodName));
                }
                if (method.getName().equals("getPort")) {
                    Remote port = (Remote)method.invoke((Object)this.jaxrpcService, args);
                    return port;
                }
                retObj = method.invoke((Object)this.jaxrpcService, args);
                return retObj;
            }
            if (this.serviceInterfaceMethods.contains(method)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Invoke on service interface: " + methodName));
                }
                Class<?> seiClass = method.getReturnType();
                retObj = this.getPortMethod.invoke((Object)this.jaxrpcService, seiClass);
                return retObj;
            }
            if (this.objectMethods.contains(method)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Invoke on object: " + methodName));
                }
                retObj = method.invoke((Object)this.jaxrpcService, args);
                return retObj;
            }
            throw NativeMessages.MESSAGES.dontKnowHowToInvoke(method);
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    private void handleException(Exception ex) throws Throwable {
        Throwable th = ex;
        if (ex instanceof InvocationTargetException) {
            th = ((InvocationTargetException)ex).getTargetException();
        }
        NativeLoggers.JAXRPC_LOGGER.jaxRpcServiceError(th);
        throw th;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.jaxrpcService);
        out.writeObject(this.siClass);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.jaxrpcService = (ServiceImpl)in.readObject();
        this.siClass = (Class)in.readObject();
        this.init();
    }
}

