/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc.binding.jbossxb;

import java.io.InputStream;
import java.util.HashMap;
import org.jboss.ws.NativeMessages;
import org.jboss.ws.core.jaxrpc.binding.jbossxb.JBossXBSupport;
import org.jboss.ws.core.jaxrpc.binding.jbossxb.JBossXBUnmarshaller;
import org.jboss.ws.core.jaxrpc.binding.jbossxb.UnmarshalException;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;

public class JBossXBUnmarshallerImpl
implements JBossXBUnmarshaller {
    private HashMap<String, Object> properties = new HashMap();

    @Override
    public Object unmarshal(InputStream is) throws UnmarshalException {
        this.assertRequiredProperties();
        Unmarshaller unm = UnmarshallerFactory.newInstance().newUnmarshaller();
        SchemaBinding schemaBinding = JBossXBSupport.getOrCreateSchemaBinding(this.properties);
        try {
            return unm.unmarshal(is, schemaBinding);
        }
        catch (JBossXBException e) {
            throw new UnmarshalException(e.getMessage(), e);
        }
    }

    @Override
    public Object getProperty(String name) {
        if (name == null) {
            throw NativeMessages.MESSAGES.illegalNullArgument("name");
        }
        return this.properties.get(name);
    }

    @Override
    public void setProperty(String name, Object value) {
        if (name == null) {
            throw NativeMessages.MESSAGES.illegalNullArgument("name");
        }
        this.properties.put(name, value);
    }

    private void assertRequiredProperties() {
        if (this.getProperty("org.jboss.xb.xsd.xsmodel") == null) {
            throw NativeMessages.MESSAGES.cannotFindRequiredProperty("org.jboss.xb.xsd.xsmodel");
        }
        if (this.getProperty("org.jboss.xb.java.mapping") == null) {
            throw NativeMessages.MESSAGES.cannotFindRequiredProperty("org.jboss.xb.java.mapping");
        }
    }
}

