/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc;

import java.util.HashMap;
import java.util.Map;
import javax.xml.rpc.encoding.TypeMapping;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import org.jboss.ws.NativeMessages;
import org.jboss.ws.core.binding.TypeMappingImpl;
import org.jboss.ws.core.jaxrpc.EncodedTypeMapping;
import org.jboss.ws.core.jaxrpc.LiteralTypeMapping;

public class TypeMappingRegistryImpl
implements TypeMappingRegistry {
    private Map<String, TypeMappingImpl> typeMappings = new HashMap<String, TypeMappingImpl>();

    public TypeMappingRegistryImpl() {
        this.typeMappings.put("", new LiteralTypeMapping());
        this.typeMappings.put("http://schemas.xmlsoap.org/soap/encoding/", new EncodedTypeMapping());
    }

    public void clear() {
        this.typeMappings.clear();
    }

    public TypeMapping getDefaultTypeMapping() {
        return this.typeMappings.get("");
    }

    public void registerDefault(TypeMapping mapping) {
        throw new UnsupportedOperationException();
    }

    public TypeMapping createTypeMapping() {
        throw new UnsupportedOperationException();
    }

    public TypeMapping getTypeMapping(String encodingStyleURI) {
        this.assertEncodingStyle(encodingStyleURI);
        return this.typeMappings.get(encodingStyleURI);
    }

    public String[] getRegisteredEncodingStyleURIs() {
        return new String[]{"", "http://schemas.xmlsoap.org/soap/encoding/"};
    }

    public TypeMapping register(String encodingStyleURI, TypeMapping mapping) {
        throw new UnsupportedOperationException();
    }

    public TypeMapping unregisterTypeMapping(String encodingStyleURI) {
        throw new UnsupportedOperationException();
    }

    public boolean removeTypeMapping(TypeMapping mapping) {
        throw new UnsupportedOperationException();
    }

    private void assertEncodingStyle(String encURI) {
        if (!"".equals(encURI) && !"http://schemas.xmlsoap.org/soap/encoding/".equals(encURI)) {
            throw NativeMessages.MESSAGES.unsupportedEncodingStyle(encURI);
        }
    }
}

