/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.client.transport;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferInputStream;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

@ChannelHandler.Sharable
public class WSResponseHandler
extends SimpleChannelUpstreamHandler {
    private FutureResult future = new FutureResult();

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (this.future.isCancelled()) {
            return;
        }
        this.future.start();
        try {
            HttpResponse response = (HttpResponse)e.getMessage();
            HttpResponseStatus responseStatus = response.getStatus();
            if (100 == responseStatus.getCode()) {
                return;
            }
            ResultImpl result = new ResultImpl();
            Map<String, Object> metadata = result.getMetadata();
            metadata.put("org.jboss.ws.core.client.transport.NettyClient#Protocol", response.getProtocolVersion());
            metadata.put("org.jboss.ws.core.client.transport.NettyClient#ResponseCode", responseStatus.getCode());
            metadata.put("org.jboss.ws.core.client.transport.NettyClient#ResponseCodeMessage", responseStatus.getReasonPhrase());
            Map<String, Object> responseHeaders = result.getResponseHeaders();
            for (String headerName : response.getHeaderNames()) {
                responseHeaders.put(headerName, response.getHeaders(headerName));
            }
            ChannelBuffer content = response.getContent();
            result.setResponse((InputStream)new ChannelBufferInputStream(content));
            this.future.setResult(result);
            this.future.done();
        }
        catch (Throwable t) {
            this.future.setException(t);
            this.future.done();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        if (this.future.isCancelled()) {
            return;
        }
        this.future.start();
        this.future.setException(e.getCause());
        this.future.done();
    }

    public Future<Result> getFutureResult() {
        return this.future;
    }

    private static class ResultImpl
    implements Result {
        private InputStream is;
        private Map<String, Object> responseHeaders = new HashMap<String, Object>();
        private Map<String, Object> metadata = new HashMap<String, Object>();

        private ResultImpl() {
        }

        @Override
        public InputStream getResponse() {
            return this.is;
        }

        public void setResponse(InputStream is) {
            this.is = is;
        }

        @Override
        public Map<String, Object> getResponseHeaders() {
            return this.responseHeaders;
        }

        public void setResponseHeaders(Map<String, Object> responseHeaders) {
            this.responseHeaders = responseHeaders;
        }

        @Override
        public Map<String, Object> getMetadata() {
            return this.metadata;
        }
    }

    public static interface Result {
        public InputStream getResponse();

        public Map<String, Object> getResponseHeaders();

        public Map<String, Object> getMetadata();
    }

    private static class FutureResult
    implements Future<Result> {
        private volatile Result result;
        private volatile Throwable exception;
        private volatile boolean done = false;
        private volatile boolean cancelled = false;
        private volatile boolean started = false;

        public void setResult(Result result) {
            this.result = result;
        }

        public void setException(Throwable exception) {
            this.exception = exception;
        }

        public void start() {
            this.started = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done() {
            this.done = true;
            FutureResult futureResult = this;
            synchronized (futureResult) {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (!this.started) {
                this.cancelled = true;
                FutureResult futureResult = this;
                synchronized (futureResult) {
                    this.notifyAll();
                }
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Result get() throws InterruptedException, ExecutionException {
            FutureResult futureResult = this;
            synchronized (futureResult) {
                if (!this.done) {
                    this.wait();
                }
            }
            if (this.cancelled) {
                throw new InterruptedException();
            }
            if (this.exception != null) {
                throw new ExecutionException(this.exception);
            }
            return this.result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Result get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            FutureResult futureResult = this;
            synchronized (futureResult) {
                if (!this.done) {
                    unit.timedWait(this, timeout);
                }
            }
            if (this.cancelled) {
                throw new InterruptedException();
            }
            if (!this.done) {
                throw new TimeoutException();
            }
            if (this.exception != null) {
                throw new ExecutionException(this.exception);
            }
            return this.result;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }
    }
}

