/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.client.transport;

import java.io.IOException;
import java.io.OutputStream;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.handler.codec.http.DefaultHttpChunk;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.ws.NativeMessages;

public class NettyTransportOutputStream
extends OutputStream {
    private Channel channel;
    private byte[] buffer;
    private int cur;
    private ChannelFuture future;
    private boolean closed = false;

    public NettyTransportOutputStream(Channel channel, int chunkSize) {
        this.channel = channel;
        if (chunkSize <= 0) {
            throw NativeMessages.MESSAGES.invalidChunkSize(chunkSize);
        }
        this.cur = 0;
        this.buffer = new byte[chunkSize];
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.internalWrite(b);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (len >= this.buffer.length) {
            this.flushBuffer();
            for (int i = 0; i < len; ++i) {
                this.internalWrite(b[off + i]);
            }
            return;
        }
        if (len > this.buffer.length - this.cur) {
            this.flushBuffer();
        }
        System.arraycopy(b, off, this.buffer, this.cur, len);
        this.cur += len;
    }

    private void internalWrite(int b) throws IOException {
        if (this.cur >= this.buffer.length) {
            this.flushBuffer();
        }
        this.buffer[this.cur++] = (byte)b;
    }

    private void flushBuffer() throws IOException {
        if (this.cur > 0) {
            ChannelBuffer content = ChannelBuffers.copiedBuffer((byte[])this.buffer, (int)0, (int)this.cur);
            DefaultHttpChunk chunk = new DefaultHttpChunk(content);
            if (this.future != null) {
                this.future.awaitUninterruptibly();
            }
            this.future = this.channel.write((Object)chunk);
            this.cur = 0;
        }
    }

    @Override
    public synchronized void flush() throws IOException {
    }

    @Override
    public synchronized void close() throws IOException {
        this.flushBuffer();
        if (this.future != null) {
            this.future.awaitUninterruptibly();
        }
        this.future = this.channel.write((Object)HttpChunk.LAST_CHUNK);
        this.closed = true;
    }

    public synchronized ChannelFuture getChannelFuture() {
        if (!this.closed) {
            throw NativeMessages.MESSAGES.cannotGetChannelFuture();
        }
        return this.future;
    }
}

