/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.client.transport;

import java.util.Collection;
import java.util.Map;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpRequestEncoder;
import org.jboss.netty.handler.codec.http.HttpResponseDecoder;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.ws.NativeMessages;
import org.jboss.ws.core.WSTimeoutException;
import org.jboss.ws.core.client.transport.WSResponseHandler;

public class NettyHelper {
    public static final String RESPONSE_HANDLER_NAME = "handler";

    public static ChannelPipelineFactory getChannelPipelineFactory() {
        return NettyHelper.getChannelPipelineFactory(null);
    }

    public static ChannelPipelineFactory getChannelPipelineFactory(SslHandler sslHandler) {
        BasicPipelineFactory factory = new BasicPipelineFactory();
        if (sslHandler != null) {
            factory.setSslHandler((ChannelHandler)sslHandler);
        }
        return factory;
    }

    public static void setResponseHandler(Channel channel, WSResponseHandler responseHandler) {
        ChannelPipeline pipeline = channel.getPipeline();
        pipeline.addLast(RESPONSE_HANDLER_NAME, (ChannelHandler)responseHandler);
    }

    public static void clearResponseHandler(Channel channel) {
        ChannelPipeline pipeline = channel.getPipeline();
        pipeline.remove(RESPONSE_HANDLER_NAME);
    }

    public static void awaitUninterruptibly(ChannelFuture future, Long timeout) throws WSTimeoutException {
        if (timeout != null && timeout > 0L) {
            boolean bool = future.awaitUninterruptibly(timeout.longValue());
            if (!bool) {
                throw NativeMessages.MESSAGES.timeout(timeout);
            }
        } else {
            future.awaitUninterruptibly();
        }
    }

    public static String getFirstHeaderAsString(Map<String, Object> headers, String name) {
        Object obj = headers.get(name);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Collection) {
            Object value = ((Collection)obj).iterator().next();
            return value != null ? value.toString() : null;
        }
        return obj.toString();
    }

    private static class BasicPipelineFactory
    implements ChannelPipelineFactory {
        private static final int MAX_CONTENT_SIZE = 0x40000000;
        private ChannelHandler sslHandler;

        private BasicPipelineFactory() {
        }

        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = Channels.pipeline();
            if (this.sslHandler != null) {
                pipeline.addLast("ssl", this.sslHandler);
            }
            pipeline.addLast("decoder", (ChannelHandler)new HttpResponseDecoder());
            pipeline.addLast("aggregator", (ChannelHandler)new HttpChunkAggregator(0x40000000));
            pipeline.addLast("encoder", (ChannelHandler)new HttpRequestEncoder());
            return pipeline;
        }

        public ChannelHandler getSslHandler() {
            return this.sslHandler;
        }

        public void setSslHandler(ChannelHandler sslHandler) {
            this.sslHandler = sslHandler;
        }
    }
}

