/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core;

import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jboss.logging.Logger;
import org.jboss.ws.NativeMessages;
import org.jboss.ws.common.DOMWriter;
import org.jboss.ws.core.soap.SOAPMessageImpl;
import org.jboss.ws.core.soap.utils.SOAPElementWriter;
import org.jboss.ws.core.soap.utils.XMLFragment;
import org.jboss.ws.core.utils.CachedOutputStream;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.management.ServerConfigFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class MessageTrace {
    private static final Logger msgLog = Logger.getLogger(MessageTrace.class);
    private static ServerConfig serverConfig = null;
    private static boolean serverConfigInit = false;

    private MessageTrace() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void traceMessage(String messagePrefix, Object message) {
        block19: {
            if (!msgLog.isTraceEnabled()) {
                return;
            }
            if (message instanceof SOAPMessage) {
                try {
                    if (message instanceof SOAPMessageImpl) {
                        SOAPEnvelope soapEnv = ((SOAPMessage)message).getSOAPPart().getEnvelope();
                        if (soapEnv != null) {
                            String envStr = SOAPElementWriter.writeElement((SOAPElement)soapEnv, true);
                            msgLog.trace((Object)(messagePrefix + "\n" + envStr));
                        }
                        break block19;
                    }
                    SOAPMessage soapMessage = (SOAPMessage)message;
                    String encoding = (String)soapMessage.getProperty("javax.xml.soap.character-set-encoding");
                    if (encoding == null) {
                        encoding = "UTF-8";
                    }
                    CachedOutputStream os = null;
                    try {
                        os = new CachedOutputStream();
                        os.setThreshold(65536L);
                        os.holdTempFile();
                        ServerConfig sc = MessageTrace.getServerConfig();
                        if (sc != null) {
                            os.setOutputDir(sc.getServerTempDir());
                        }
                        soapMessage.writeTo((OutputStream)os);
                        os.flush();
                        if (os.getTempFile() != null) {
                            msgLog.trace((Object)("SOAP Message saved to tmp file: " + os.getTempFile().getAbsolutePath()));
                        } else {
                            StringBuilder sb = new StringBuilder();
                            MessageTrace.write(sb, os, encoding, soapMessage.getMimeHeaders().getHeader("Content-Type")[0]);
                            msgLog.trace((Object)(messagePrefix + "\n" + sb.toString()));
                        }
                    }
                    finally {
                        if (os != null) {
                            os.close();
                        }
                    }
                }
                catch (Exception ex) {
                    msgLog.error((Object)NativeMessages.MESSAGES.cannotTraceSOAPMessage(), (Throwable)ex);
                }
            } else if (message instanceof byte[]) {
                Element root = new XMLFragment(new StreamSource(new ByteArrayInputStream((byte[])message))).toElement();
                String xmlString = DOMWriter.printNode((Node)root, (boolean)true);
                msgLog.trace((Object)(messagePrefix + "\n" + xmlString));
            } else if (message instanceof String) {
                Element root = new XMLFragment(new StreamSource(new ByteArrayInputStream(((String)message).getBytes()))).toElement();
                String xmlString = DOMWriter.printNode((Node)root, (boolean)true);
                msgLog.trace((Object)(messagePrefix + "\n" + xmlString));
            } else {
                msgLog.warn((Object)NativeMessages.MESSAGES.unsupportedMessageType(message));
            }
        }
    }

    private static void write(StringBuilder builder, CachedOutputStream cos, String encoding, String contentType) throws Exception {
        if (contentType != null && contentType.indexOf("xml") >= 0 && contentType.toLowerCase().indexOf("multipart/related") < 0 && cos.size() > 0L) {
            TransformerFactory tf = TransformerFactory.newInstance();
            try {
                tf.setAttribute("indent-number", 2);
            }
            catch (Throwable t) {
                // empty catch block
            }
            Transformer serializer = tf.newTransformer();
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            StringWriter swriter = new StringWriter();
            serializer.transform(new StreamSource(cos.getInputStream()), new StreamResult(swriter));
            builder.append(swriter.toString());
        } else if (encoding == null || encoding.trim().length() == 0) {
            cos.writeCacheTo(builder, "UTF-8");
        } else {
            cos.writeCacheTo(builder, encoding);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized ServerConfig getServerConfig() {
        if (!serverConfigInit) {
            try {
                ClassLoader cl = ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader();
                SPIProvider spiProvider = SPIProviderResolver.getInstance((ClassLoader)cl).getProvider();
                serverConfig = ((ServerConfigFactory)spiProvider.getSPI(ServerConfigFactory.class, cl)).getServerConfig();
            }
            catch (Exception exception) {
            }
            finally {
                serverConfigInit = true;
            }
        }
        return serverConfig;
    }
}

