/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.configadmin.parser;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.as.configadmin.ConfigAdmin;
import org.jboss.as.configadmin.parser.ConfigAdminExtension;
import org.jboss.as.configadmin.parser.ConfigurationResource;
import org.jboss.as.configadmin.service.ConfigAdminInternal;
import org.jboss.as.configadmin.service.ConfigAdminServiceImpl;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class ConfigurationAdd
extends AbstractAddStepHandler {
    static final ConfigurationAdd INSTANCE = new ConfigurationAdd();
    private InitializeConfigAdminService initializationService;

    private ConfigurationAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        ConfigurationResource.ENTRIES.validateAndSet(operation, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        String pid = operation.get("address").asObject().get("configuration").asString();
        Hashtable<String, String> dictionary = new Hashtable<String, String>(ConfigurationResource.ENTRIES.unwrap(context, model));
        ConfigAdminInternal configAdmin = ConfigAdminExtension.getConfigAdminService(context);
        if (configAdmin != null) {
            configAdmin.putConfigurationInternal(pid, dictionary);
        } else {
            ConfigurationAdd configurationAdd = this;
            synchronized (configurationAdd) {
                if (this.initializationService == null) {
                    this.initializationService = new InitializeConfigAdminService();
                    ServiceBuilder builder = context.getServiceTarget().addService(ServiceName.JBOSS.append(new String[]{"configadmin", "data_initialization"}), (Service)this.initializationService);
                    builder.addDependency(ConfigAdmin.SERVICE_NAME, ConfigAdmin.class, (Injector)this.initializationService.injectedConfigAdminService);
                    builder.install();
                }
            }
            this.initializationService.putConfiguration(pid, dictionary);
        }
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, ModelNode model, List<ServiceController<?>> controllers) {
        String pid = operation.get("address").asObject().get("configuration").asString();
        ConfigAdminInternal configAdmin = ConfigAdminExtension.getConfigAdminService(context);
        if (configAdmin != null) {
            configAdmin.removeConfigurationInternal(pid);
        }
    }

    static class InitializeConfigAdminService
    implements Service<Object> {
        private final Map<String, Dictionary<String, String>> configs = new ConcurrentHashMap<String, Dictionary<String, String>>();
        private final InjectedValue<ConfigAdmin> injectedConfigAdminService = new InjectedValue();

        InitializeConfigAdminService() {
        }

        public Object getValue() throws IllegalStateException, IllegalArgumentException {
            return null;
        }

        public void putConfiguration(String pid, Dictionary<String, String> dictionary) {
            this.configs.put(pid, dictionary);
        }

        public void start(StartContext context) throws StartException {
            for (Map.Entry<String, Dictionary<String, String>> entry : this.configs.entrySet()) {
                ConfigAdminServiceImpl configAdminService = (ConfigAdminServiceImpl)this.injectedConfigAdminService.getValue();
                configAdminService.putConfigurationInternal(entry.getKey(), entry.getValue());
            }
        }

        public void stop(StopContext context) {
        }
    }
}

