/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.web.infinispan;

import java.io.IOException;
import java.io.Serializable;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.infinispan.Cache;
import org.infinispan.affinity.KeyAffinityService;
import org.infinispan.affinity.KeyGenerator;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryActivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryActivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.remoting.transport.Address;
import org.jboss.as.clustering.infinispan.affinity.KeyAffinityServiceFactory;
import org.jboss.as.clustering.infinispan.invoker.CacheInvoker;
import org.jboss.as.clustering.lock.SharedLocalYieldingClusterLockManager;
import org.jboss.as.clustering.registry.Registry;
import org.jboss.as.clustering.web.BatchingManager;
import org.jboss.as.clustering.web.DistributableSessionMetadata;
import org.jboss.as.clustering.web.IncomingDistributableSessionData;
import org.jboss.as.clustering.web.LocalDistributableSessionManager;
import org.jboss.as.clustering.web.OutgoingDistributableSessionData;
import org.jboss.as.clustering.web.SessionOwnershipSupport;
import org.jboss.as.clustering.web.impl.IncomingDistributableSessionDataImpl;
import org.jboss.as.clustering.web.infinispan.InfinispanWebLogger;
import org.jboss.as.clustering.web.infinispan.InfinispanWebMessages;
import org.jboss.as.clustering.web.infinispan.SessionAttributeStorage;
import org.jboss.as.clustering.web.infinispan.SessionMapEntry;

@Listener
public class DistributedCacheManager<T extends OutgoingDistributableSessionData>
implements org.jboss.as.clustering.web.DistributedCacheManager<T>,
SessionOwnershipSupport,
KeyGenerator<String> {
    private static Map<SharedLocalYieldingClusterLockManager.LockResult, SessionOwnershipSupport.LockResult> results = DistributedCacheManager.lockResultMap();
    final SessionAttributeStorage<T> attributeStorage;
    private final LocalDistributableSessionManager manager;
    private final SharedLocalYieldingClusterLockManager lockManager;
    private final Cache<String, Map<Object, Object>> cache;
    private final ForceSynchronousCacheInvoker invoker;
    private final BatchingManager batchingManager;
    private final boolean passivationEnabled;
    private final boolean persistenceEnabled;
    private final Registry<String, Void> registry;
    private final long lockTimeout;
    private final KeyAffinityService<String> affinity;

    private static Map<SharedLocalYieldingClusterLockManager.LockResult, SessionOwnershipSupport.LockResult> lockResultMap() {
        EnumMap<SharedLocalYieldingClusterLockManager.LockResult, SessionOwnershipSupport.LockResult> map = new EnumMap<SharedLocalYieldingClusterLockManager.LockResult, SessionOwnershipSupport.LockResult>(SharedLocalYieldingClusterLockManager.LockResult.class);
        map.put(SharedLocalYieldingClusterLockManager.LockResult.ACQUIRED_FROM_CLUSTER, SessionOwnershipSupport.LockResult.ACQUIRED_FROM_CLUSTER);
        map.put(SharedLocalYieldingClusterLockManager.LockResult.ALREADY_HELD, SessionOwnershipSupport.LockResult.ALREADY_HELD);
        map.put(SharedLocalYieldingClusterLockManager.LockResult.NEW_LOCK, SessionOwnershipSupport.LockResult.NEW_LOCK);
        return map;
    }

    public DistributedCacheManager(LocalDistributableSessionManager manager, Cache<String, Map<Object, Object>> cache, Registry<String, Void> registry, SharedLocalYieldingClusterLockManager lockManager, SessionAttributeStorage<T> attributeStorage, BatchingManager batchingManager, CacheInvoker invoker, KeyAffinityServiceFactory affinityFactory) {
        this.manager = manager;
        this.lockManager = lockManager;
        this.cache = cache;
        this.attributeStorage = attributeStorage;
        this.batchingManager = batchingManager;
        this.invoker = new ForceSynchronousCacheInvoker(invoker);
        this.lockTimeout = this.cache.getCacheConfiguration().locking().lockAcquisitionTimeout();
        Configuration configuration = this.cache.getCacheConfiguration();
        this.passivationEnabled = configuration.loaders().passivation() && !configuration.loaders().shared() && !configuration.loaders().cacheLoaders().isEmpty();
        this.persistenceEnabled = !configuration.loaders().passivation() && !configuration.loaders().cacheLoaders().isEmpty();
        this.registry = registry;
        this.affinity = affinityFactory.createService(cache, (KeyGenerator)this);
    }

    public void start() {
        this.cache.addListener((Object)this);
        this.registry.refreshLocalEntry();
        this.affinity.start();
    }

    public void stop() {
        this.affinity.stop();
        this.cache.removeListener((Object)this);
    }

    public BatchingManager getBatchingManager() {
        return this.batchingManager;
    }

    public void sessionCreated(String sessionId) {
        this.trace("sessionCreated(%s)", sessionId);
    }

    public void storeSessionData(final T sessionData) {
        final String sessionId = sessionData.getRealId();
        this.trace("storeSessionData(%s)", sessionId);
        Operation<Void> operation = new Operation<Void>(){

            public Void invoke(Cache<String, Map<Object, Object>> cache) {
                Map map = (Map)cache.putIfAbsent((Object)sessionId, null);
                SessionMapEntry.VERSION.put(map, sessionData.getVersion());
                SessionMapEntry.METADATA.put(map, sessionData.getMetadata());
                SessionMapEntry.TIMESTAMP.put(map, sessionData.getTimestamp());
                try {
                    DistributedCacheManager.this.attributeStorage.store(map, sessionData);
                }
                catch (IOException e) {
                    throw InfinispanWebMessages.MESSAGES.failedToStoreSessionAttributes(e, sessionId);
                }
                return null;
            }
        };
        this.invoker.invoke(this.cache, operation, new Flag[0]);
    }

    public IncomingDistributableSessionData getSessionData(String sessionId, boolean initialLoad) {
        this.trace("getSessionData(%s, %s)", sessionId, initialLoad);
        return this.getData(sessionId, true);
    }

    public IncomingDistributableSessionData getSessionData(String sessionId, String dataOwner, boolean includeAttributes) {
        this.trace("getSessionData(%s, %s, %s)", sessionId, dataOwner, includeAttributes);
        return dataOwner == null ? this.getData(sessionId, includeAttributes) : null;
    }

    private IncomingDistributableSessionData getData(final String sessionId, final boolean includeAttributes) {
        Operation<IncomingDistributableSessionData> operation = new Operation<IncomingDistributableSessionData>(){

            public IncomingDistributableSessionData invoke(Cache<String, Map<Object, Object>> cache) {
                Map map = (Map)cache.get((Object)sessionId);
                if (map == null) {
                    return null;
                }
                Integer version = (Integer)SessionMapEntry.VERSION.get(map);
                Long timestamp = (Long)SessionMapEntry.TIMESTAMP.get(map);
                DistributableSessionMetadata metadata = (DistributableSessionMetadata)SessionMapEntry.METADATA.get(map);
                IncomingDistributableSessionDataImpl result = new IncomingDistributableSessionDataImpl(version, timestamp, metadata);
                if (includeAttributes) {
                    try {
                        result.setSessionAttributes(DistributedCacheManager.this.attributeStorage.load(map));
                    }
                    catch (Exception e) {
                        throw InfinispanWebMessages.MESSAGES.failedToLoadSessionAttributes(e, sessionId);
                    }
                }
                return result;
            }
        };
        try {
            return this.invoker.invoke(this.cache, operation, new Flag[0]);
        }
        catch (Exception e) {
            InfinispanWebLogger.ROOT_LOGGER.sessionLoadFailed(e, sessionId);
            this.removeSessionLocal(sessionId);
            return null;
        }
    }

    public void removeSession(String sessionId) {
        this.trace("removeSession(%s)", sessionId);
        this.removeSession(sessionId, false);
    }

    public void removeSessionLocal(String sessionId) {
        this.trace("removeSessionLocal(%s)", sessionId);
        this.removeSession(sessionId, true);
    }

    private void removeSession(final String sessionId, boolean local) {
        Operation<Void> operation = new Operation<Void>(){

            public Void invoke(Cache<String, Map<Object, Object>> cache) {
                cache.remove((Object)sessionId);
                return null;
            }
        };
        this.invoker.invoke(this.cache, operation, Flag.SKIP_CACHE_LOAD, local ? Flag.CACHE_MODE_LOCAL : Flag.SKIP_REMOTE_LOOKUP);
    }

    public void removeSessionLocal(String sessionId, String dataOwner) {
        this.trace("removeSessionLocal(%s, dataOwner)", sessionId, dataOwner);
        if (dataOwner == null) {
            this.removeSession(sessionId, true);
        }
    }

    public void evictSession(final String sessionId) {
        this.trace("evictSession(%s)", sessionId);
        Operation<Void> operation = new Operation<Void>(){

            public Void invoke(Cache<String, Map<Object, Object>> cache) {
                cache.evict((Object)sessionId);
                return null;
            }
        };
        this.invoker.invoke(this.cache, operation, Flag.FAIL_SILENTLY);
    }

    public void evictSession(String sessionId, String dataOwner) {
        this.trace("evictSession(%s, %s)", sessionId, dataOwner);
        if (dataOwner == null) {
            this.evictSession(sessionId);
        }
    }

    public Map<String, String> getSessionIds() {
        HashMap<String, String> result = new HashMap<String, String>();
        Operation<Set<String>> operation = new Operation<Set<String>>(){

            public Set<String> invoke(Cache<String, Map<Object, Object>> cache) {
                return cache.keySet();
            }
        };
        for (String sessionId : this.invoker.invoke(this.cache, operation, Flag.SKIP_LOCKING, Flag.SKIP_REMOTE_LOOKUP, Flag.SKIP_CACHE_LOAD)) {
            result.put(sessionId, null);
        }
        return result;
    }

    public boolean isPassivationEnabled() {
        return this.passivationEnabled;
    }

    public boolean isPersistenceEnabled() {
        return this.persistenceEnabled;
    }

    public void setForceSynchronous(boolean forceSynchronous) {
        this.invoker.setForceSynchronous(forceSynchronous);
    }

    public SessionOwnershipSupport getSessionOwnershipSupport() {
        return this.lockManager != null ? this : null;
    }

    public SessionOwnershipSupport.LockResult acquireSessionOwnership(String sessionId, boolean newLock) throws TimeoutException, InterruptedException {
        this.trace("acquireSessionOwnership(%s, %s)", sessionId, newLock);
        SessionOwnershipSupport.LockResult result = results.get(this.lockManager.lock((Serializable)((Object)this.createLockKey(sessionId)), this.lockTimeout, newLock));
        this.trace("acquireSessionOwnership(%s, %s) = %s", sessionId, newLock, result);
        return result != null ? result : SessionOwnershipSupport.LockResult.UNSUPPORTED;
    }

    public void relinquishSessionOwnership(String sessionId, boolean remove) {
        this.trace("relinquishSessionOwnership(%s, %s)", sessionId, remove);
        this.lockManager.unlock((Serializable)((Object)this.createLockKey(sessionId).toString()), remove);
    }

    private String createLockKey(String sessionId) {
        return this.cache.getName() + "/" + sessionId;
    }

    public boolean isLocal(String sessionId) {
        Address location = this.locatePrimaryOwner(sessionId);
        return location.equals(this.cache.getCacheManager().getAddress());
    }

    public String locate(String sessionId) {
        Map.Entry entry;
        Address location = this.locatePrimaryOwner(sessionId);
        if (!location.equals(this.cache.getCacheManager().getAddress())) {
            this.invoker.forceThreadSynchronous();
            entry = this.registry.getRemoteEntry((Object)location);
            if (entry != null) {
                return (String)entry.getKey();
            }
        }
        if ((entry = this.registry.getLocalEntry()) == null) {
            entry = this.registry.refreshLocalEntry();
        }
        return entry != null ? (String)entry.getKey() : null;
    }

    private Address locatePrimaryOwner(String sessionId) {
        DistributionManager dist = this.cache.getAdvancedCache().getDistributionManager();
        return dist != null ? dist.getPrimaryLocation((Object)sessionId) : this.cache.getCacheManager().getAddress();
    }

    public String createSessionId() {
        return (String)this.affinity.getKeyForAddress(this.cache.getCacheManager().getAddress());
    }

    public String getKey() {
        return this.manager.createSessionId();
    }

    @CacheEntryRemoved
    public void removed(CacheEntryRemovedEvent<String, Map<Object, Object>> event) {
        if (event.isPre() || event.isOriginLocal()) {
            return;
        }
        try {
            this.manager.notifyRemoteInvalidation((String)event.getKey());
        }
        catch (Throwable e) {
            InfinispanWebLogger.ROOT_LOGGER.warn(e.getLocalizedMessage(), e);
        }
    }

    @CacheEntryModified
    public void modified(CacheEntryModifiedEvent<String, Map<Object, Object>> event) {
        if (event.isPre() || event.isOriginLocal()) {
            return;
        }
        String sessionId = (String)event.getKey();
        try {
            Map map = (Map)event.getValue();
            if (!map.isEmpty()) {
                boolean updated;
                Integer version = (Integer)SessionMapEntry.VERSION.get(map);
                Long timestamp = (Long)SessionMapEntry.TIMESTAMP.get(map);
                DistributableSessionMetadata metadata = (DistributableSessionMetadata)SessionMapEntry.METADATA.get(map);
                if (version != null && timestamp != null && metadata != null && !(updated = this.manager.sessionChangedInDistributedCache(sessionId, null, version.intValue(), timestamp.longValue(), metadata))) {
                    InfinispanWebLogger.ROOT_LOGGER.versionIdMismatch(version, sessionId);
                }
            }
        }
        catch (Throwable e) {
            InfinispanWebLogger.ROOT_LOGGER.warn(e.getLocalizedMessage(), e);
        }
    }

    @CacheEntryActivated
    public void activated(CacheEntryActivatedEvent<String, Map<Object, Object>> event) {
        if (event.isPre()) {
            return;
        }
        try {
            this.manager.sessionActivated();
        }
        catch (Throwable e) {
            InfinispanWebLogger.ROOT_LOGGER.warn(e.getLocalizedMessage(), e);
        }
    }

    private void trace(String message, Object ... args) {
        InfinispanWebLogger.ROOT_LOGGER.tracef(message, args);
    }

    static class ForceSynchronousCacheInvoker
    implements CacheInvoker {
        private static final ThreadLocal<Boolean> forceThreadSynchronous = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return Boolean.FALSE;
            }
        };
        private final CacheInvoker invoker;
        private volatile boolean forceSynchronous = false;

        ForceSynchronousCacheInvoker(CacheInvoker invoker) {
            this.invoker = invoker;
        }

        void setForceSynchronous(boolean forceSynchronous) {
            this.forceSynchronous = forceSynchronous;
        }

        void forceThreadSynchronous() {
            forceThreadSynchronous.set(Boolean.TRUE);
        }

        public <K, V, R> R invoke(Cache<K, V> cache, CacheInvoker.Operation<K, V, R> operation, Flag ... flags) {
            return (R)this.invoker.invoke(cache, operation, this.forceSynchronous || forceThreadSynchronous.get() != false ? EnumSet.of(Flag.FORCE_SYNCHRONOUS, flags).toArray(new Flag[0]) : flags);
        }
    }

    abstract class Operation<R>
    implements CacheInvoker.Operation<String, Map<Object, Object>, R> {
        Operation() {
        }
    }
}

