/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.ra;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import org.hornetq.ra.HornetQRALogger;
import org.hornetq.ra.HornetQRAMessageProducer;
import org.hornetq.ra.HornetQRASession;

public class HornetQRATopicPublisher
extends HornetQRAMessageProducer
implements TopicPublisher {
    private static boolean trace = HornetQRALogger.LOGGER.isTraceEnabled();

    public HornetQRATopicPublisher(TopicPublisher producer, HornetQRASession session) {
        super((MessageProducer)producer, session);
        if (trace) {
            HornetQRALogger.LOGGER.trace("constructor(" + producer + ", " + session + ")");
        }
    }

    public Topic getTopic() throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getTopic()");
        }
        return ((TopicPublisher)this.producer).getTopic();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.session.lock();
        try {
            if (trace) {
                HornetQRALogger.LOGGER.trace("send " + this + " message=" + message + " deliveryMode=" + deliveryMode + " priority=" + priority + " ttl=" + timeToLive);
            }
            this.checkState();
            ((TopicPublisher)this.producer).publish(message, deliveryMode, priority, timeToLive);
            if (trace) {
                HornetQRALogger.LOGGER.trace("sent " + this + " result=" + message);
            }
        }
        finally {
            this.session.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(Message message) throws JMSException {
        this.session.lock();
        try {
            if (trace) {
                HornetQRALogger.LOGGER.trace("send " + this + " message=" + message);
            }
            this.checkState();
            ((TopicPublisher)this.producer).publish(message);
            if (trace) {
                HornetQRALogger.LOGGER.trace("sent " + this + " result=" + message);
            }
        }
        finally {
            this.session.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(Topic destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.session.lock();
        try {
            if (trace) {
                HornetQRALogger.LOGGER.trace("send " + this + " destination=" + destination + " message=" + message + " deliveryMode=" + deliveryMode + " priority=" + priority + " ttl=" + timeToLive);
            }
            this.checkState();
            ((TopicPublisher)this.producer).publish(destination, message, deliveryMode, priority, timeToLive);
            if (trace) {
                HornetQRALogger.LOGGER.trace("sent " + this + " result=" + message);
            }
        }
        finally {
            this.session.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(Topic destination, Message message) throws JMSException {
        this.session.lock();
        try {
            if (trace) {
                HornetQRALogger.LOGGER.trace("send " + this + " destination=" + destination + " message=" + message);
            }
            this.checkState();
            ((TopicPublisher)this.producer).publish(destination, message);
            if (trace) {
                HornetQRALogger.LOGGER.trace("sent " + this + " result=" + message);
            }
        }
        finally {
            this.session.unlock();
        }
    }
}

