/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.provisioning.number.voxbone;

import com.google.gson.JsonArray;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.mobicents.servlet.restcomm.provisioning.number.api.ContainerConfiguration;
import org.mobicents.servlet.restcomm.provisioning.number.api.PhoneNumber;
import org.mobicents.servlet.restcomm.provisioning.number.api.PhoneNumberParameters;
import org.mobicents.servlet.restcomm.provisioning.number.api.PhoneNumberProvisioningManager;
import org.mobicents.servlet.restcomm.provisioning.number.api.PhoneNumberSearchFilters;

public class VoxbonePhoneNumberProvisioningManager
implements PhoneNumberProvisioningManager {
    private static final Logger logger = Logger.getLogger(VoxbonePhoneNumberProvisioningManager.class);
    private static final String COUNTRY_CODE_PARAM = "countryCodeA3";
    private static final String PAGE_SIZE = "pageSize";
    private static final String PAGE_NUMBER = "pageNumber";
    private static final String CONTENT_TYPE = "application/json";
    protected Boolean telestaxProxyEnabled;
    protected String uri;
    protected String username;
    protected String password;
    protected String searchURI;
    protected String createCartURI;
    protected String voiceURI;
    protected String updateURI;
    protected String cancelURI;
    protected String countriesURI;
    protected String listDidsURI;
    protected String voiceUriId;
    protected Configuration activeConfiguration;
    protected ContainerConfiguration containerConfiguration;

    public void init(Configuration phoneNumberProvisioningConfiguration, Configuration telestaxProxyConfiguration, ContainerConfiguration containerConfiguration) {
        this.containerConfiguration = containerConfiguration;
        this.telestaxProxyEnabled = telestaxProxyConfiguration.getBoolean("enabled", false);
        if (this.telestaxProxyEnabled.booleanValue()) {
            this.uri = telestaxProxyConfiguration.getString("uri");
            this.username = telestaxProxyConfiguration.getString("username");
            this.password = telestaxProxyConfiguration.getString("password");
            this.activeConfiguration = telestaxProxyConfiguration;
        } else {
            Configuration voxboneConfiguration = phoneNumberProvisioningConfiguration.subset("voxbone");
            this.uri = voxboneConfiguration.getString("uri");
            this.username = voxboneConfiguration.getString("username");
            this.password = voxboneConfiguration.getString("password");
            this.activeConfiguration = voxboneConfiguration;
        }
        this.searchURI = this.uri + "/inventory/didgroup";
        this.createCartURI = this.uri + "/ordering/cart";
        this.voiceURI = this.uri + "/configuration/voiceuri";
        this.updateURI = this.uri + "/configuration/configuration";
        this.cancelURI = this.uri + "/ordering/cancel";
        this.countriesURI = this.uri + "/inventory/country";
        this.listDidsURI = this.uri + "/inventory/did";
        Configuration callbackUrlsConfiguration = phoneNumberProvisioningConfiguration.subset("callback-urls");
        Client jerseyClient = Client.create();
        jerseyClient.addFilter((ClientFilter)new HTTPBasicAuthFilter(this.username, this.password));
        WebResource webResource = jerseyClient.resource(this.voiceURI);
        String body = "{\"voiceUri\":{\"voiceUriProtocol\":\"SIP\",\"uri\":\"" + callbackUrlsConfiguration.getString("voice[@url]") + "\"}}";
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)webResource.accept(new String[]{CONTENT_TYPE}).type(CONTENT_TYPE)).put(ClientResponse.class, (Object)body);
        String voiceURIResponse = (String)clientResponse.getEntity(String.class);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("response " + voiceURIResponse));
        }
        JsonParser parser = new JsonParser();
        JsonObject jsonVoiceURIResponse = parser.parse(voiceURIResponse).getAsJsonObject();
        if (clientResponse.getClientResponseStatus() == ClientResponse.Status.OK) {
            JsonObject voxVoiceURI = jsonVoiceURIResponse.get("voiceUri").getAsJsonObject();
            this.voiceUriId = voxVoiceURI.get("voiceUriId").getAsString();
        } else {
            if (clientResponse.getClientResponseStatus() == ClientResponse.Status.UNAUTHORIZED) {
                JsonObject error = jsonVoiceURIResponse.get("errors").getAsJsonArray().get(0).getAsJsonObject();
                throw new IllegalArgumentException(error.get("apiErrorMessage").getAsString());
            }
            webResource = jerseyClient.resource(this.voiceURI);
            clientResponse = (ClientResponse)((WebResource.Builder)webResource.queryParam(PAGE_NUMBER, "0").queryParam(PAGE_SIZE, "300").accept(new String[]{CONTENT_TYPE}).type(CONTENT_TYPE)).get(ClientResponse.class);
            String listVoiceURIResponse = (String)clientResponse.getEntity(String.class);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("response " + listVoiceURIResponse));
            }
            JsonObject jsonListVoiceURIResponse = parser.parse(listVoiceURIResponse).getAsJsonObject();
            JsonObject voxVoiceURI = jsonListVoiceURIResponse.get("voiceUris").getAsJsonArray().get(0).getAsJsonObject();
            this.voiceUriId = voxVoiceURI.get("voiceUriId").getAsString();
        }
    }

    private List<PhoneNumber> toAvailablePhoneNumbers(JsonArray phoneNumbers, PhoneNumberSearchFilters listFilters) {
        Pattern searchPattern = listFilters.getFilterPattern();
        ArrayList<PhoneNumber> numbers = new ArrayList<PhoneNumber>();
        for (int i = 0; i < phoneNumbers.size(); ++i) {
            JsonObject number = phoneNumbers.get(i).getAsJsonObject();
            if (Integer.parseInt(number.get("stock").toString()) <= 0) continue;
            String countryCode = number.get(COUNTRY_CODE_PARAM).getAsString();
            String features = null;
            if (number.get("features") != null) {
                features = number.get("features").toString();
            }
            boolean isVoiceCapable = true;
            boolean isFaxCapable = false;
            boolean isSmsCapable = false;
            if (features.contains("VoxSMS")) {
                isSmsCapable = true;
            }
            if (features.contains("VoxFax")) {
                isFaxCapable = true;
            }
            String friendlyName = number.get(COUNTRY_CODE_PARAM).getAsString();
            if (number.get("cityName") != null && !(number.get("cityName") instanceof JsonNull)) {
                friendlyName = friendlyName + "-" + number.get("cityName").getAsString();
            }
            if (number.get("areaCode") != null && !(number.get("areaCode") instanceof JsonNull)) {
                friendlyName = friendlyName + "-" + number.get("areaCode").getAsString();
            }
            PhoneNumber phoneNumber = new PhoneNumber(friendlyName, number.get("didGroupId").getAsString(), null, null, null, null, null, null, countryCode, Boolean.valueOf(isVoiceCapable), Boolean.valueOf(isSmsCapable), null, Boolean.valueOf(isFaxCapable), null);
            numbers.add(phoneNumber);
        }
        return numbers;
    }

    public List<PhoneNumber> searchForNumbers(String country, PhoneNumberSearchFilters listFilters) {
        Locale locale = new Locale("en", country);
        String iso3Country = locale.getISO3Country();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("searchPattern " + listFilters.getFilterPattern()));
        }
        Client jerseyClient = Client.create();
        jerseyClient.addFilter((ClientFilter)new HTTPBasicAuthFilter(this.username, this.password));
        WebResource webResource = jerseyClient.resource(this.searchURI);
        webResource = webResource.queryParam(COUNTRY_CODE_PARAM, iso3Country);
        if (listFilters.getAreaCode() != null) {
            webResource = webResource.queryParam("areaCode", listFilters.getAreaCode());
        }
        if (listFilters.getInRateCenter() != null) {
            webResource = webResource.queryParam("rateCenter", listFilters.getInRateCenter());
        }
        if (listFilters.getSmsEnabled() != null) {
            webResource = webResource.queryParam("featureIds", "6");
        }
        if (listFilters.getFaxEnabled() != null) {
            webResource = webResource.queryParam("featureIds", "25");
        }
        webResource = listFilters.getRangeIndex() != -1 ? webResource.queryParam(PAGE_NUMBER, "" + listFilters.getRangeIndex()) : webResource.queryParam(PAGE_NUMBER, "0");
        webResource = listFilters.getRangeSize() != -1 ? webResource.queryParam(PAGE_SIZE, "" + listFilters.getRangeSize()) : webResource.queryParam(PAGE_SIZE, "50");
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)webResource.accept(new String[]{CONTENT_TYPE}).type(CONTENT_TYPE)).get(ClientResponse.class);
        String response = (String)clientResponse.getEntity(String.class);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("response " + response));
        }
        JsonParser parser = new JsonParser();
        JsonObject jsonResponse = parser.parse(response).getAsJsonObject();
        JsonArray voxboneNumbers = jsonResponse.getAsJsonArray("didGroups");
        List<PhoneNumber> numbers = this.toAvailablePhoneNumbers(voxboneNumbers, listFilters);
        return numbers;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean buyNumber(PhoneNumber phoneNumberObject, PhoneNumberParameters phoneNumberParameters) {
        String phoneNumber = phoneNumberObject.getPhoneNumber();
        Client jerseyClient = Client.create();
        jerseyClient.addFilter((ClientFilter)new HTTPBasicAuthFilter(this.username, this.password));
        WebResource webResource = jerseyClient.resource(this.createCartURI);
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)webResource.accept(new String[]{CONTENT_TYPE}).type(CONTENT_TYPE)).put(ClientResponse.class, (Object)"{}");
        String createCartResponse = (String)clientResponse.getEntity(String.class);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("createCartResponse " + createCartResponse));
        }
        JsonParser parser = new JsonParser();
        JsonObject jsonCreateCartResponse = parser.parse(createCartResponse).getAsJsonObject();
        JsonObject voxCart = jsonCreateCartResponse.get("cart").getAsJsonObject();
        String cartIdentifier = voxCart.get("cartIdentifier").getAsString();
        try {
            Client addToCartJerseyClient = Client.create();
            addToCartJerseyClient.addFilter((ClientFilter)new HTTPBasicAuthFilter(this.username, this.password));
            WebResource addToCartWebResource = addToCartJerseyClient.resource(this.createCartURI + "/" + cartIdentifier + "/product");
            String addToCartBody = "{\"didCartItem\":{\"didGroupId\":\"" + phoneNumber + "\",\"quantity\":\"1\"}}";
            ClientResponse addToCartResponse = (ClientResponse)((WebResource.Builder)addToCartWebResource.accept(new String[]{CONTENT_TYPE}).type(CONTENT_TYPE)).post(ClientResponse.class, (Object)addToCartBody);
            if (addToCartResponse.getClientResponseStatus() == ClientResponse.Status.OK) {
                JsonObject jsonCheckoutCartResponse;
                JsonObject jsonAddToCartResponse;
                String addToCartResponseString = (String)addToCartResponse.getEntity(String.class);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("addToCartResponse " + addToCartResponseString));
                }
                if (!(jsonAddToCartResponse = parser.parse(addToCartResponseString).getAsJsonObject()).get("status").getAsString().equalsIgnoreCase("SUCCESS")) return false;
                Client checkoutCartJerseyClient = Client.create();
                checkoutCartJerseyClient.addFilter((ClientFilter)new HTTPBasicAuthFilter(this.username, this.password));
                WebResource checkoutCartWebResource = checkoutCartJerseyClient.resource(this.createCartURI + "/" + cartIdentifier + "/checkout");
                ClientResponse checkoutCartResponse = (ClientResponse)((WebResource.Builder)checkoutCartWebResource.queryParam("cartIdentifier", cartIdentifier).accept(new String[]{CONTENT_TYPE}).type(CONTENT_TYPE)).get(ClientResponse.class);
                if (checkoutCartResponse.getClientResponseStatus() != ClientResponse.Status.OK) return false;
                String checkoutCartResponseString = (String)checkoutCartResponse.getEntity(String.class);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("checkoutCartResponse " + checkoutCartResponseString));
                }
                if (!(jsonCheckoutCartResponse = parser.parse(checkoutCartResponseString).getAsJsonObject()).get("status").getAsString().equalsIgnoreCase("SUCCESS")) return false;
                String orderReference = jsonCheckoutCartResponse.get("productCheckoutList").getAsJsonArray().get(0).getAsJsonObject().get("orderReference").getAsString();
                Client listDidsJerseyClient = Client.create();
                listDidsJerseyClient.addFilter((ClientFilter)new HTTPBasicAuthFilter(this.username, this.password));
                WebResource listDidsWebResource = listDidsJerseyClient.resource(this.listDidsURI);
                ClientResponse listDidsResponse = (ClientResponse)((WebResource.Builder)listDidsWebResource.queryParam("orderReference", orderReference).queryParam(PAGE_NUMBER, "0").queryParam(PAGE_SIZE, "50").accept(new String[]{CONTENT_TYPE}).type(CONTENT_TYPE)).get(ClientResponse.class);
                if (listDidsResponse.getClientResponseStatus() != ClientResponse.Status.OK) return false;
                String listDidsResponseString = (String)listDidsResponse.getEntity(String.class);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("listDidsResponse " + listDidsResponseString));
                }
                JsonObject jsonListDidsResponse = parser.parse(listDidsResponseString).getAsJsonObject();
                JsonObject dids = jsonListDidsResponse.get("dids").getAsJsonArray().get(0).getAsJsonObject();
                String didId = dids.get("didId").getAsString();
                String e164 = dids.get("e164").getAsString();
                phoneNumberObject.setFriendlyName(didId);
                phoneNumberObject.setPhoneNumber(e164);
                this.updateNumber(phoneNumberObject, phoneNumberParameters);
                return true;
            }
            if (!logger.isDebugEnabled()) return false;
            logger.debug((Object)("Couldn't buy Phone Number " + phoneNumber + ". Response status was: " + addToCartResponse.getClientResponseStatus()));
            return false;
        }
        catch (Exception e) {
            logger.warn((Object)("Couldn't reach uri for buying Phone Numbers" + this.uri), (Throwable)e);
        }
        return false;
    }

    public boolean updateNumber(PhoneNumber phoneNumberObj, PhoneNumberParameters phoneNumberParameters) {
        String phoneNumber = phoneNumberObj.getFriendlyName();
        Client jerseyClient = Client.create();
        jerseyClient.addFilter((ClientFilter)new HTTPBasicAuthFilter(this.username, this.password));
        WebResource webResource = jerseyClient.resource(this.updateURI);
        String body = "{\"didIds\":[\"" + phoneNumber + "\"],\"voiceUriId\":\"" + this.voiceUriId + "\"}";
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)webResource.accept(new String[]{CONTENT_TYPE}).type(CONTENT_TYPE)).post(ClientResponse.class, (Object)body);
        String voiceURIResponse = (String)clientResponse.getEntity(String.class);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("response " + voiceURIResponse));
        }
        return clientResponse.getClientResponseStatus() == ClientResponse.Status.OK;
    }

    public boolean cancelNumber(PhoneNumber phoneNumberObj) {
        String phoneNumber = phoneNumberObj.getFriendlyName();
        Client jerseyClient = Client.create();
        jerseyClient.addFilter((ClientFilter)new HTTPBasicAuthFilter(this.username, this.password));
        WebResource webResource = jerseyClient.resource(this.cancelURI);
        String body = "{\"didIds\":[\"" + phoneNumber + "\"]}";
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)webResource.accept(new String[]{CONTENT_TYPE}).type(CONTENT_TYPE)).post(ClientResponse.class, (Object)body);
        String response = (String)clientResponse.getEntity(String.class);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("response " + response));
        }
        return clientResponse.getClientResponseStatus() == ClientResponse.Status.OK;
    }

    public List<String> getAvailableCountries() {
        Client jerseyClient = Client.create();
        jerseyClient.addFilter((ClientFilter)new HTTPBasicAuthFilter(this.username, this.password));
        WebResource webResource = jerseyClient.resource(this.countriesURI);
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)webResource.queryParam(PAGE_NUMBER, "0").queryParam(PAGE_SIZE, "300").accept(new String[]{CONTENT_TYPE}).type(CONTENT_TYPE)).get(ClientResponse.class);
        String response = (String)clientResponse.getEntity(String.class);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("response " + response));
        }
        JsonParser parser = new JsonParser();
        JsonObject jsonResponse = parser.parse(response).getAsJsonObject();
        JsonArray voxCountries = jsonResponse.get("countries").getAsJsonArray();
        ArrayList<String> countries = new ArrayList<String>();
        for (int i = 0; i < voxCountries.size(); ++i) {
            JsonObject country = voxCountries.get(i).getAsJsonObject();
            String countryCode = country.get(COUNTRY_CODE_PARAM).getAsString();
            countries.add(countryCode);
        }
        return countries;
    }
}

