/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups;

import java.util.concurrent.atomic.AtomicInteger;
import org.jgroups.util.ThreadFactory;

public class ThreadFactoryAdapter
implements ThreadFactory {
    private final java.util.concurrent.ThreadFactory factory;
    private final String baseName;
    private final AtomicInteger counter = new AtomicInteger();
    private volatile boolean includeClusterName = false;
    private volatile boolean includeAddress = false;
    private volatile String clusterName;
    private volatile String address;

    public ThreadFactoryAdapter(java.util.concurrent.ThreadFactory factory) {
        this(factory, null);
    }

    public ThreadFactoryAdapter(java.util.concurrent.ThreadFactory factory, String baseName) {
        this.factory = factory;
        this.baseName = baseName;
    }

    public Thread newThread(Runnable r) {
        return this.newThread(r, this.baseName);
    }

    public Thread newThread(Runnable r, String name) {
        return this.renameThread(this.factory.newThread(r), name);
    }

    public Thread newThread(ThreadGroup group, Runnable r, String name) {
        return this.newThread(r, name);
    }

    public void setPattern(String pattern) {
        if (pattern != null) {
            this.includeClusterName = pattern.contains("c");
            this.includeAddress = pattern.contains("l");
        }
    }

    public void setIncludeClusterName(boolean includeClusterName) {
        this.includeClusterName = includeClusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void renameThread(String baseName, Thread thread) {
        if (thread == null) {
            return;
        }
        StringBuilder builder = new StringBuilder(baseName != null ? baseName : thread.getName()).append('-').append(this.counter.incrementAndGet());
        if (this.includeClusterName && this.clusterName != null) {
            builder.append(',').append(this.clusterName);
        }
        if (this.includeAddress && this.address != null) {
            builder.append(',').append(this.address);
        }
        thread.setName(builder.toString());
    }

    private Thread renameThread(Thread thread, String name) {
        this.renameThread(name, thread);
        return thread;
    }
}

