/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.recovery.transactions;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.internal.jts.orbspecific.coordinator.ArjunaTransactionImple;
import com.arjuna.ats.internal.jts.orbspecific.interposition.coordinator.ServerTransaction;
import com.arjuna.ats.internal.jts.recovery.transactions.AssumedCompleteServerTransaction;
import com.arjuna.ats.internal.jts.recovery.transactions.AssumedCompleteTransaction;
import com.arjuna.ats.internal.jts.recovery.transactions.RecoveredServerTransaction;
import com.arjuna.ats.internal.jts.recovery.transactions.RecoveredTransaction;
import com.arjuna.ats.internal.jts.recovery.transactions.RecoveringTransaction;
import com.arjuna.ats.internal.jts.recovery.transactions.RecoveryStatus;
import com.arjuna.ats.jts.logging.jtsLogger;
import org.omg.CosTransactions.Status;

class TransactionCacheItem {
    private Uid _uid;
    private RecoveringTransaction _transaction;
    private String _type;
    private int _attempts;
    private Status _knownStatus;

    TransactionCacheItem(Uid uid, String type) {
        this._uid = new Uid(uid);
        this._type = type;
        this._attempts = 0;
        this._knownStatus = Status.StatusNoTransaction;
        this.loadTransaction(true);
    }

    private boolean loadTransaction(boolean firstLoad) {
        if (this._type.equals(ArjunaTransactionImple.typeName())) {
            AssumedCompleteTransaction assumed;
            this._transaction = new RecoveredTransaction(this._uid);
            if (firstLoad && this._transaction.getRecoveryStatus() == RecoveryStatus.ACTIVATE_FAILED && (assumed = new AssumedCompleteTransaction(this._uid)).getRecoveryStatus() != RecoveryStatus.ACTIVATE_FAILED) {
                if (jtsLogger.logger.isDebugEnabled()) {
                    jtsLogger.logger.debug((Object)("Transaction " + this._uid + " previously assumed complete"));
                }
                this._transaction = assumed;
                this._type = this._transaction.type();
            }
        } else if (this._type.equals(ServerTransaction.typeName())) {
            AssumedCompleteServerTransaction assumed;
            this._transaction = new RecoveredServerTransaction(this._uid);
            if (firstLoad && this._transaction.getRecoveryStatus() == RecoveryStatus.ACTIVATE_FAILED && (assumed = new AssumedCompleteServerTransaction(this._uid)).getRecoveryStatus() != RecoveryStatus.ACTIVATE_FAILED) {
                if (jtsLogger.logger.isDebugEnabled()) {
                    jtsLogger.logger.debug((Object)("Transaction " + this._uid + " previously assumed complete"));
                }
                this._transaction = assumed;
                this._type = this._transaction.type();
            }
        } else if (this._type.equals(AssumedCompleteTransaction.typeName())) {
            this._transaction = new AssumedCompleteTransaction(this._uid);
        } else if (this._type.equals(AssumedCompleteServerTransaction.typeName())) {
            this._transaction = new AssumedCompleteServerTransaction(this._uid);
        } else {
            jtsLogger.i18NLogger.warn_recovery_transactions_TransactionCacheItem_2(this._type);
            this._transaction = null;
            return false;
        }
        return true;
    }

    void updateType() {
        this._type = this._transaction.type();
    }

    void clearTransaction() {
        this._transaction = null;
    }

    RecoveringTransaction transaction() {
        return this._transaction;
    }

    RecoveringTransaction freshTransaction() {
        if (this._transaction == null || this._transaction.getRecoveryStatus() == RecoveryStatus.REPLAYED) {
            this.loadTransaction(false);
        }
        return this._transaction;
    }

    int countAttempts() {
        return this._attempts++;
    }

    void resetAttemptCount() {
        this._attempts = 0;
    }

    void setStatus(Status status) {
        this._knownStatus = status;
    }

    Status getStatus() {
        return this._knownStatus;
    }
}

