/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.config;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.v3.client.config.UDDIClerkManager;
import org.apache.juddi.v3.client.config.WebHelper;

public class UDDIClerkServlet
extends HttpServlet {
    private static final long serialVersionUID = -91998529871296125L;
    private Log logger = LogFactory.getLog(UDDIClerkServlet.class);
    private UDDIClerkManager manager = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this.manager = WebHelper.getUDDIClerkManager(config.getServletContext());
        }
        catch (Exception e) {
            this.logger.error((Object)("UDDI-client could not be started for manager " + this.manager.getName() + ". " + e.getMessage()), (Throwable)e);
        }
        catch (Throwable t) {
            this.logger.error((Object)("UDDI-client could not be started." + t.getMessage()), t);
        }
    }

    public void destroy() {
        try {
            this.manager.stop();
        }
        catch (Exception e) {
            this.logger.error((Object)("UDDI-Clerk Manager could not be stopped for manager " + this.manager.getName() + ". " + e.getMessage()), (Throwable)e);
        }
        catch (Throwable t) {
            this.logger.error((Object)("UDDI-client could not be stopped." + t.getMessage()), t);
        }
        super.destroy();
    }
}

