/*
 * Decompiled with CFR 0.152.
 */
package jain.protocol.ip.mgcp.pkg;

import java.io.Serializable;
import java.util.Hashtable;

public class PackageName
implements Serializable {
    private int packageValue = 0;
    private String packageName = null;
    private static Hashtable byName = new Hashtable();
    private static Hashtable byValue = new Hashtable();
    private static int LargestPackageValue = 117;
    public static final int USER_DEFINED_PACKAGE_START_VALUE = 118;
    public static final int GENERIC_MEDIA = 1;
    public static final PackageName GenericMedia = PackageName.factory("G", 1);
    public static final int DTMF = 2;
    public static final PackageName Dtmf = PackageName.factory("D", 2);
    public static final int MF = 3;
    public static final PackageName Mf = PackageName.factory("M", 3);
    public static final int TRUNK = 4;
    public static final PackageName Trunk = PackageName.factory("T", 4);
    public static final int LINE = 5;
    public static final PackageName Line = PackageName.factory("L", 5);
    public static final int HANDSET = 6;
    public static final PackageName Handset = PackageName.factory("H", 6);
    public static final int RTP = 7;
    public static final PackageName Rtp = PackageName.factory("R", 7);
    public static final int NAS = 8;
    public static final PackageName Nas = PackageName.factory("N", 8);
    public static final int ANNOUNCEMENT = 9;
    public static final PackageName Announcement = PackageName.factory("A", 9);
    public static final int SCRIPT = 10;
    public static final PackageName Script = PackageName.factory("Script", 10);
    public static final int ALL_PACKAGES = 11;
    public static final PackageName AllPackages = PackageName.factory("*", 11);

    private PackageName(String packageName, int packageValue) {
        this.packageName = packageName;
        this.packageValue = packageValue;
    }

    public static PackageName factory(String packageName, int packageValue) throws IllegalArgumentException {
        PackageName pkgObj = null;
        PackageName byN = (PackageName)byName.get(packageName);
        Integer pkgv = new Integer(packageValue);
        PackageName byV = (PackageName)byValue.get(pkgv);
        if (byN == null && byV == null) {
            LargestPackageValue = packageValue;
            pkgObj = new PackageName(packageName, LargestPackageValue);
            byName.put(packageName, pkgObj);
            byValue.put(pkgv, pkgObj);
            return pkgObj;
        }
        if (byN == byV) {
            return byN;
        }
        if (byN != null) {
            if (byV == null) {
                throw new IllegalArgumentException("Event name " + packageName + " is already assigned event value " + byN.packageValue);
            }
            throw new IllegalArgumentException("Event name " + packageName + " is already assigned event value " + byN.packageValue + " and event name " + byV.packageName + " is already assigned event value " + packageValue);
        }
        throw new IllegalArgumentException("Event name " + byV.packageName + "is already assigned event value " + packageValue);
    }

    public static PackageName factory(String packageName) {
        PackageName pkgObj = null;
        PackageName byN = (PackageName)byName.get(packageName);
        if (byN == null) {
            pkgObj = new PackageName(packageName, ++LargestPackageValue);
            byName.put(packageName, pkgObj);
            byValue.put(new Integer(LargestPackageValue), pkgObj);
            return pkgObj;
        }
        return byN;
    }

    public static int getCurrentLargestPackageValue() {
        return LargestPackageValue;
    }

    public int intValue() {
        return this.packageValue;
    }

    public String toString() {
        return this.packageName;
    }
}

