/*
 * Decompiled with CFR 0.152.
 */
package jain.protocol.ip.mgcp.message.parms;

import java.io.Serializable;

public final class ConnectionIdentifier
implements Serializable {
    public static final ConnectionIdentifier AnyConnection = new ConnectionIdentifier("$", null);
    public static final ConnectionIdentifier AllConnections = new ConnectionIdentifier("*", null);
    private String connectionIdentifier = null;

    private ConnectionIdentifier(String connectionIdentifier, String dummy) {
        this.connectionIdentifier = connectionIdentifier;
    }

    public ConnectionIdentifier(String connectionIdentifier) throws IllegalArgumentException {
        this.setConnectionIdentifier(connectionIdentifier);
    }

    public void setConnectionIdentifier(String connectionIdentifier) throws IllegalArgumentException {
        int connectionIdLen = connectionIdentifier.length();
        if (connectionIdLen == 0 || connectionIdLen > 32) {
            throw new IllegalArgumentException("Connection Identifier must be between 1 and 32 characters long.");
        }
        char[] connectionIdCharArray = connectionIdentifier.toCharArray();
        int i = 0;
        while (i < connectionIdLen) {
            if (Character.digit(connectionIdCharArray[i], 16) == -1) {
                throw new IllegalArgumentException("Connection Identifier must contain only characters that represent hexadecimal digits.");
            }
            ++i;
        }
        this.connectionIdentifier = connectionIdentifier;
    }

    public String toString() {
        return this.connectionIdentifier;
    }
}

