/*
 * Decompiled with CFR 0.152.
 */
package jain.protocol.ip.mgcp.message.parms;

import java.io.Serializable;

public final class CallIdentifier
implements Serializable {
    private String callIdentifier = null;

    public CallIdentifier(String callIdentifier) throws IllegalArgumentException {
        this.setCallIdentifier(callIdentifier);
    }

    public void setCallIdentifier(String callIdentifier) throws IllegalArgumentException {
        int callIdLen = callIdentifier.length();
        if (callIdLen == 0 || callIdLen > 32) {
            throw new IllegalArgumentException("Call Identifier must be between 1 and 32 characters long.");
        }
        char[] callIdCharArray = callIdentifier.toCharArray();
        int i = 0;
        while (i < callIdLen) {
            if (Character.digit(callIdCharArray[i], 16) == -1) {
                throw new IllegalArgumentException("Call Identifier must contain only characters that represent hexadecimal digits.");
            }
            ++i;
        }
        this.callIdentifier = callIdentifier;
    }

    public String toString() {
        return this.callIdentifier;
    }
}

