/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.CommonLogger;
import gov.nist.core.StackLogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class WebSocketCodec {
    private static StackLogger logger = CommonLogger.getLogger(WebSocketCodec.class);
    private static final byte OPCODE_CONT = 0;
    private static final byte OPCODE_TEXT = 1;
    private static final byte OPCODE_BINARY = 2;
    private static final byte OPCODE_CLOSE = 8;
    private static final byte OPCODE_PING = 9;
    private static final byte OPCODE_PONG = 10;
    private int fragmentedFramesCount;
    private boolean frameFinalFlag;
    private int frameRsv;
    private int frameOpcode;
    private long framePayloadLength;
    private byte[] maskingKey = new byte[4];
    private final boolean allowExtensions;
    private final boolean maskedPayload;
    State state = null;
    byte[] framePayload = new byte[66000];
    int payloadIndex = 0;

    public WebSocketCodec(boolean maskedPayload, boolean allowExtensions) {
        this.state = State.FRAME_START;
        this.maskedPayload = maskedPayload;
        this.allowExtensions = allowExtensions;
    }

    protected byte[] decode(InputStream is) throws Exception {
        switch (this.state) {
            case FRAME_START: {
                this.framePayloadLength = -1L;
                byte b = (byte)is.read();
                this.frameFinalFlag = (b & 0x80) != 0;
                this.frameRsv = (b & 0x70) >> 4;
                this.frameOpcode = b & 0xF;
                logger.logDebug("Decoding WebSocket Frame opCode=" + this.frameOpcode);
                b = (byte)is.read();
                boolean frameMasked = (b & 0x80) != 0;
                int framePayloadLen1 = b & 0x7F;
                if (this.frameRsv != 0 && !this.allowExtensions) {
                    this.protocolViolation("RSV != 0 and no extension negotiated, RSV:" + this.frameRsv);
                    return null;
                }
                if (this.maskedPayload && !frameMasked) {
                    this.protocolViolation("unmasked client to server frame");
                    return null;
                }
                if (this.frameOpcode > 7) {
                    if (!this.frameFinalFlag) {
                        this.protocolViolation("fragmented control frame");
                        return null;
                    }
                    if (framePayloadLen1 > 125) {
                        this.protocolViolation("control frame with payload length > 125 octets");
                        return null;
                    }
                    if (this.frameOpcode != 8 && this.frameOpcode != 9 && this.frameOpcode != 10) {
                        this.protocolViolation("control frame using reserved opcode " + this.frameOpcode);
                        return null;
                    }
                    if (this.frameOpcode == 8 && framePayloadLen1 == 1) {
                        this.protocolViolation("received close control frame with payload len 1");
                        return null;
                    }
                } else {
                    if (this.frameOpcode != 0 && this.frameOpcode != 1 && this.frameOpcode != 2) {
                        this.protocolViolation("data frame using reserved opcode " + this.frameOpcode);
                        return null;
                    }
                    if (this.fragmentedFramesCount == 0 && this.frameOpcode == 0) {
                        this.protocolViolation("received continuation data frame outside fragmented message");
                        return null;
                    }
                    if (this.fragmentedFramesCount != 0 && this.frameOpcode != 0 && this.frameOpcode != 9) {
                        this.protocolViolation("received non-continuation data frame while inside fragmented message");
                        return null;
                    }
                }
                if (framePayloadLen1 == 126) {
                    int byte1 = is.read();
                    int byte2 = is.read();
                    int value = byte1 << 8 | byte2;
                    this.framePayloadLength = value;
                } else if (framePayloadLen1 == 127) {
                    long value = 0L;
                    for (int q = 0; q < 8; ++q) {
                        value &= (long)(is.read() << 7 - q);
                    }
                    this.framePayloadLength = value;
                    if (this.framePayloadLength < 65536L) {
                        this.protocolViolation("invalid data frame length (not using minimal length encoding)");
                        return null;
                    }
                } else {
                    this.framePayloadLength = framePayloadLen1;
                }
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Decoding WebSocket Frame length=" + this.framePayloadLength);
                }
                this.state = State.MASKING_KEY;
            }
            case MASKING_KEY: {
                if (this.maskedPayload) {
                    for (int q = 0; q < 4; ++q) {
                        this.maskingKey[q] = (byte)is.read();
                    }
                }
                this.state = State.PAYLOAD;
            }
            case PAYLOAD: {
                this.payloadIndex += is.read(this.framePayload, this.payloadIndex, this.framePayload.length - this.payloadIndex);
                if ((long)this.payloadIndex < this.framePayloadLength) {
                    return null;
                }
                this.payloadIndex = 0;
                if (this.maskedPayload) {
                    this.unmask(this.framePayload);
                }
                byte[] msg = new byte[(int)this.framePayloadLength];
                System.arraycopy(this.framePayload, 0, msg, 0, (int)this.framePayloadLength);
                this.state = State.FRAME_START;
                return msg;
            }
            case CORRUPT: {
                return null;
            }
        }
        throw new Error("Shouldn't reach here.");
    }

    protected static byte[] encode(byte[] msg, int rsv, boolean fin) throws Exception {
        boolean maskPayload = false;
        ByteArrayOutputStream frame = new ByteArrayOutputStream();
        int opcode = 1;
        int length = msg.length;
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Encoding WebSocket Frame opCode=" + opcode + " length=" + length);
        }
        int b0 = 0;
        if (fin) {
            b0 |= 0x80;
        }
        b0 |= rsv % 8 << 4;
        b0 |= opcode % 128;
        if (length <= 125) {
            frame.write(b0);
            byte b = maskPayload ? (byte)(0x80 | (byte)length) : (byte)length;
            frame.write(b);
        } else if (length <= 65535) {
            frame.write(b0);
            frame.write(maskPayload ? 254 : 126);
            frame.write(length >>> 8 & 0xFF);
            frame.write(length & 0xFF);
        } else {
            frame.write(b0);
            frame.write(maskPayload ? 255 : 127);
            for (int q = 0; q < 8; ++q) {
                frame.write(0xFF & length >> q);
            }
        }
        frame.write(msg);
        return frame.toByteArray();
    }

    private void unmask(byte[] frame) {
        for (int i = 0; i < frame.length; ++i) {
            frame[i] = (byte)(frame[i] ^ this.maskingKey[i % 4]);
        }
    }

    public byte readByte(InputStream is) throws IOException {
        byte value = (byte)(0xFF & is.read());
        return value;
    }

    private void protocolViolation(String reason) {
        this.state = State.CORRUPT;
        throw new RuntimeException(reason);
    }

    public static enum State {
        FRAME_START,
        MASKING_KEY,
        PAYLOAD,
        CORRUPT;

    }
}

