/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.CommonLogger;
import gov.nist.core.Host;
import gov.nist.core.HostPort;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.stack.NIOHandler;
import gov.nist.javax.sip.stack.NioTcpMessageChannel;
import gov.nist.javax.sip.stack.NioTcpMessageProcessor;
import gov.nist.javax.sip.stack.NioWebSocketMessageProcessor;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.WebSocketCodec;
import gov.nist.javax.sip.stack.WebSocketHttpHandshake;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.channels.SocketChannel;
import java.text.ParseException;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.ContactHeader;
import javax.sip.header.RecordRouteHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Request;

public class NioWebSocketMessageChannel
extends NioTcpMessageChannel {
    private static StackLogger logger = CommonLogger.getLogger(NioWebSocketMessageChannel.class);
    private WebSocketCodec codec = new WebSocketCodec(true, true);

    public static NioWebSocketMessageChannel create(NioWebSocketMessageProcessor nioTcpMessageProcessor, SocketChannel socketChannel) throws IOException {
        NioWebSocketMessageChannel retval = (NioWebSocketMessageChannel)channelMap.get(socketChannel);
        if (retval == null) {
            retval = new NioWebSocketMessageChannel(nioTcpMessageProcessor, socketChannel);
            channelMap.put(socketChannel, retval);
        }
        return retval;
    }

    protected NioWebSocketMessageChannel(NioTcpMessageProcessor nioTcpMessageProcessor, SocketChannel socketChannel) throws IOException {
        super(nioTcpMessageProcessor, socketChannel);
        this.messageProcessor = nioTcpMessageProcessor;
        this.myClientInputStream = socketChannel.socket().getInputStream();
    }

    @Override
    protected void sendMessage(byte[] msg, boolean isClient) throws IOException {
        super.sendMessage(msg, isClient);
    }

    protected void sendNonWebSocketMessage(byte[] msg, boolean isClient) throws IOException {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("sendMessage isClient  = " + isClient + " this = " + this);
        }
        this.lastActivityTimeStamp = System.currentTimeMillis();
        NIOHandler nioHandler = ((NioTcpMessageProcessor)this.messageProcessor).nioHandler;
        if (this.socketChannel != null && this.socketChannel.isConnected() && this.socketChannel.isOpen()) {
            nioHandler.putSocket(NIOHandler.makeKey(this.peerAddress, this.peerPort), this.socketChannel);
        }
        super.sendTCPMessage(msg, this.peerAddress, this.peerPort, isClient);
    }

    private byte[] wrapBufferIntoWebSocketFrame(byte[] buffer) {
        try {
            return WebSocketCodec.encode(buffer, 0, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void sendTCPMessage(byte[] message, InetAddress receiverAddress, int receiverPort, boolean retry) throws IOException {
        message = this.wrapBufferIntoWebSocketFrame(message);
        super.sendTCPMessage(message, receiverAddress, receiverPort, retry);
    }

    @Override
    public void sendMessage(byte[] message, InetAddress receiverAddress, int receiverPort, boolean retry) throws IOException {
        this.sendTCPMessage(message, receiverAddress, receiverPort, retry);
    }

    public NioWebSocketMessageChannel(InetAddress inetAddress, int port, SIPTransactionStack sipStack, NioTcpMessageProcessor nioTcpMessageProcessor) throws IOException {
        super(inetAddress, port, sipStack, nioTcpMessageProcessor);
    }

    @Override
    protected void addBytes(byte[] bytes) throws Exception {
        String s = new String(bytes);
        if (s.startsWith("GET")) {
            byte[] response = new WebSocketHttpHandshake().createHttpResponse(s);
            this.sendNonWebSocketMessage(response, false);
        } else {
            ByteArrayInputStream bios = new ByteArrayInputStream(bytes);
            byte[] decodedMsg = this.codec.decode(bios);
            if (decodedMsg == null) {
                return;
            }
            System.out.println(new String(decodedMsg));
            this.nioParser.addBytes(decodedMsg);
        }
    }

    @Override
    public String getTransport() {
        return "WS";
    }

    @Override
    public void onNewSocket() {
        super.onNewSocket();
    }

    @Override
    public void processMessage(SIPMessage message) throws Exception {
        if (message instanceof Request) {
            String viaHost;
            ContactHeader contact;
            URI uri;
            Request request = (Request)((Object)message);
            if (request.getMethod().equals("REGISTER") && (uri = (contact = (ContactHeader)request.getHeader("Contact")).getAddress().getURI()).isSipURI()) {
                SipURI sipUri = (SipURI)uri;
                String host = sipUri.getHost();
                NioTcpMessageProcessor processor = (NioTcpMessageProcessor)this.messageProcessor;
                HostPort hostPort = new HostPort();
                hostPort.setHost(new Host(host));
                hostPort.setPort(5060);
                processor.assignChannelToDestination(hostPort, this);
            }
            contact = (ContactHeader)message.getHeader("Contact");
            RecordRouteHeader rr = (RecordRouteHeader)message.getHeader("Record-Route");
            ViaHeader via = message.getTopmostViaHeader();
            if (rr == null) {
                if (contact != null) {
                    this.rewriteUri((SipURI)contact.getAddress().getURI());
                }
            } else {
                this.rewriteUri((SipURI)rr.getAddress().getURI());
            }
            if ((viaHost = via.getHost()).endsWith(".invalid")) {
                via.setHost(this.getPeerAddress());
                via.setPort(this.getPeerPort());
            }
        } else {
            ContactHeader contact = (ContactHeader)message.getHeader("Contact");
            RecordRouteHeader rr = (RecordRouteHeader)message.getHeader("Record-Route");
            if (rr == null && contact != null) {
                this.rewriteUri((SipURI)contact.getAddress().getURI());
            }
        }
        super.processMessage(message);
    }

    public void rewriteUri(SipURI uri) {
        try {
            String uriHost = uri.getHost();
            if (uriHost.endsWith(".invalid")) {
                uri.setHost(this.getPeerAddress());
            }
        }
        catch (ParseException e) {
            logger.logError("Cant parse address", e);
        }
        uri.setPort(this.getPeerPort());
    }
}

