/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.javax.sip.stack.MessageProcessor;
import gov.nist.javax.sip.stack.MessageProcessorFactory;
import gov.nist.javax.sip.stack.NioTcpMessageProcessor;
import gov.nist.javax.sip.stack.NioTlsMessageProcessor;
import gov.nist.javax.sip.stack.NioWebSocketMessageProcessor;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.UDPMessageProcessor;
import java.io.IOException;
import java.net.InetAddress;

public class NioMessageProcessorFactory
implements MessageProcessorFactory {
    @Override
    public MessageProcessor createMessageProcessor(SIPTransactionStack sipStack, InetAddress ipAddress, int port, String transport) throws IOException {
        if (transport.equalsIgnoreCase("UDP")) {
            UDPMessageProcessor udpMessageProcessor = new UDPMessageProcessor(ipAddress, sipStack, port);
            sipStack.udpFlag = true;
            return udpMessageProcessor;
        }
        if (transport.equalsIgnoreCase("TCP")) {
            NioTcpMessageProcessor nioTcpMessageProcessor = new NioTcpMessageProcessor(ipAddress, sipStack, port);
            return nioTcpMessageProcessor;
        }
        if (transport.equalsIgnoreCase("TLS")) {
            NioTlsMessageProcessor tlsMessageProcessor = new NioTlsMessageProcessor(ipAddress, sipStack, port);
            return tlsMessageProcessor;
        }
        if (transport.equalsIgnoreCase("SCTP")) {
            try {
                Class<?> mpc = ClassLoader.getSystemClassLoader().loadClass("gov.nist.javax.sip.stack.sctp.SCTPMessageProcessor");
                MessageProcessor mp = (MessageProcessor)mpc.newInstance();
                mp.initialize(ipAddress, port, sipStack);
                return mp;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("SCTP not supported (needs Java 7 and SCTP jar in classpath)");
            }
            catch (InstantiationException ie) {
                throw new IllegalArgumentException("Error initializing SCTP", ie);
            }
            catch (IllegalAccessException ie) {
                throw new IllegalArgumentException("Error initializing SCTP", ie);
            }
        }
        if (transport.equalsIgnoreCase("WS")) {
            NioWebSocketMessageProcessor tlsMessageProcessor = new NioWebSocketMessageProcessor(ipAddress, sipStack, port);
            return tlsMessageProcessor;
        }
        throw new IllegalArgumentException("bad transport");
    }
}

