/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header.ims;

import gov.nist.javax.sip.address.AddressImpl;
import gov.nist.javax.sip.header.AddressParametersHeader;
import gov.nist.javax.sip.header.ims.PServedUserHeader;
import gov.nist.javax.sip.header.ims.SIPHeaderNamesIms;
import java.text.ParseException;
import javax.sip.InvalidArgumentException;
import javax.sip.header.ExtensionHeader;

public class PServedUser
extends AddressParametersHeader
implements PServedUserHeader,
SIPHeaderNamesIms,
ExtensionHeader {
    public PServedUser(AddressImpl address) {
        super("P-Served-User");
        this.address = address;
    }

    public PServedUser() {
        super("P-Served-User");
    }

    @Override
    public String getRegistrationState() {
        return this.getParameter("regstate");
    }

    @Override
    public String getSessionCase() {
        return this.getParameter("sescase");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setRegistrationState(String registrationState) {
        if (registrationState == null) throw new NullPointerException("regstate Parameter value is null");
        if (registrationState.equals("reg") || registrationState.equals("unreg")) {
            try {
                this.setParameter("regstate", registrationState);
                return;
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            return;
        }
        try {
            throw new InvalidArgumentException("Value can be either reg or unreg");
        }
        catch (InvalidArgumentException e) {
            e.printStackTrace();
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setSessionCase(String sessionCase) {
        if (sessionCase == null) throw new NullPointerException("sess-case Parameter value is null");
        if (sessionCase.equals("orig") || sessionCase.equals("term")) {
            try {
                this.setParameter("sescase", sessionCase);
                return;
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            return;
        }
        try {
            throw new InvalidArgumentException("Value can be either orig or term");
        }
        catch (InvalidArgumentException e) {
            e.printStackTrace();
            return;
        }
    }

    @Override
    protected StringBuilder encodeBody(StringBuilder retval) {
        retval.append(this.address.encode());
        if (this.parameters.containsKey("regstate")) {
            retval.append(";").append("regstate").append("=").append(this.getRegistrationState());
        }
        if (this.parameters.containsKey("sescase")) {
            retval.append(";").append("sescase").append("=").append(this.getSessionCase());
        }
        return retval;
    }

    @Override
    public void setValue(String value) throws ParseException {
        throw new ParseException(value, 0);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof PServedUser) {
            PServedUserHeader psu = (PServedUserHeader)other;
            return ((Object)this.getAddress()).equals(((PServedUser)other).getAddress());
        }
        return false;
    }

    @Override
    public Object clone() {
        PServedUser retval = (PServedUser)super.clone();
        return retval;
    }
}

