/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip;

import gov.nist.core.CommonLogger;
import gov.nist.core.InternalErrorHandler;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.DialogTimeoutEvent;
import gov.nist.javax.sip.EventScanner;
import gov.nist.javax.sip.EventWrapper;
import gov.nist.javax.sip.ListeningPointImpl;
import gov.nist.javax.sip.SipProviderExt;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.Utils;
import gov.nist.javax.sip.address.RouterExt;
import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.HopImpl;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPDialogErrorEvent;
import gov.nist.javax.sip.stack.SIPDialogEventListener;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionErrorEvent;
import gov.nist.javax.sip.stack.SIPTransactionEventListener;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import java.io.IOException;
import java.text.ParseException;
import java.util.EventObject;
import java.util.Iterator;
import java.util.TooManyListenersException;
import java.util.concurrent.ConcurrentHashMap;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.ListeningPoint;
import javax.sip.ObjectInUseException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.Timeout;
import javax.sip.TimeoutEvent;
import javax.sip.Transaction;
import javax.sip.TransactionAlreadyExistsException;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.Hop;
import javax.sip.header.CallIdHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;

public class SipProviderImpl
implements SipProvider,
SipProviderExt,
SIPTransactionEventListener,
SIPDialogEventListener {
    private static StackLogger logger = CommonLogger.getLogger(SipProviderImpl.class);
    private SipListener sipListener;
    protected SipStackImpl sipStack;
    private ConcurrentHashMap<String, ListeningPoint> listeningPoints;
    private EventScanner eventScanner;
    private boolean automaticDialogSupportEnabled;
    private boolean dialogErrorsAutomaticallyHandled = true;

    private SipProviderImpl() {
    }

    protected void stop() {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Exiting provider");
        }
        for (ListeningPointImpl listeningPointImpl : this.listeningPoints.values()) {
            listeningPointImpl.removeSipProvider();
        }
        this.eventScanner.stop();
    }

    @Override
    public ListeningPoint getListeningPoint(String transport) {
        if (transport == null) {
            throw new NullPointerException("Null transport param");
        }
        return this.listeningPoints.get(transport.toUpperCase());
    }

    public void handleEvent(EventObject sipEvent, SIPTransaction transaction) {
        if (logger.isLoggingEnabled(32)) {
            Dialog dialog;
            logger.logDebug("handleEvent " + sipEvent + "currentTransaction = " + transaction + "this.sipListener = " + this.getSipListener() + "sipEvent.source = " + sipEvent.getSource());
            if (sipEvent instanceof RequestEvent) {
                dialog = ((RequestEvent)sipEvent).getDialog();
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Dialog = " + dialog);
                }
            } else if (sipEvent instanceof ResponseEvent) {
                dialog = ((ResponseEvent)sipEvent).getDialog();
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Dialog = " + dialog);
                }
            }
            logger.logStackTrace();
        }
        EventWrapper eventWrapper = new EventWrapper(sipEvent, transaction);
        if (!this.sipStack.isReEntrantListener()) {
            this.eventScanner.addEvent(eventWrapper);
        } else {
            this.eventScanner.deliverEvent(eventWrapper);
        }
    }

    protected SipProviderImpl(SipStackImpl sipStack) {
        this.eventScanner = sipStack.getEventScanner();
        this.sipStack = sipStack;
        this.eventScanner.incrementRefcount();
        this.listeningPoints = new ConcurrentHashMap();
        this.automaticDialogSupportEnabled = this.sipStack.isAutomaticDialogSupportEnabled();
        this.dialogErrorsAutomaticallyHandled = this.sipStack.isAutomaticDialogErrorHandlingEnabled();
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public void addSipListener(SipListener sipListener) throws TooManyListenersException {
        if (this.sipStack.sipListener == null) {
            this.sipStack.sipListener = sipListener;
        } else if (this.sipStack.sipListener != sipListener) {
            throw new TooManyListenersException("Stack already has a listener. Only one listener per stack allowed");
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("add SipListener " + sipListener);
        }
        this.sipListener = sipListener;
    }

    @Override
    public ListeningPoint getListeningPoint() {
        if (this.listeningPoints.size() > 0) {
            return this.listeningPoints.values().iterator().next();
        }
        return null;
    }

    @Override
    public CallIdHeader getNewCallId() {
        String callId = Utils.getInstance().generateCallIdentifier(this.getListeningPoint().getIPAddress());
        CallID callid = new CallID();
        try {
            callid.setCallId(callId);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return callid;
    }

    /*
     * Exception decompiling
     */
    @Override
    public ClientTransaction getNewClientTransaction(Request request) throws TransactionUnavailableException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerTransaction getNewServerTransaction(Request request) throws TransactionAlreadyExistsException, TransactionUnavailableException {
        SIPClientTransaction ct;
        if (!this.sipStack.isAlive()) {
            throw new TransactionUnavailableException("Stack is stopped");
        }
        SIPServerTransaction transaction = null;
        SIPRequest sipRequest = (SIPRequest)request;
        try {
            sipRequest.checkHeaders();
        }
        catch (ParseException ex) {
            throw new TransactionUnavailableException(ex.getMessage(), ex);
        }
        if (request.getMethod().equals("ACK")) {
            if (logger.isLoggingEnabled()) {
                logger.logError("Creating server transaction for ACK -- makes no sense!");
            }
            throw new TransactionUnavailableException("Cannot create Server transaction for ACK ");
        }
        if (sipRequest.getMethod().equals("NOTIFY") && sipRequest.getFromTag() != null && sipRequest.getToTag() == null && (ct = this.sipStack.findSubscribeTransaction(sipRequest, (ListeningPointImpl)this.getListeningPoint())) == null && !this.sipStack.isDeliverUnsolicitedNotify()) {
            throw new TransactionUnavailableException("Cannot find matching Subscription (and gov.nist.javax.sip.DELIVER_UNSOLICITED_NOTIFY not set)");
        }
        if (!this.sipStack.acquireSem()) {
            throw new TransactionUnavailableException("Transaction not available -- could not acquire stack lock");
        }
        try {
            String dialogId;
            if (SIPTransactionStack.isDialogCreated(sipRequest.getMethod())) {
                if (this.sipStack.findTransaction((SIPRequest)request, true) != null) {
                    throw new TransactionAlreadyExistsException("server transaction already exists!");
                }
                transaction = (SIPServerTransaction)((SIPRequest)request).getTransaction();
                if (transaction == null) {
                    throw new TransactionUnavailableException("Transaction not available");
                }
                if (transaction.getOriginalRequest() == null) {
                    transaction.setOriginalRequest(sipRequest);
                }
                try {
                    this.sipStack.addTransaction(transaction);
                }
                catch (IOException ex) {
                    throw new TransactionUnavailableException("Error sending provisional response");
                }
                transaction.addEventListener(this);
                if (this.isAutomaticDialogSupportEnabled()) {
                    dialogId = sipRequest.getDialogId(true);
                    SIPDialog dialog = this.sipStack.getDialog(dialogId);
                    if (dialog == null) {
                        dialog = this.sipStack.createDialog(transaction);
                    }
                    transaction.setDialog(dialog, sipRequest.getDialogId(true));
                    if (sipRequest.getMethod().equals("INVITE") && this.isDialogErrorsAutomaticallyHandled()) {
                        this.sipStack.putInMergeTable(transaction, sipRequest);
                    }
                    dialog.addRoute(sipRequest);
                    if (dialog.getRemoteTag() != null && dialog.getLocalTag() != null) {
                        this.sipStack.putDialog(dialog);
                    }
                }
            } else if (this.isAutomaticDialogSupportEnabled()) {
                transaction = (SIPServerTransaction)this.sipStack.findTransaction((SIPRequest)request, true);
                if (transaction != null) {
                    throw new TransactionAlreadyExistsException("Transaction exists! ");
                }
                transaction = (SIPServerTransaction)((SIPRequest)request).getTransaction();
                if (transaction == null) {
                    throw new TransactionUnavailableException("Transaction not available!");
                }
                if (transaction.getOriginalRequest() == null) {
                    transaction.setOriginalRequest(sipRequest);
                }
                try {
                    this.sipStack.addTransaction(transaction);
                }
                catch (IOException ex) {
                    throw new TransactionUnavailableException("Could not send back provisional response!");
                }
                dialogId = sipRequest.getDialogId(true);
                SIPDialog dialog = this.sipStack.getDialog(dialogId);
                if (dialog != null) {
                    dialog.addTransaction(transaction);
                    dialog.addRoute(sipRequest);
                    transaction.setDialog(dialog, sipRequest.getDialogId(true));
                }
            } else {
                transaction = (SIPServerTransaction)this.sipStack.findTransaction((SIPRequest)request, true);
                if (transaction != null) {
                    throw new TransactionAlreadyExistsException("Transaction exists! ");
                }
                transaction = (SIPServerTransaction)((SIPRequest)request).getTransaction();
                if (transaction != null) {
                    if (transaction.getOriginalRequest() == null) {
                        transaction.setOriginalRequest(sipRequest);
                    }
                    this.sipStack.mapTransaction(transaction);
                    dialogId = sipRequest.getDialogId(true);
                    SIPDialog dialog = this.sipStack.getDialog(dialogId);
                    if (dialog != null) {
                        dialog.addTransaction(transaction);
                        dialog.addRoute(sipRequest);
                        transaction.setDialog(dialog, sipRequest.getDialogId(true));
                    }
                    SIPServerTransaction sIPServerTransaction = transaction;
                    return sIPServerTransaction;
                }
                MessageChannel mc = (MessageChannel)sipRequest.getMessageChannel();
                transaction = this.sipStack.createServerTransaction(mc);
                if (transaction == null) {
                    throw new TransactionUnavailableException("Transaction unavailable -- too many servrer transactions");
                }
                transaction.setOriginalRequest(sipRequest);
                this.sipStack.mapTransaction(transaction);
                String dialogId2 = sipRequest.getDialogId(true);
                SIPDialog dialog = this.sipStack.getDialog(dialogId2);
                if (dialog != null) {
                    dialog.addTransaction(transaction);
                    dialog.addRoute(sipRequest);
                    transaction.setDialog(dialog, sipRequest.getDialogId(true));
                }
                SIPServerTransaction sIPServerTransaction = transaction;
                return sIPServerTransaction;
            }
            SIPServerTransaction sIPServerTransaction = transaction;
            return sIPServerTransaction;
        }
        finally {
            this.sipStack.releaseSem();
        }
    }

    @Override
    public SipStack getSipStack() {
        return this.sipStack;
    }

    @Override
    public void removeSipListener(SipListener sipListener) {
        if (sipListener == this.getSipListener()) {
            this.sipListener = null;
        }
        boolean found = false;
        Iterator<SipProviderImpl> it = this.sipStack.getSipProviders();
        while (it.hasNext()) {
            SipProviderImpl nextProvider = it.next();
            if (nextProvider.getSipListener() == null) continue;
            found = true;
        }
        if (!found) {
            this.sipStack.sipListener = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendRequest(Request request) throws SipException {
        block16: {
            Hop hop;
            SIPDialog dialog;
            if (!this.sipStack.isAlive()) {
                throw new SipException("Stack is stopped.");
            }
            if (((SIPRequest)request).getRequestLine() != null && request.getMethod().equals("ACK") && (dialog = this.sipStack.getDialog(((SIPRequest)request).getDialogId(false))) != null && dialog.getState() != null && logger.isLoggingEnabled()) {
                logger.logWarning("Dialog exists -- you may want to use Dialog.sendAck() " + dialog.getState());
            }
            if ((hop = this.sipStack.getRouter((SIPRequest)request).getNextHop(request)) == null) {
                throw new SipException("could not determine next hop!");
            }
            SIPRequest sipRequest = (SIPRequest)request;
            if (!sipRequest.isNullRequest() && sipRequest.getTopmostVia() == null) {
                throw new SipException("Invalid SipRequest -- no via header!");
            }
            try {
                Via via;
                String branch;
                if (!(sipRequest.isNullRequest() || (branch = (via = sipRequest.getTopmostVia()).getBranch()) != null && branch.length() != 0)) {
                    via.setBranch(sipRequest.getTransactionId());
                }
                MessageChannel messageChannel = null;
                if (this.listeningPoints.containsKey(hop.getTransport().toUpperCase())) {
                    messageChannel = this.sipStack.createRawMessageChannel(this.getListeningPoint(hop.getTransport()).getIPAddress(), this.getListeningPoint(hop.getTransport()).getPort(), hop);
                }
                if (messageChannel != null) {
                    messageChannel.sendMessage(sipRequest, hop);
                    break block16;
                }
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Could not create a message channel for " + ((Object)hop).toString() + " listeningPoints = " + this.listeningPoints);
                }
                throw new SipException("Could not create a message channel for " + ((Object)hop).toString());
            }
            catch (IOException ex) {
                if (logger.isLoggingEnabled()) {
                    logger.logException(ex);
                }
                throw new SipException("IO Exception occured while Sending Request", ex);
            }
            catch (ParseException ex1) {
                InternalErrorHandler.handleException(ex1);
            }
            finally {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("done sending " + request.getMethod() + " to hop " + hop);
                }
            }
        }
    }

    @Override
    public void sendResponse(Response response) throws SipException {
        int port;
        if (!this.sipStack.isAlive()) {
            throw new SipException("Stack is stopped");
        }
        SIPResponse sipResponse = (SIPResponse)response;
        Via via = sipResponse.getTopmostVia();
        if (via == null) {
            throw new SipException("No via header in response!");
        }
        SIPServerTransaction st = (SIPServerTransaction)this.sipStack.findTransaction((SIPMessage)((Object)response), true);
        if (st != null && st.getInternalState() != 5 && this.isAutomaticDialogSupportEnabled()) {
            throw new SipException("Transaction exists -- cannot send response statelessly");
        }
        String transport = via.getTransport();
        String host = via.getReceived();
        if (host == null) {
            host = via.getHost();
        }
        if ((port = via.getRPort()) == -1 && (port = via.getPort()) == -1) {
            port = transport.equalsIgnoreCase("TLS") || transport.equalsIgnoreCase("SCTP-TLS") ? 5061 : 5060;
        }
        if (host.indexOf(":") > 0 && host.indexOf("[") < 0) {
            host = "[" + host + "]";
        }
        Hop hop = this.sipStack.getAddressResolver().resolveAddress(new HopImpl(host, port, transport));
        try {
            ListeningPointImpl listeningPoint = (ListeningPointImpl)this.getListeningPoint(transport);
            if (listeningPoint == null) {
                throw new SipException("whoopsa daisy! no listening point found for transport " + transport);
            }
            MessageChannel messageChannel = this.sipStack.createRawMessageChannel(this.getListeningPoint(hop.getTransport()).getIPAddress(), listeningPoint.port, hop);
            messageChannel.sendMessage(sipResponse);
        }
        catch (IOException ex) {
            throw new SipException(ex.getMessage());
        }
    }

    @Override
    public synchronized void setListeningPoint(ListeningPoint listeningPoint) {
        if (listeningPoint == null) {
            throw new NullPointerException("Null listening point");
        }
        ListeningPointImpl lp = (ListeningPointImpl)listeningPoint;
        lp.sipProvider = this;
        String transport = lp.getTransport().toUpperCase();
        this.listeningPoints.clear();
        this.listeningPoints.put(transport, listeningPoint);
    }

    @Override
    public Dialog getNewDialog(Transaction transaction) throws SipException {
        if (transaction == null) {
            throw new NullPointerException("Null transaction!");
        }
        if (!this.sipStack.isAlive()) {
            throw new SipException("Stack is stopped.");
        }
        if (this.isAutomaticDialogSupportEnabled()) {
            throw new SipException(" Error - AUTOMATIC_DIALOG_SUPPORT is on");
        }
        if (!SIPTransactionStack.isDialogCreated(transaction.getRequest().getMethod())) {
            throw new SipException("Dialog cannot be created for this method " + transaction.getRequest().getMethod());
        }
        SIPDialog dialog = null;
        SIPTransaction sipTransaction = (SIPTransaction)transaction;
        if (transaction instanceof ServerTransaction) {
            SIPServerTransaction st = (SIPServerTransaction)transaction;
            SIPResponse response = st.getLastResponse();
            if (response != null && response.getStatusCode() != 100) {
                throw new SipException("Cannot set dialog after response has been sent");
            }
            SIPRequest sipRequest = (SIPRequest)transaction.getRequest();
            String dialogId = sipRequest.getDialogId(true);
            dialog = this.sipStack.getDialog(dialogId);
            if (dialog == null) {
                dialog = this.sipStack.createDialog((SIPTransaction)transaction);
                dialog.addTransaction(sipTransaction);
                dialog.addRoute(sipRequest);
                sipTransaction.setDialog(dialog, null);
            } else {
                sipTransaction.setDialog(dialog, sipRequest.getDialogId(true));
            }
            if (sipRequest.getMethod().equals("INVITE") && this.isDialogErrorsAutomaticallyHandled()) {
                this.sipStack.putInMergeTable(st, sipRequest);
            }
        } else {
            SIPClientTransaction sipClientTx = (SIPClientTransaction)transaction;
            SIPResponse response = sipClientTx.getLastResponse();
            if (response == null) {
                SIPRequest request = (SIPRequest)sipClientTx.getRequest();
                String dialogId = request.getDialogId(false);
                dialog = this.sipStack.getDialog(dialogId);
                if (dialog != null) {
                    throw new SipException("Dialog already exists!");
                }
                dialog = this.sipStack.createDialog(sipTransaction);
                sipClientTx.setDialog(dialog, null);
            } else {
                throw new SipException("Cannot call this method after response is received!");
            }
        }
        dialog.addEventListener(this);
        return dialog;
    }

    @Override
    public void transactionErrorEvent(SIPTransactionErrorEvent transactionErrorEvent) {
        SIPTransaction transaction = (SIPTransaction)transactionErrorEvent.getSource();
        if (transactionErrorEvent.getErrorID() == 2) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("TransportError occured on " + transaction);
            }
            Object errorObject = transactionErrorEvent.getSource();
            Timeout timeout = Timeout.TRANSACTION;
            TimeoutEvent ev = null;
            if (errorObject instanceof SIPServerTransaction) {
                ev = new TimeoutEvent((Object)this, (ServerTransaction)errorObject, timeout);
            } else {
                SIPClientTransaction clientTx = (SIPClientTransaction)errorObject;
                Hop hop = clientTx.getNextHop();
                if (this.sipStack.getRouter() instanceof RouterExt) {
                    ((RouterExt)this.sipStack.getRouter()).transactionTimeout(hop);
                }
                ev = new TimeoutEvent((Object)this, (ClientTransaction)errorObject, timeout);
            }
            this.handleEvent(ev, (SIPTransaction)errorObject);
        } else if (transactionErrorEvent.getErrorID() == 1) {
            Object errorObject = transactionErrorEvent.getSource();
            Timeout timeout = Timeout.TRANSACTION;
            TimeoutEvent ev = null;
            if (errorObject instanceof SIPServerTransaction) {
                ev = new TimeoutEvent((Object)this, (ServerTransaction)errorObject, timeout);
            } else {
                SIPClientTransaction clientTx = (SIPClientTransaction)errorObject;
                Hop hop = clientTx.getNextHop();
                if (this.sipStack.getRouter() instanceof RouterExt) {
                    ((RouterExt)this.sipStack.getRouter()).transactionTimeout(hop);
                }
                ev = new TimeoutEvent((Object)this, (ClientTransaction)errorObject, timeout);
            }
            this.handleEvent(ev, (SIPTransaction)errorObject);
        } else if (transactionErrorEvent.getErrorID() == 3) {
            Object errorObject = transactionErrorEvent.getSource();
            Transaction tx = (Transaction)errorObject;
            if (tx.getDialog() != null) {
                InternalErrorHandler.handleException("Unexpected event !", logger);
            }
            Timeout timeout = Timeout.RETRANSMIT;
            TimeoutEvent ev = null;
            ev = errorObject instanceof SIPServerTransaction ? new TimeoutEvent((Object)this, (ServerTransaction)errorObject, timeout) : new TimeoutEvent((Object)this, (ClientTransaction)errorObject, timeout);
            this.handleEvent(ev, (SIPTransaction)errorObject);
        }
    }

    @Override
    public void dialogErrorEvent(SIPDialogErrorEvent dialogErrorEvent) {
        SIPDialog sipDialog = (SIPDialog)dialogErrorEvent.getSource();
        DialogTimeoutEvent.Reason reason = DialogTimeoutEvent.Reason.AckNotReceived;
        if (dialogErrorEvent.getErrorID() == 2) {
            reason = DialogTimeoutEvent.Reason.AckNotSent;
        } else if (dialogErrorEvent.getErrorID() == 3) {
            reason = DialogTimeoutEvent.Reason.ReInviteTimeout;
        } else if (dialogErrorEvent.getErrorID() == 4) {
            reason = DialogTimeoutEvent.Reason.EarlyStateTimeout;
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Dialog TimeoutError occured on " + sipDialog);
        }
        DialogTimeoutEvent ev = new DialogTimeoutEvent(this, sipDialog, reason);
        ev.setClientTransaction(dialogErrorEvent.getClientTransaction());
        this.handleEvent(ev, null);
    }

    @Override
    public synchronized ListeningPoint[] getListeningPoints() {
        ListeningPoint[] retval = new ListeningPointImpl[this.listeningPoints.size()];
        this.listeningPoints.values().toArray(retval);
        return retval;
    }

    @Override
    public synchronized void addListeningPoint(ListeningPoint listeningPoint) throws ObjectInUseException {
        ListeningPointImpl lp = (ListeningPointImpl)listeningPoint;
        if (lp.sipProvider != null && lp.sipProvider != this) {
            throw new ObjectInUseException("Listening point assigned to another provider");
        }
        String transport = lp.getTransport().toUpperCase();
        if (this.listeningPoints.containsKey(transport) && this.listeningPoints.get(transport) != listeningPoint) {
            throw new ObjectInUseException("Listening point already assigned for transport!");
        }
        lp.sipProvider = this;
        this.listeningPoints.put(transport, lp);
    }

    @Override
    public synchronized void removeListeningPoint(ListeningPoint listeningPoint) throws ObjectInUseException {
        ListeningPointImpl lp = (ListeningPointImpl)listeningPoint;
        if (lp.messageProcessor.inUse()) {
            throw new ObjectInUseException("Object is in use");
        }
        this.listeningPoints.remove(lp.getTransport().toUpperCase());
    }

    public synchronized void removeListeningPoints() {
        Iterator<ListeningPoint> it = this.listeningPoints.values().iterator();
        while (it.hasNext()) {
            ListeningPointImpl lp = (ListeningPointImpl)it.next();
            lp.messageProcessor.stop();
            it.remove();
        }
    }

    @Override
    public void setAutomaticDialogSupportEnabled(boolean automaticDialogSupportEnabled) {
        this.automaticDialogSupportEnabled = automaticDialogSupportEnabled;
        if (this.automaticDialogSupportEnabled) {
            this.dialogErrorsAutomaticallyHandled = true;
        }
    }

    public boolean isAutomaticDialogSupportEnabled() {
        return this.automaticDialogSupportEnabled;
    }

    @Override
    public void setDialogErrorsAutomaticallyHandled() {
        this.dialogErrorsAutomaticallyHandled = true;
    }

    public boolean isDialogErrorsAutomaticallyHandled() {
        return this.dialogErrorsAutomaticallyHandled;
    }

    public SipListener getSipListener() {
        return this.sipListener;
    }
}

