/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.core.net;

import gov.nist.core.CommonLogger;
import gov.nist.core.StackLogger;
import gov.nist.core.net.SecurityManagerProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Properties;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class DefaultSecurityManagerProvider
implements SecurityManagerProvider {
    private static final StackLogger logger = CommonLogger.getLogger(DefaultSecurityManagerProvider.class);
    private KeyManagerFactory keyManagerFactory;
    private TrustManagerFactory trustManagerFactory;

    @Override
    public void init(Properties properties) throws GeneralSecurityException, IOException {
        String passphraseString = properties.getProperty("javax.net.ssl.keyStorePassword");
        String keyStoreType = properties.getProperty("javax.net.ssl.keyStoreType");
        if (passphraseString == null) {
            passphraseString = System.getProperty("javax.net.ssl.keyStorePassword");
        }
        if (keyStoreType == null) {
            keyStoreType = System.getProperty("javax.net.ssl.keyStoreType");
        }
        if (keyStoreType == null) {
            logger.logDebug("Security manager not specified, TLS settings will be inactive");
            return;
        }
        KeyStore ks = KeyStore.getInstance(keyStoreType);
        KeyStore ts = KeyStore.getInstance(keyStoreType);
        char[] passphrase = passphraseString.toCharArray();
        String keyStoreFilename = properties.getProperty("javax.net.ssl.keyStore");
        String trustStoreFilename = properties.getProperty("javax.net.ssl.trustStore");
        if (keyStoreFilename == null) {
            keyStoreFilename = System.getProperty("javax.net.ssl.keyStore");
        }
        if (trustStoreFilename == null) {
            trustStoreFilename = System.getProperty("javax.net.ssl.trustStore");
        }
        if (keyStoreFilename != null && trustStoreFilename != null) {
            ks.load(new FileInputStream(new File(keyStoreFilename)), passphrase);
            ts.load(new FileInputStream(new File(trustStoreFilename)), passphrase);
            this.keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            this.keyManagerFactory.init(ks, passphrase);
            this.trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
            this.trustManagerFactory.init(ts);
        } else {
            logger.logWarning("TLS key and trust stores are not configured. javax.net.ssl.keyStore=" + keyStoreFilename + " javax.net.ssl.trustStore=" + trustStoreFilename);
        }
    }

    @Override
    public KeyManager[] getKeyManagers(boolean client) {
        if (this.keyManagerFactory == null) {
            return null;
        }
        return this.keyManagerFactory.getKeyManagers();
    }

    @Override
    public TrustManager[] getTrustManagers(boolean client) {
        if (this.trustManagerFactory == null) {
            return null;
        }
        return this.trustManagerFactory.getTrustManagers();
    }
}

