/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.core.net;

import gov.nist.core.net.NetworkLayer;
import java.io.IOException;
import java.net.ConnectException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class DefaultNetworkLayer
implements NetworkLayer {
    private SSLSocketFactory sslSocketFactory;
    private SSLServerSocketFactory sslServerSocketFactory = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
    public static final DefaultNetworkLayer SINGLETON = new DefaultNetworkLayer();

    private DefaultNetworkLayer() {
        this.sslSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog, InetAddress bindAddress) throws IOException {
        return new ServerSocket(port, backlog, bindAddress);
    }

    @Override
    public Socket createSocket(InetAddress address, int port) throws IOException {
        return new Socket(address, port);
    }

    @Override
    public DatagramSocket createDatagramSocket() throws SocketException {
        return new DatagramSocket();
    }

    @Override
    public DatagramSocket createDatagramSocket(int port, InetAddress laddr) throws SocketException {
        if (laddr.isMulticastAddress()) {
            try {
                MulticastSocket ds = new MulticastSocket(port);
                ds.joinGroup(laddr);
                return ds;
            }
            catch (IOException e) {
                throw new SocketException(e.getLocalizedMessage());
            }
        }
        return new DatagramSocket(port, laddr);
    }

    @Override
    public SSLServerSocket createSSLServerSocket(int port, int backlog, InetAddress bindAddress) throws IOException {
        return (SSLServerSocket)this.sslServerSocketFactory.createServerSocket(port, backlog, bindAddress);
    }

    @Override
    public SSLSocket createSSLSocket(InetAddress address, int port) throws IOException {
        SSLSocket sock = (SSLSocket)this.sslSocketFactory.createSocket();
        try {
            sock.connect(new InetSocketAddress(address, port), 8000);
        }
        catch (SocketTimeoutException e) {
            throw new ConnectException("Socket timeout error (8sec)" + address + ":" + port);
        }
        return sock;
    }

    @Override
    public SSLSocket createSSLSocket(InetAddress address, int port, InetAddress myAddress) throws IOException {
        return this.createSSLSocket(address, port);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress myAddress) throws IOException {
        if (myAddress != null) {
            Socket sock = new Socket();
            try {
                sock.connect(new InetSocketAddress(address, port), 8000);
            }
            catch (SocketTimeoutException e) {
                throw new ConnectException("Socket timeout error (8sec)" + address + ":" + port);
            }
            return sock;
        }
        Socket sock = new Socket();
        try {
            sock.connect(new InetSocketAddress(address, port), 8000);
        }
        catch (SocketTimeoutException e) {
            throw new ConnectException("Socket timeout error (8sec)" + address + ":" + port);
        }
        return sock;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress myAddress, int myPort) throws IOException {
        if (myAddress != null) {
            return new Socket(address, port, myAddress, myPort);
        }
        if (port != 0) {
            Socket sock = new Socket();
            sock.bind(new InetSocketAddress(port));
            sock.connect(new InetSocketAddress(address, port), 8000);
            return sock;
        }
        return new Socket(address, port);
    }
}

