/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.phone;

import java.io.IOException;
import org.mobicents.media.ComponentType;
import org.mobicents.media.server.component.audio.AudioOutput;
import org.mobicents.media.server.component.audio.GoertzelFilter;
import org.mobicents.media.server.impl.AbstractSink;
import org.mobicents.media.server.impl.resource.phone.ToneEventImpl;
import org.mobicents.media.server.scheduler.Scheduler;
import org.mobicents.media.server.spi.FormatNotSupportedException;
import org.mobicents.media.server.spi.format.AudioFormat;
import org.mobicents.media.server.spi.format.FormatFactory;
import org.mobicents.media.server.spi.format.Formats;
import org.mobicents.media.server.spi.listener.Event;
import org.mobicents.media.server.spi.listener.Listener;
import org.mobicents.media.server.spi.listener.Listeners;
import org.mobicents.media.server.spi.listener.TooManyListenersException;
import org.mobicents.media.server.spi.memory.Frame;
import org.mobicents.media.server.spi.tone.ToneDetector;
import org.mobicents.media.server.spi.tone.ToneDetectorListener;

public class PhoneSignalDetector
extends AbstractSink
implements ToneDetector {
    private double POWER = 100000.0;
    private static final int PACKET_DURATION = 50;
    private AudioFormat LINEAR_AUDIO = FormatFactory.createAudioFormat((String)"LINEAR", (int)8000, (int)16, (int)1);
    private int[] f;
    private int offset;
    private int toneDuration = 50;
    private int N = 8 * this.toneDuration;
    private double scale = (double)this.toneDuration / 1000.0;
    private GoertzelFilter[] freqFilters;
    private double[] signal;
    private double maxAmpl;
    private double threshold;
    private int level;
    private double[] p;
    private long startTime;
    private int count;
    private AudioOutput output;
    private Listeners<ToneDetectorListener> listeners = new Listeners();

    public PhoneSignalDetector(String name, Scheduler scheduler) {
        super(name);
        this.signal = new double[this.N];
        this.output = new AudioOutput(scheduler, ComponentType.SIGNAL_DETECTOR.getType());
        this.output.join((AbstractSink)this);
    }

    public AudioOutput getAudioOutput() {
        return this.output;
    }

    public void setFrequency(int[] f) {
        this.f = f;
        this.freqFilters = new GoertzelFilter[f.length];
        this.p = new double[f.length];
        for (int i = 0; i < f.length; ++i) {
            this.freqFilters[i] = new GoertzelFilter(f[i], this.N, this.scale);
        }
    }

    public int[] getFrequency() {
        return this.f;
    }

    public void setVolume(int level) {
        this.level = level;
        this.threshold = Math.pow(Math.pow(10.0, level), 0.1) * 32767.0;
    }

    public int getVolume() {
        return this.level;
    }

    public void activate() {
        this.output.start();
    }

    public void deactivate() {
        this.output.stop();
    }

    public void onMediaTransfer(Frame frame) throws IOException {
        byte[] data = frame.getData();
        int M = data.length;
        int k = 0;
        while (k < M) {
            while (this.offset < this.N && k < M - 1) {
                int n = k++;
                int n2 = k++;
                double s = data[n] & 0xFF | data[n2] << 8;
                double sa = Math.abs(s);
                if (sa > this.maxAmpl) {
                    this.maxAmpl = sa;
                }
                this.signal[this.offset++] = s;
            }
            if (this.offset != this.N) continue;
            this.offset = 0;
            if (!(this.maxAmpl >= this.threshold)) continue;
            this.maxAmpl = 0.0;
            this.getPower(this.freqFilters, this.signal, 0, this.p);
            int detectedValue = this.isDetected();
            if (detectedValue < 0) continue;
            this.sendEvent((Event)new ToneEventImpl(this, this.getFrequency()[detectedValue]));
        }
    }

    private int isDetected() {
        for (int i = 0; i < this.p.length; ++i) {
            if (!(this.p[i] >= this.POWER)) continue;
            return i;
        }
        return -1;
    }

    private void getPower(GoertzelFilter[] filters, double[] data, int offset, double[] power) {
        for (int i = 0; i < filters.length; ++i) {
            power[i] = filters[i].getPower(data, offset);
        }
    }

    public void setFormats(Formats formats) throws FormatNotSupportedException {
    }

    public void addListener(ToneDetectorListener listener) throws TooManyListenersException {
        this.listeners.add((Listener)listener);
    }

    public void removeListener(ToneDetectorListener listener) {
        this.listeners.remove((Listener)listener);
    }

    public void clearAllListeners() {
        this.listeners.clear();
    }

    private void sendEvent(Event event) {
        this.listeners.dispatch(event);
    }
}

