/*
 * Decompiled with CFR 0.152.
 */
package com.iSpeech;

import com.iSpeech.ASRStreamer;
import com.iSpeech.ApiException;
import com.iSpeech.InvalidApiKeyException;
import com.iSpeech.SerializableHashTable;
import com.iSpeech.SpeechResult;
import com.iSpeech.StreamingOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;

public class iSpeechRecognizer {
    public static final int FREEFORM_DISABLED = 0;
    public static final int FREEFORM_SMS = 1;
    public static final int FREEFORM_VOICEMAIL = 2;
    public static final int FREEFORM_DICTATION = 3;
    public static final int FREEFORM_MESSAGE = 4;
    public static final int FREEFORM_INSTANT_MESSAGE = 5;
    public static final int FREEFORM_TRANSCRIPT = 6;
    public static final int FREEFORM_MEMO = 7;
    private SpeechRecognizerEvent event = null;
    private static iSpeechRecognizer _iSpeech;
    private String asrLocale = null;
    private static String _apiKey;
    private static boolean _production;
    private int freeFormValue = 0;
    private Hashtable<String, String> optional = new Hashtable();
    private Hashtable<String, String[]> h = new Hashtable();
    private Exception lastException = null;
    private ASRStreamer _streamer;
    private String _mimeType;
    private boolean isCancelled = false;
    public static String version;
    private int commandIndex = 1;

    static {
        version = "1.0.1";
    }

    private iSpeechRecognizer(String api, boolean production) throws InvalidApiKeyException {
        _apiKey = api;
        _production = production;
        if (api == null || api.length() != 32) {
            throw new InvalidApiKeyException();
        }
    }

    public static iSpeechRecognizer getInstance(String ApiKey, boolean production) throws InvalidApiKeyException {
        if (_iSpeech == null) {
            _iSpeech = new iSpeechRecognizer(ApiKey, production);
        }
        return _iSpeech;
    }

    public OutputStream startStreamingRecognize(String mimeType, SpeechRecognizerEvent speechRecognizerEvent) throws Exception {
        this.lastException = null;
        this.isCancelled = false;
        this.event = speechRecognizerEvent;
        this._streamer = new ASRStreamer();
        this._mimeType = mimeType;
        try {
            return this._streamer.connect(this.createQueryString(), mimeType, _production);
        }
        catch (Exception e1) {
            this.lastException = e1;
            this.cancelRecord(true);
            return null;
        }
    }

    public SpeechResult startFileRecognize(String mimeType, File file, SpeechRecognizerEvent speechRecognizerEvent) throws Exception {
        this.lastException = null;
        this.isCancelled = false;
        this.event = speechRecognizerEvent;
        this._streamer = new ASRStreamer();
        this._mimeType = mimeType;
        StreamingOutputStream data = null;
        try {
            data = this._streamer.connect(this.createQueryString(), mimeType, _production);
        }
        catch (Exception e1) {
            this.lastException = e1;
            this.cancelRecord(true);
            return null;
        }
        FileInputStream fis = new FileInputStream(file);
        byte[] buf = new byte[2048];
        long size = file.length();
        int len = 0;
        while (size > 0L) {
            len = fis.read(buf);
            ((OutputStream)data).write(buf, 0, len);
            size -= (long)len;
        }
        return this.stopRecord();
    }

    private String createQueryString() {
        StringBuilder p = new StringBuilder();
        if (this.freeFormValue > 0) {
            p.append("freeform=" + String.valueOf(this.freeFormValue) + "&");
        } else {
            Enumeration<String> e = this.h.keys();
            StringBuffer aliases = new StringBuffer();
            while (e.hasMoreElements()) {
                String key = e.nextElement().toString();
                String[] wordArray = this.h.get(key);
                StringBuffer sb = new StringBuffer();
                aliases.append(key);
                aliases.append("|");
                int i = 0;
                while (i < wordArray.length) {
                    sb.append(wordArray[i]);
                    sb.append("|");
                    ++i;
                }
                p.append(String.valueOf(key) + "=" + URLEncoder.encode(sb.toString()) + "&");
            }
            p.append("alias=" + URLEncoder.encode(aliases.toString()) + "&");
        }
        p.append("content-type=" + this._mimeType + "&");
        if (this.asrLocale != null) {
            p.append("locale=" + URLEncoder.encode(this.asrLocale) + "&");
        }
        p.append("apikey=" + _apiKey + "&action=recognize&output=hash&deviceType=javaSDK_" + version);
        try {
            if (this.optional.size() > 0) {
                Enumeration<String> k = this.optional.keys();
                while (k.hasMoreElements()) {
                    String key = k.nextElement().toString();
                    p.append(String.valueOf(key) + "=" + URLEncoder.encode(this.optional.get(key).toString()));
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        return p.toString().toLowerCase();
    }

    public void cancelRecord() {
        this.cancelRecord(false);
    }

    private void cancelRecord(boolean internal) {
        try {
            this._streamer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isCancelled = true;
        if (this.event != null) {
            this.event.stateChanged(!internal ? 2 : 3, this.freeFormValue, this.lastException);
        }
    }

    public SpeechResult stopRecord() throws IllegalArgumentException, ApiException, InvalidApiKeyException {
        if (this.isCancelled) {
            return null;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (iSpeechRecognizer.this.event != null) {
                    iSpeechRecognizer.this.event.stateChanged(1, iSpeechRecognizer.this.freeFormValue, iSpeechRecognizer.this.lastException);
                }
            }
        }).start();
        try {
            this._streamer.sendLastPacket();
        }
        catch (Exception e) {
            System.out.println("Stop record  " + e.toString());
        }
        SpeechResult r = this.getConverstion();
        this.h.clear();
        return r;
    }

    private SpeechResult getConverstion() throws InvalidApiKeyException {
        try {
            SerializableHashTable result = this._streamer.getResponseASR();
            if (result.containsKey("result") && result.getString("result").equals("success")) {
                return new SpeechResult(result.getString("text"), Float.parseFloat(result.getString("confidence")));
            }
            if (result.containsKey("result") && result.getString("result").equals("error")) {
                if (result.containsKey("code")) {
                    int code = Integer.parseInt(result.getString("code"));
                    switch (code) {
                        case 1: 
                        case 3: 
                        case 101: 
                        case 999: {
                            throw new InvalidApiKeyException();
                        }
                    }
                    throw new IOException();
                }
                throw new ApiException(result.getString("message"));
            }
        }
        catch (IllegalArgumentException ia) {
            throw ia;
        }
        catch (InvalidApiKeyException e) {
            throw e;
        }
        catch (Exception e1) {
            System.out.println("Get converstion " + e1.toString());
        }
        return null;
    }

    public void setFreeForm(int freeFormType) {
        this.freeFormValue = freeFormType;
    }

    public void setOptionalCommand(String command, String parameter) {
        this.optional.put(command, parameter);
    }

    public void clearMetaAndOptionalCommands() {
        this.optional = new Hashtable();
    }

    public void addAlias(String aliasName, String[] phrases) {
        if (aliasName != null && phrases != null && phrases.length > 0) {
            this.h.put(aliasName.toUpperCase(), phrases);
        }
    }

    public void clear() {
        this.h.clear();
    }

    public void addCommand(String[] commandPhrases) {
        if (commandPhrases != null && commandPhrases.length > 0) {
            this.h.put("command" + String.valueOf(this.commandIndex), commandPhrases);
            ++this.commandIndex;
        }
    }

    public void addCommand(String commandPhrase) {
        this.addCommand(new String[]{commandPhrase});
    }

    public void setLanguage(String localeCode) {
        this.asrLocale = localeCode;
    }

    public static interface SpeechRecognizerEvent {
        public static final int RECORDING_COMMITTED = 1;
        public static final int RECORDING_CANCELED = 2;
        public static final int RECORDING_ERROR = 3;

        public void stateChanged(int var1, int var2, Exception var3);
    }
}

