/*
 * Decompiled with CFR 0.152.
 */
package com.iSpeech;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class SerializableHashTable {
    private Hashtable _h = new Hashtable();

    SerializableHashTable() {
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        Vector<byte[]> elements = new Vector<byte[]>();
        int totalSize = 0;
        Enumeration keys = this._h.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            byte[] value = this.getBytes(key);
            ByteArrayOutputStream e1 = new ByteArrayOutputStream();
            DataOutputStream e = new DataOutputStream(e1);
            e.writeShort(key.length());
            e.write(key.getBytes("utf8"));
            e.writeShort(value.length);
            e.write(value);
            byte[] ed = e1.toByteArray();
            elements.addElement(ed);
            e.close();
            e1.close();
            totalSize += ed.length;
        }
        out.writeInt(totalSize + 2);
        out.writeShort(this._h.size());
        Enumeration e = elements.elements();
        while (e.hasMoreElements()) {
            out.write((byte[])e.nextElement());
        }
        return baos.toByteArray();
    }

    public Object put(String key, String value) {
        try {
            return this._h.put(key, value.getBytes("utf8"));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object put(String key, byte[] value) {
        return this._h.put(key, value);
    }

    public byte[] getBytes(String key) {
        return (byte[])this._h.get(key);
    }

    public String getString(String key) {
        try {
            return new String(this.getBytes(key), "utf8");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static SerializableHashTable deserialize(byte[] data) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        DataInputStream in = new DataInputStream(bais);
        int totalSize = in.readInt();
        SerializableHashTable h = new SerializableHashTable();
        if (data.length - 4 == totalSize) {
            int elementCount = in.readShort();
            int i = 0;
            while (i < elementCount) {
                short keyLength = in.readShort();
                byte[] buffer = new byte[keyLength];
                in.read(buffer);
                String key = new String(buffer, "utf8");
                short valueLength = in.readShort();
                buffer = new byte[valueLength];
                in.read(buffer);
                h.put(key, buffer);
                ++i;
            }
            return h;
        }
        return null;
    }

    public boolean containsKey(String key) {
        return this._h.containsKey(key);
    }
}

