/*
 * Decompiled with CFR 0.152.
 */
package com.iSpeech;

import com.iSpeech.SerializableHashTable;
import com.iSpeech.StreamingOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;

class ASRStreamer {
    private DataOutputStream _out;
    private DataInputStream _in;
    private HttpURLConnection _connection;
    private static String _serverAddressDeveloper = "http://dev.ispeech.org:80/api/rest/?";
    private static String _serverAddressProduction = "http://asr.ispeech.org/api/rest/?";
    private StreamingOutputStream _output = new StreamingOutputStream(this);
    public boolean isReady = false;

    public StreamingOutputStream connect(String parameters, String mime, boolean production) throws Exception {
        URL url = new URL(String.valueOf(production ? _serverAddressProduction : _serverAddressDeveloper) + parameters);
        this._connection = (HttpURLConnection)url.openConnection();
        this._connection.setRequestMethod("POST");
        this._connection.addRequestProperty("X-Stream", "http");
        this._connection.addRequestProperty("Content-Type", mime);
        this._connection.setDoInput(true);
        this._connection.setDoOutput(true);
        this._out = new DataOutputStream(this._connection.getOutputStream());
        this.isReady = true;
        return this._output;
    }

    public void close() throws IOException {
        this._connection.disconnect();
        this._in.close();
        this._out.close();
    }

    public void send(byte[] data) throws IOException {
        if (data != null && data.length > 0) {
            this._out.writeInt(data.length);
            this._out.write(data);
        }
    }

    public void sendLastPacket() throws IOException {
        this._out.writeInt(0);
        this._out.flush();
    }

    public SerializableHashTable getResponseASR() throws IOException {
        int size = Integer.parseInt(this._connection.getHeaderField("Content-Length"));
        this._in = new DataInputStream(this._connection.getInputStream());
        if (size == 0) {
            System.out.println("error");
        }
        if (size > 0) {
            byte[] dataPacket = new byte[size];
            this._in.readFully(dataPacket, 0, size);
            return SerializableHashTable.deserialize(dataPacket);
        }
        return null;
    }

    public static int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }
}

