/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context.beanstore.http;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jboss.weld.context.beanstore.NamingScheme;
import org.jboss.weld.context.beanstore.http.LazySessionBeanStore;
import org.jboss.weld.util.collections.EnumerationList;
import org.jboss.weld.util.reflection.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyCyclicSessionBeanStore
extends LazySessionBeanStore {
    private static ThreadLocal<Map<String, Object>> temp = new ThreadLocal();

    public LazyCyclicSessionBeanStore(HttpServletRequest request, NamingScheme namingScheme) {
        super(request, namingScheme);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected HttpSession getSession(boolean create) {
        boolean newTemp;
        HttpSession session = null;
        Map<String, Object> map = temp.get();
        boolean bl = newTemp = create && map == null;
        if (newTemp) {
            map = new HashMap<String, Object>();
            temp.set(map);
        }
        try {
            HttpSession httpSession = session = super.getSession(create);
            return httpSession;
        }
        finally {
            if (create) {
                if (newTemp) {
                    temp.remove();
                }
                if (session != null && !map.isEmpty()) {
                    for (Map.Entry<String, Object> entry : map.entrySet()) {
                        session.setAttribute(entry.getKey(), entry.getValue());
                    }
                }
            }
        }
    }

    @Override
    protected Collection<String> getAttributeNames() {
        Map<String, Object> map = temp.get();
        if (map != null) {
            HashSet<String> names = new HashSet<String>();
            names.addAll(map.keySet());
            HttpSession session = this.getSessionIfExists();
            if (session != null) {
                names.addAll((Collection<String>)((Object)new EnumerationList((Enumeration)Reflections.cast(session.getAttributeNames()))));
            }
            return names;
        }
        return super.getAttributeNames();
    }

    @Override
    protected void removeAttribute(String key) {
        Map<String, Object> map = temp.get();
        if (map != null) {
            map.remove(key);
            HttpSession session = this.getSessionIfExists();
            if (session != null) {
                session.removeAttribute(key);
            }
        } else {
            super.removeAttribute(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setAttribute(String key, Object instance) {
        Map<String, Object> map = temp.get();
        boolean created = map == null;
        try {
            if (map == null) {
                map = new HashMap<String, Object>();
                map.put(key, instance);
                temp.set(map);
                super.setAttribute(key, instance);
            } else {
                map.put(key, instance);
            }
        }
        finally {
            if (created) {
                temp.remove();
            }
        }
    }

    @Override
    protected Object getAttribute(String prefixedId) {
        Map<String, Object> map = temp.get();
        if (map != null) {
            Object value = map.get(prefixedId);
            if (value != null) {
                return value;
            }
            HttpSession session = this.getSessionIfExists();
            if (session != null) {
                return session.getAttribute(prefixedId);
            }
            return null;
        }
        return super.getAttribute(prefixedId);
    }
}

