/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.decorator.Delegate;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.New;
import javax.enterprise.inject.Specializes;
import javax.enterprise.inject.Stereotype;
import javax.enterprise.inject.Typed;
import javax.inject.Named;
import javax.inject.Qualifier;
import org.jboss.weld.Container;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.injection.WeldInjectionPoint;
import org.jboss.weld.introspector.WeldAnnotated;
import org.jboss.weld.literal.AnyLiteral;
import org.jboss.weld.literal.DefaultLiteral;
import org.jboss.weld.literal.NamedLiteral;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.cache.MergedStereotypes;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.BeansClosure;
import org.jboss.weld.util.collections.ArraySet;
import org.jboss.weld.util.reflection.Reflections;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBean<T, S>
extends RIBean<T> {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BEAN);
    protected Set<Annotation> qualifiers;
    protected String name;
    protected Class<? extends Annotation> scope;
    private MergedStereotypes<T, S> mergedStereotypes;
    protected boolean alternative;
    protected Class<T> type;
    protected Set<Type> types;
    private ArraySet<WeldInjectionPoint<?, ?>> injectionPoints;
    private ArraySet<WeldInjectionPoint<?, ?>> delegateInjectionPoints;
    private ArraySet<WeldInjectionPoint<?, ?>> newInjectionPoints;
    protected BeanManagerImpl beanManager;
    private final ServiceRegistry services;
    private boolean initialized;
    private boolean proxyRequired;

    public AbstractBean(String idSuffix, BeanManagerImpl beanManager, ServiceRegistry services) {
        super(idSuffix, beanManager);
        this.beanManager = beanManager;
        this.injectionPoints = new ArraySet();
        this.delegateInjectionPoints = new ArraySet();
        this.newInjectionPoints = new ArraySet();
        this.services = services;
    }

    @Override
    public void cleanupAfterBoot() {
        this.injectionPoints.trimToSize();
        this.delegateInjectionPoints.trimToSize();
        this.newInjectionPoints.trimToSize();
    }

    @Override
    public void initialize(BeanDeployerEnvironment environment) {
        this.initialized = true;
        if (this.isSpecializing()) {
            this.preSpecialize(environment);
            this.specialize(environment);
            this.postSpecialize();
        }
        this.initDefaultQualifiers();
        log.trace((Enum)BeanMessage.CREATING_BEAN, new Object[]{this.getType()});
        this.initName();
        this.initScope();
        this.checkDelegateInjectionPoints();
        this.proxyRequired = this.getScope() != null ? ((MetaAnnotationStore)Container.instance().services().get(MetaAnnotationStore.class)).getScopeModel(this.getScope()).isNormal() : false;
        this.qualifiers = Collections.unmodifiableSet(new ArraySet<Annotation>(this.qualifiers));
    }

    protected void initStereotypes() {
        this.mergedStereotypes = new MergedStereotypes(this.getWeldAnnotated().getMetaAnnotations(Stereotype.class), this.beanManager);
    }

    protected void checkDelegateInjectionPoints() {
        if (this.delegateInjectionPoints.size() > 0) {
            throw new DefinitionException(BeanMessage.DELEGATE_NOT_ON_DECORATOR, this);
        }
    }

    @Override
    public void initializeAfterBeanDiscovery() {
        this.checkType();
    }

    protected abstract void checkType();

    protected void addInjectionPoint(WeldInjectionPoint<?, ?> injectionPoint) {
        if (injectionPoint.isAnnotationPresent(Delegate.class)) {
            this.delegateInjectionPoints.add(injectionPoint);
        }
        if (injectionPoint.isAnnotationPresent(New.class)) {
            this.newInjectionPoints.add(injectionPoint);
        }
        this.injectionPoints.add(injectionPoint);
    }

    protected void addInjectionPoints(Iterable<? extends WeldInjectionPoint<?, ?>> injectionPoints) {
        for (WeldInjectionPoint<?, ?> injectionPoint : injectionPoints) {
            this.addInjectionPoint(injectionPoint);
        }
    }

    protected Set<WeldInjectionPoint<?, ?>> getDelegateInjectionPoints() {
        return this.delegateInjectionPoints;
    }

    protected void initTypes() {
        if (this.getWeldAnnotated().isAnnotationPresent(Typed.class)) {
            this.types = Collections.unmodifiableSet(new ArraySet<Type>(AbstractBean.getTypedTypes(Reflections.buildTypeMap(this.getWeldAnnotated().getTypeClosure()), this.getWeldAnnotated().getJavaClass(), (Typed)this.getWeldAnnotated().getAnnotation(Typed.class))));
        } else if (this.getType().isInterface()) {
            this.types = new ArraySet<Type>(this.getWeldAnnotated().getTypeClosure());
            this.types.add((Type)((Object)Object.class));
            this.types = Collections.unmodifiableSet(this.types);
        } else {
            this.types = this.getWeldAnnotated().getTypeClosure();
        }
    }

    protected static Set<Type> getTypedTypes(Map<Class<?>, Type> typeClosure, Class<?> rawType, Typed typed) {
        HashSet<Type> types = new HashSet<Type>();
        for (Class specifiedClass : typed.value()) {
            Type tmp = typeClosure.get(specifiedClass);
            if (tmp == null) {
                throw new DefinitionException(BeanMessage.TYPED_CLASS_NOT_IN_HIERARCHY, specifiedClass.getName(), rawType);
            }
            types.add(tmp);
        }
        types.add((Type)((Object)Object.class));
        return types;
    }

    protected void initQualifiers() {
        this.qualifiers = new HashSet<Annotation>();
        this.qualifiers.addAll(this.getWeldAnnotated().getMetaAnnotations(Qualifier.class));
        this.initDefaultQualifiers();
        log.trace((Enum)BeanMessage.QUALIFIERS_USED, new Object[]{this.qualifiers, this});
    }

    protected void initDefaultQualifiers() {
        if (this.qualifiers.size() == 0) {
            log.trace((Enum)BeanMessage.USING_DEFAULT_QUALIFIER, new Object[]{this});
            this.qualifiers.add((Annotation)DefaultLiteral.INSTANCE);
        }
        if (this.qualifiers.size() == 1 && this.qualifiers.iterator().next().annotationType().equals(Named.class)) {
            log.trace((Enum)BeanMessage.USING_DEFAULT_QUALIFIER, new Object[]{this});
            this.qualifiers.add((Annotation)DefaultLiteral.INSTANCE);
        }
        this.qualifiers.add((Annotation)AnyLiteral.INSTANCE);
        boolean foundRemoved = false;
        Iterator<Annotation> qIter = this.qualifiers.iterator();
        while (qIter.hasNext()) {
            Annotation next = qIter.next();
            if (!next.annotationType().equals(Named.class)) continue;
            Named named = (Named)next;
            if (named.value().length() != 0) break;
            qIter.remove();
            foundRemoved = true;
            break;
        }
        if (foundRemoved) {
            NamedLiteral named = new NamedLiteral(this.getDefaultName());
            this.qualifiers.add((Annotation)((Object)named));
        }
    }

    protected void initAlternative() {
        this.alternative = Beans.isAlternative(this.getWeldAnnotated(), this.getMergedStereotypes());
    }

    protected void initName() {
        boolean beanNameDefaulted = false;
        if (this.getWeldAnnotated().isAnnotationPresent(Named.class)) {
            String javaName = ((Named)this.getWeldAnnotated().getAnnotation(Named.class)).value();
            if ("".equals(javaName)) {
                beanNameDefaulted = true;
            } else {
                log.trace((Enum)BeanMessage.USING_NAME, new Object[]{javaName, this});
                this.name = javaName;
                return;
            }
        }
        if (beanNameDefaulted || this.getMergedStereotypes().isBeanNameDefaulted()) {
            this.name = this.getDefaultName();
            log.trace((Enum)BeanMessage.USING_DEFAULT_NAME, new Object[]{this.name, this});
        }
    }

    protected abstract void initScope();

    protected boolean initScopeFromStereotype() {
        Set<Annotation> possibleScopes = this.getMergedStereotypes().getPossibleScopes();
        if (possibleScopes.size() == 1) {
            this.scope = possibleScopes.iterator().next().annotationType();
            log.trace((Enum)BeanMessage.USING_SCOPE_FROM_STEREOTYPE, new Object[]{this.scope, this, this.getMergedStereotypes()});
            return true;
        }
        if (possibleScopes.size() > 1) {
            throw new DefinitionException(BeanMessage.MULTIPLE_SCOPES_FOUND_FROM_STEREOTYPES, this.getWeldAnnotated());
        }
        return false;
    }

    protected void postSpecialize() {
        if (this.getWeldAnnotated().isAnnotationPresent(Named.class) && ((AbstractBean)this.getSpecializedBean()).getWeldAnnotated().isAnnotationPresent(Named.class)) {
            throw new DefinitionException(BeanMessage.NAME_NOT_ALLOWED_ON_SPECIALIZATION, this.getWeldAnnotated());
        }
        for (Type type : ((AbstractBean)this.getSpecializedBean()).getTypes()) {
            if (this.getTypes().contains(type)) continue;
            throw new DefinitionException(BeanMessage.SPECIALIZING_BEAN_MISSING_SPECIALIZED_TYPE, this, type, this.getSpecializedBean());
        }
        this.qualifiers.addAll(((AbstractBean)this.getSpecializedBean()).getQualifiers());
        if (this.isSpecializing() && ((AbstractBean)this.getSpecializedBean()).getWeldAnnotated().isAnnotationPresent(Named.class)) {
            this.name = ((AbstractBean)this.getSpecializedBean()).getName();
        }
        BeansClosure closure = this.beanManager.getClosure();
        closure.addSpecialized(this.getSpecializedBean(), this);
    }

    protected void preSpecialize(BeanDeployerEnvironment environment) {
    }

    protected void specialize(BeanDeployerEnvironment environment) {
    }

    public abstract WeldAnnotated<T, S> getWeldAnnotated();

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    protected abstract String getDefaultName();

    public abstract AbstractBean<?, ?> getSpecializedBean();

    @Override
    public Set<WeldInjectionPoint<?, ?>> getWeldInjectionPoints() {
        return this.injectionPoints;
    }

    public Set<WeldInjectionPoint<?, ?>> getNewInjectionPoints() {
        return this.newInjectionPoints;
    }

    protected MergedStereotypes<T, S> getMergedStereotypes() {
        return this.mergedStereotypes;
    }

    public String getName() {
        return this.name;
    }

    public Class<? extends Annotation> getScope() {
        return this.scope;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public boolean isNullable() {
        return !this.isPrimitive();
    }

    @Override
    public boolean isPrimitive() {
        return this.getWeldAnnotated().isPrimitive();
    }

    @Override
    public boolean isDependent() {
        return Dependent.class.equals(this.getScope());
    }

    public boolean isNormalScoped() {
        return ((MetaAnnotationStore)Container.instance().services().get(MetaAnnotationStore.class)).getScopeModel(this.getScope()).isNormal();
    }

    public boolean isAlternative() {
        return this.alternative;
    }

    @Override
    public boolean isSpecializing() {
        return this.getWeldAnnotated().isAnnotationPresent(Specializes.class);
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return this.mergedStereotypes.getStereotypes();
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public boolean isProxyRequired() {
        return this.proxyRequired;
    }

    protected ServiceRegistry getServices() {
        return this.services;
    }

    public abstract boolean hasDefaultProducer();
}

