/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.logging.ConnectorMessages;
import org.jboss.as.connector.subsystems.datasources.AbstractDataSourceService;
import org.jboss.as.connector.subsystems.datasources.ConnectionPropertiesService;
import org.jboss.as.connector.subsystems.datasources.Constants;
import org.jboss.as.connector.subsystems.datasources.DataSourceConfigService;
import org.jboss.as.connector.subsystems.datasources.DataSourceModelNodeUtil;
import org.jboss.as.connector.subsystems.datasources.DataSourceReferenceFactoryService;
import org.jboss.as.connector.subsystems.datasources.ModifiableDataSource;
import org.jboss.as.connector.subsystems.datasources.ModifiableXaDataSource;
import org.jboss.as.connector.subsystems.datasources.XADataSourceConfigService;
import org.jboss.as.connector.subsystems.datasources.XaDataSourcePropertiesService;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.security.service.SecurityDomainService;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.common.api.metadata.ds.DsSecurity;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.ds.DataSourceAbstractImpl;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;

public class DataSourceEnable
implements OperationStepHandler {
    static final DataSourceEnable LOCAL_INSTANCE = new DataSourceEnable(false);
    static final DataSourceEnable XA_INSTANCE = new DataSourceEnable(true);
    private final boolean xa;

    public DataSourceEnable(boolean xa) {
        this.xa = xa;
    }

    public void execute(OperationContext context, ModelNode operation) {
        final ModelNode model = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel();
        boolean persist = operation.get("persistent").asBoolean(true);
        if (persist) {
            model.get("enabled").set(true);
        } else if (model.hasDefined("enabled") && !model.get("enabled").asBoolean()) {
            model.get("enabled").set(new ModelNode());
        }
        if (context.isNormalServer()) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceVerificationHandler verificationHandler = new ServiceVerificationHandler();
                    final ArrayList controllers = new ArrayList();
                    DataSourceEnable.addServices(context, operation, verificationHandler, model, DataSourceEnable.this.isXa(), controllers);
                    context.addStep((OperationStepHandler)verificationHandler, OperationContext.Stage.VERIFY);
                    context.completeStep(new OperationContext.RollbackHandler(){

                        public void handleRollback(OperationContext context, ModelNode operation) {
                            DataSourceEnable.this.rollbackRuntime(context, operation, model, controllers);
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.stepCompleted();
    }

    static void addServices(OperationContext context, ModelNode operation, ServiceVerificationHandler verificationHandler, ModelNode model, boolean isXa, List<ServiceController<?>> controllers) throws OperationFailedException {
        DsSecurity dsSecurityConfig;
        ServiceBuilder builder;
        DataSourceAbstractImpl dataSourceConfig;
        ServiceTarget serviceTarget = context.getServiceTarget();
        ModelNode address = operation.require("address");
        String dsName = PathAddress.pathAddress((ModelNode)address).getLastElement().getValue();
        final String jndiName = model.get(Constants.JNDI_NAME.getName()).asString();
        ServiceRegistry registry = context.getServiceRegistry(true);
        List serviceNames = registry.getServiceNames();
        if (isXa) {
            String securityDomainName;
            try {
                dataSourceConfig = DataSourceModelNodeUtil.xaFrom(context, model, dsName);
            }
            catch (ValidateException e) {
                throw new OperationFailedException((Throwable)e, new ModelNode().set(ConnectorMessages.MESSAGES.failedToCreate("XaDataSource", operation, e.getLocalizedMessage())));
            }
            ServiceName xaDataSourceConfigServiceName = XADataSourceConfigService.SERVICE_NAME_BASE.append(new String[]{dsName});
            XADataSourceConfigService xaDataSourceConfigService = new XADataSourceConfigService((ModifiableXaDataSource)dataSourceConfig);
            builder = serviceTarget.addService(xaDataSourceConfigServiceName, (Service)xaDataSourceConfigService);
            if (verificationHandler != null) {
                builder.addListener((ServiceListener)verificationHandler);
            }
            if ((dsSecurityConfig = dataSourceConfig.getSecurity()) != null && (securityDomainName = dsSecurityConfig.getSecurityDomain()) != null) {
                builder.addDependency(SecurityDomainService.SERVICE_NAME.append(new String[]{securityDomainName}));
            }
            int propertiesCount = 0;
            for (ServiceName name : serviceNames) {
                if (!xaDataSourceConfigServiceName.append(new String[]{"xa-datasource-properties"}).isParentOf(name)) continue;
                ServiceController xaConfigPropertyController = registry.getService(name);
                XaDataSourcePropertiesService xaPropService = (XaDataSourcePropertiesService)xaConfigPropertyController.getService();
                if (!ServiceController.State.UP.equals((Object)xaConfigPropertyController.getState())) {
                    ++propertiesCount;
                    xaConfigPropertyController.setMode(ServiceController.Mode.ACTIVE);
                    builder.addDependency(name, String.class, xaDataSourceConfigService.getXaDataSourcePropertyInjector(xaPropService.getName()));
                    continue;
                }
                throw new OperationFailedException(new ModelNode().set(ConnectorMessages.MESSAGES.serviceAlreadyStarted("Data-source.xa-config-property", name)));
            }
            if (propertiesCount == 0) {
                throw ConnectorMessages.MESSAGES.xaDataSourcePropertiesNotPresent();
            }
            controllers.add(builder.install());
        } else {
            String securityDomainName;
            try {
                dataSourceConfig = DataSourceModelNodeUtil.from(context, model, dsName);
            }
            catch (ValidateException e) {
                throw new OperationFailedException((Throwable)e, new ModelNode().set(ConnectorMessages.MESSAGES.failedToCreate("DataSource", operation, e.getLocalizedMessage())));
            }
            ServiceName dataSourceCongServiceName = DataSourceConfigService.SERVICE_NAME_BASE.append(new String[]{dsName});
            DataSourceConfigService configService = new DataSourceConfigService((ModifiableDataSource)dataSourceConfig);
            builder = serviceTarget.addService(dataSourceCongServiceName, (Service)configService);
            if (verificationHandler != null) {
                builder.addListener((ServiceListener)verificationHandler);
            }
            if ((dsSecurityConfig = dataSourceConfig.getSecurity()) != null && (securityDomainName = dsSecurityConfig.getSecurityDomain()) != null) {
                builder.addDependency(SecurityDomainService.SERVICE_NAME.append(new String[]{securityDomainName}));
            }
            for (ServiceName name : serviceNames) {
                if (!dataSourceCongServiceName.append(new String[]{"connection-properties"}).isParentOf(name)) continue;
                ServiceController dataSourceController = registry.getService(name);
                ConnectionPropertiesService connPropService = (ConnectionPropertiesService)dataSourceController.getService();
                if (!ServiceController.State.UP.equals((Object)dataSourceController.getState())) {
                    dataSourceController.setMode(ServiceController.Mode.ACTIVE);
                    builder.addDependency(name, String.class, configService.getConnectionPropertyInjector(connPropService.getName()));
                    continue;
                }
                throw new OperationFailedException(new ModelNode().set(ConnectorMessages.MESSAGES.serviceAlreadyStarted("Data-source.connectionProperty", name)));
            }
            controllers.add(builder.install());
        }
        ServiceName dataSourceServiceName = AbstractDataSourceService.SERVICE_NAME_BASE.append(new String[]{jndiName});
        ServiceController dataSourceController = registry.getService(dataSourceServiceName);
        if (dataSourceController != null) {
            if (ServiceController.State.UP.equals((Object)dataSourceController.getState())) {
                throw new OperationFailedException(new ModelNode().set(ConnectorMessages.MESSAGES.serviceAlreadyStarted("Data-source", dsName)));
            }
        } else {
            throw new OperationFailedException(new ModelNode().set(ConnectorMessages.MESSAGES.serviceNotAvailable("Data-source", dsName)));
        }
        dataSourceController.setMode(ServiceController.Mode.ACTIVE);
        DataSourceReferenceFactoryService referenceFactoryService = new DataSourceReferenceFactoryService();
        ServiceName referenceFactoryServiceName = DataSourceReferenceFactoryService.SERVICE_NAME_BASE.append(new String[]{dsName});
        ServiceBuilder referenceBuilder = serviceTarget.addService(referenceFactoryServiceName, (Service)referenceFactoryService).addDependency(dataSourceServiceName, DataSource.class, referenceFactoryService.getDataSourceInjector());
        if (verificationHandler != null) {
            referenceBuilder.addListener((ServiceListener)verificationHandler);
        }
        controllers.add(referenceBuilder.install());
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
        BinderService binderService = new BinderService(bindInfo.getBindName());
        ServiceBuilder binderBuilder = serviceTarget.addService(bindInfo.getBinderServiceName(), (Service)binderService).addDependency(referenceFactoryServiceName, ManagedReferenceFactory.class, binderService.getManagedObjectInjector()).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, binderService.getNamingStoreInjector()).addListener((ServiceListener)new AbstractServiceListener<Object>(){

            public void transition(ServiceController<? extends Object> controller, ServiceController.Transition transition) {
                switch (transition) {
                    case STARTING_to_UP: {
                        ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.boundDataSource(jndiName);
                        break;
                    }
                    case STOPPING_to_DOWN: {
                        ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.unboundDataSource(jndiName);
                        break;
                    }
                    case REMOVING_to_REMOVED: {
                        ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.debugf("Removed JDBC Data-source [%s]", jndiName);
                    }
                }
            }
        });
        binderBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        if (verificationHandler != null) {
            binderBuilder.addListener((ServiceListener)verificationHandler);
        }
        controllers.add(binderBuilder.install());
    }

    public static DataSourceEnable getLocalInstance() {
        return LOCAL_INSTANCE;
    }

    public boolean isXa() {
        return this.xa;
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, ModelNode model, List<ServiceController<?>> controllers) {
        for (ServiceController<?> controller : controllers) {
            context.removeService(controller.getName());
        }
    }
}

