/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.modules.AssertionSetting;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.FastCopyHashSet;
import org.jboss.modules.FileResourceLoader;
import org.jboss.modules.JarFileResourceLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.NativeLibraryResourceLoader;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.filter.MultiplePathFilterBuilder;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;

final class ModuleXmlParser {
    private static final XMLInputFactory INPUT_FACTORY = XMLInputFactory.newInstance();

    private ModuleXmlParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ModuleSpec parseModuleXml(ModuleIdentifier moduleIdentifier, File root, File moduleInfoFile) throws ModuleLoadException {
        FileInputStream fis;
        try {
            fis = new FileInputStream(moduleInfoFile);
        }
        catch (FileNotFoundException e) {
            throw new ModuleLoadException("No module.xml file found at " + moduleInfoFile);
        }
        try {
            ModuleSpec moduleSpec = ModuleXmlParser.parseModuleXml(new ResourceRootFactory(){

                @Override
                public ResourceLoader createResourceLoader(String rootPath, String loaderPath, String loaderName) throws IOException {
                    File file = new File(rootPath, loaderPath);
                    if (file.isDirectory()) {
                        return new FileResourceLoader(loaderName, file);
                    }
                    JarFile jarFile = new JarFile(file, true);
                    return new JarFileResourceLoader(loaderName, jarFile);
                }
            }, root.getPath(), new BufferedInputStream(fis), moduleInfoFile.getPath(), moduleIdentifier);
            return moduleSpec;
        }
        finally {
            ModuleXmlParser.safeClose(fis);
        }
    }

    private static void setIfSupported(XMLInputFactory inputFactory, String property, Object value) {
        if (inputFactory.isPropertySupported(property)) {
            inputFactory.setProperty(property, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ModuleSpec parseModuleXml(ResourceRootFactory factory, String rootPath, InputStream source, String moduleInfoFile, ModuleIdentifier moduleIdentifier) throws ModuleLoadException {
        ModuleSpec moduleSpec;
        XMLInputFactory inputFactory = INPUT_FACTORY;
        ModuleXmlParser.setIfSupported(inputFactory, "javax.xml.stream.isValidating", Boolean.FALSE);
        ModuleXmlParser.setIfSupported(inputFactory, "javax.xml.stream.supportDTD", Boolean.FALSE);
        XMLStreamReader streamReader = inputFactory.createXMLStreamReader(source);
        try {
            moduleSpec = ModuleXmlParser.parseDocument(factory, rootPath, streamReader, moduleIdentifier);
        }
        catch (Throwable throwable) {
            try {
                ModuleXmlParser.safeClose(streamReader);
                throw throwable;
            }
            catch (XMLStreamException e) {
                throw new ModuleLoadException("Error loading module from " + moduleInfoFile, e);
            }
        }
        ModuleXmlParser.safeClose(streamReader);
        return moduleSpec;
    }

    private static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void safeClose(XMLStreamReader streamReader) {
        if (streamReader != null) {
            try {
                streamReader.close();
            }
            catch (XMLStreamException xMLStreamException) {
                // empty catch block
            }
        }
    }

    private static XMLStreamException unexpectedContent(XMLStreamReader reader) {
        String kind;
        switch (reader.getEventType()) {
            case 10: {
                kind = "attribute";
                break;
            }
            case 12: {
                kind = "cdata";
                break;
            }
            case 4: {
                kind = "characters";
                break;
            }
            case 5: {
                kind = "comment";
                break;
            }
            case 11: {
                kind = "dtd";
                break;
            }
            case 8: {
                kind = "document end";
                break;
            }
            case 2: {
                kind = "element end";
                break;
            }
            case 15: {
                kind = "entity declaration";
                break;
            }
            case 9: {
                kind = "entity ref";
                break;
            }
            case 13: {
                kind = "namespace";
                break;
            }
            case 14: {
                kind = "notation declaration";
                break;
            }
            case 3: {
                kind = "processing instruction";
                break;
            }
            case 6: {
                kind = "whitespace";
                break;
            }
            case 7: {
                kind = "document start";
                break;
            }
            case 1: {
                kind = "element start";
                break;
            }
            default: {
                kind = "unknown";
            }
        }
        StringBuilder b = new StringBuilder("Unexpected content of type '").append(kind).append('\'');
        if (reader.hasName()) {
            b.append(" named '").append(reader.getName()).append('\'');
        }
        if (reader.hasText()) {
            b.append(", text is: '").append(reader.getText()).append('\'');
        }
        return new XMLStreamException(b.toString(), reader.getLocation());
    }

    private static XMLStreamException endOfDocument(Location location) {
        return new XMLStreamException("Unexpected end of document", location);
    }

    private static XMLStreamException invalidModuleName(Location location, ModuleIdentifier expected) {
        return new XMLStreamException("Invalid/mismatched module name (expected " + expected + ")", location);
    }

    private static XMLStreamException missingAttributes(Location location, Set<Attribute> required) {
        StringBuilder b = new StringBuilder("Missing one or more required attributes:");
        for (Attribute attribute : required) {
            b.append(' ').append((Object)attribute);
        }
        return new XMLStreamException(b.toString(), location);
    }

    private static ModuleSpec parseDocument(ResourceRootFactory factory, String rootPath, XMLStreamReader reader, ModuleIdentifier moduleIdentifier) throws XMLStreamException {
        if (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 7: {
                    return ModuleXmlParser.parseRootElement(factory, rootPath, reader, moduleIdentifier);
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case MODULE: {
                            ModuleSpec.Builder specBuilder = ModuleSpec.build(moduleIdentifier);
                            ModuleXmlParser.parseModuleContents(factory, rootPath, reader, specBuilder);
                            ModuleXmlParser.parseEndDocument(reader);
                            return specBuilder.create();
                        }
                        case MODULE_ALIAS: {
                            ModuleSpec moduleSpec = ModuleXmlParser.parseModuleAliasContents(reader, moduleIdentifier);
                            ModuleXmlParser.parseEndDocument(reader);
                            return moduleSpec;
                        }
                        case MODULE_ABSENT: {
                            ModuleXmlParser.parseModuleAbsentContents(reader, moduleIdentifier);
                            return null;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        throw ModuleXmlParser.endOfDocument(reader.getLocation());
    }

    private static ModuleSpec parseRootElement(ResourceRootFactory factory, String rootPath, XMLStreamReader reader, ModuleIdentifier moduleIdentifier) throws XMLStreamException {
        if (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case MODULE: {
                            ModuleSpec.Builder specBuilder = ModuleSpec.build(moduleIdentifier);
                            ModuleXmlParser.parseModuleContents(factory, rootPath, reader, specBuilder);
                            ModuleXmlParser.parseEndDocument(reader);
                            return specBuilder.create();
                        }
                        case MODULE_ALIAS: {
                            ModuleSpec moduleSpec = ModuleXmlParser.parseModuleAliasContents(reader, moduleIdentifier);
                            ModuleXmlParser.parseEndDocument(reader);
                            return moduleSpec;
                        }
                        case MODULE_ABSENT: {
                            ModuleXmlParser.parseModuleAbsentContents(reader, moduleIdentifier);
                            return null;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        throw ModuleXmlParser.endOfDocument(reader.getLocation());
    }

    private static ModuleSpec parseModuleAliasContents(XMLStreamReader reader, ModuleIdentifier moduleIdentifier) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String name = null;
        String slot = null;
        String targetName = null;
        String targetSlot = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.TARGET_NAME);
        block9: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block9;
                }
                case SLOT: {
                    slot = reader.getAttributeValue(i);
                    continue block9;
                }
                case TARGET_NAME: {
                    targetName = reader.getAttributeValue(i);
                    continue block9;
                }
                case TARGET_SLOT: {
                    targetSlot = reader.getAttributeValue(i);
                    continue block9;
                }
                default: {
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader.getLocation(), required);
        }
        if (!moduleIdentifier.equals(ModuleIdentifier.create(name, slot))) {
            throw ModuleXmlParser.invalidModuleName(reader.getLocation(), moduleIdentifier);
        }
        if (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return ModuleSpec.buildAlias(moduleIdentifier, ModuleIdentifier.create(targetName, targetSlot)).create();
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        throw ModuleXmlParser.endOfDocument(reader.getLocation());
    }

    private static void parseModuleAbsentContents(XMLStreamReader reader, ModuleIdentifier moduleIdentifier) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String name = null;
        String slot = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.TARGET_NAME);
        block7: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block7;
                }
                case SLOT: {
                    slot = reader.getAttributeValue(i);
                    continue block7;
                }
                default: {
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader.getLocation(), required);
        }
        if (!moduleIdentifier.equals(ModuleIdentifier.create(name, slot))) {
            throw ModuleXmlParser.invalidModuleName(reader.getLocation(), moduleIdentifier);
        }
        if (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        throw ModuleXmlParser.endOfDocument(reader.getLocation());
    }

    private static void parseModuleContents(ResourceRootFactory factory, String rootPath, XMLStreamReader reader, ModuleSpec.Builder specBuilder) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String name = null;
        String slot = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        block15: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block15;
                }
                case SLOT: {
                    slot = reader.getAttributeValue(i);
                    continue block15;
                }
                default: {
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader.getLocation(), required);
        }
        if (!specBuilder.getIdentifier().equals(ModuleIdentifier.create(name, slot))) {
            throw ModuleXmlParser.invalidModuleName(reader.getLocation(), specBuilder.getIdentifier());
        }
        MultiplePathFilterBuilder exportsBuilder = PathFilters.multiplePathFilterBuilder(true);
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        block16: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    specBuilder.addDependency(DependencySpec.createLocalDependencySpec(PathFilters.acceptAll(), exportsBuilder.create()));
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    if (visited.contains((Object)element)) {
                        throw ModuleXmlParser.unexpectedContent(reader);
                    }
                    visited.add(element);
                    switch (element) {
                        case EXPORTS: {
                            ModuleXmlParser.parseFilterList(reader, exportsBuilder);
                            continue block16;
                        }
                        case DEPENDENCIES: {
                            ModuleXmlParser.parseDependencies(reader, specBuilder);
                            continue block16;
                        }
                        case MAIN_CLASS: {
                            ModuleXmlParser.parseMainClass(reader, specBuilder);
                            continue block16;
                        }
                        case RESOURCES: {
                            ModuleXmlParser.parseResources(factory, rootPath, reader, specBuilder);
                            continue block16;
                        }
                        case PROPERTIES: {
                            ModuleXmlParser.parseProperties(reader, specBuilder);
                            continue block16;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        throw ModuleXmlParser.endOfDocument(reader.getLocation());
    }

    private static void parseDependencies(XMLStreamReader reader, ModuleSpec.Builder specBuilder) throws XMLStreamException {
        block8: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case MODULE: {
                            ModuleXmlParser.parseModuleDependency(reader, specBuilder);
                            continue block8;
                        }
                        case SYSTEM: {
                            ModuleXmlParser.parseSystemDependency(reader, specBuilder);
                            continue block8;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        throw ModuleXmlParser.endOfDocument(reader.getLocation());
    }

    private static void parseModuleDependency(XMLStreamReader reader, ModuleSpec.Builder specBuilder) throws XMLStreamException {
        String name = null;
        String slot = null;
        boolean export = false;
        boolean optional = false;
        Disposition services = Disposition.NONE;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block15: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block15;
                }
                case SLOT: {
                    slot = reader.getAttributeValue(i);
                    continue block15;
                }
                case EXPORT: {
                    export = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block15;
                }
                case SERVICES: {
                    services = Disposition.of(reader.getAttributeValue(i));
                    continue block15;
                }
                case OPTIONAL: {
                    optional = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block15;
                }
                default: {
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader.getLocation(), required);
        }
        MultiplePathFilterBuilder importBuilder = PathFilters.multiplePathFilterBuilder(true);
        MultiplePathFilterBuilder exportBuilder = PathFilters.multiplePathFilterBuilder(export);
        block16: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    PathFilter importFilter;
                    if (services == Disposition.EXPORT) {
                        exportBuilder.addFilter(PathFilters.getMetaInfServicesFilter(), true);
                    }
                    if (export) {
                        exportBuilder.addFilter(PathFilters.getMetaInfSubdirectoriesFilter(), false);
                        exportBuilder.addFilter(PathFilters.getMetaInfFilter(), false);
                    }
                    PathFilter exportFilter = exportBuilder.create();
                    if (importBuilder.isEmpty()) {
                        importFilter = services == Disposition.NONE ? PathFilters.getDefaultImportFilter() : PathFilters.getDefaultImportFilterWithServices();
                    } else {
                        if (services != Disposition.NONE) {
                            importBuilder.addFilter(PathFilters.getMetaInfServicesFilter(), true);
                        }
                        importBuilder.addFilter(PathFilters.getMetaInfSubdirectoriesFilter(), false);
                        importBuilder.addFilter(PathFilters.getMetaInfFilter(), false);
                        importFilter = importBuilder.create();
                    }
                    specBuilder.addDependency(DependencySpec.createModuleDependencySpec(importFilter, exportFilter, null, ModuleIdentifier.create(name, slot), optional));
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case EXPORTS: {
                            ModuleXmlParser.parseFilterList(reader, exportBuilder);
                            continue block16;
                        }
                        case IMPORTS: {
                            ModuleXmlParser.parseFilterList(reader, importBuilder);
                            continue block16;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
    }

    private static void parseSystemDependency(XMLStreamReader reader, ModuleSpec.Builder specBuilder) throws XMLStreamException {
        boolean export = false;
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case EXPORT: {
                    export = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block11;
                }
                default: {
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
        }
        Set<String> paths = Collections.emptySet();
        MultiplePathFilterBuilder exportBuilder = PathFilters.multiplePathFilterBuilder(export);
        while (reader.hasNext()) {
            block3 : switch (reader.nextTag()) {
                case 2: {
                    PathFilter exportFilter = exportBuilder.create();
                    specBuilder.addDependency(DependencySpec.createSystemDependencySpec(PathFilters.acceptAll(), exportFilter, paths));
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case PATHS: {
                            paths = ModuleXmlParser.parseSet(reader);
                            break block3;
                        }
                        case EXPORTS: {
                            ModuleXmlParser.parseFilterList(reader, exportBuilder);
                            break block3;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
        }
    }

    private static void parseMainClass(XMLStreamReader reader, ModuleSpec.Builder specBuilder) throws XMLStreamException {
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block3;
                }
                default: {
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader.getLocation(), required);
        }
        specBuilder.setMainClass(name);
        ModuleXmlParser.parseNoContent(reader);
    }

    private static void parseResources(ResourceRootFactory factory, String rootPath, XMLStreamReader reader, ModuleSpec.Builder specBuilder) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    specBuilder.addResourceRoot(new ResourceLoaderSpec(new NativeLibraryResourceLoader(new File(rootPath, "lib")), PathFilters.rejectAll()));
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case RESOURCE_ROOT: {
                            ModuleXmlParser.parseResourceRoot(factory, rootPath, reader, specBuilder);
                            continue block7;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        throw ModuleXmlParser.endOfDocument(reader.getLocation());
    }

    private static void parseResourceRoot(ResourceRootFactory factory, String rootPath, XMLStreamReader reader, ModuleSpec.Builder specBuilder) throws XMLStreamException {
        String name = null;
        String path = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATH);
        int count = reader.getAttributeCount();
        block13: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block13;
                }
                case PATH: {
                    path = reader.getAttributeValue(i);
                    continue block13;
                }
                default: {
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader.getLocation(), required);
        }
        if (name == null) {
            name = path;
        }
        MultiplePathFilterBuilder filterBuilder = PathFilters.multiplePathFilterBuilder(true);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block14: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    ResourceLoader resourceLoader;
                    try {
                        resourceLoader = factory.createResourceLoader(rootPath, path, name);
                    }
                    catch (IOException e) {
                        throw new XMLStreamException(String.format("Failed to add resource root '%s' at path '%s'", name, path), reader.getLocation(), e);
                    }
                    specBuilder.addResourceRoot(new ResourceLoaderSpec(resourceLoader, filterBuilder.create()));
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    if (!encountered.add(element)) {
                        throw ModuleXmlParser.unexpectedContent(reader);
                    }
                    switch (element) {
                        case FILTER: {
                            ModuleXmlParser.parseFilterList(reader, filterBuilder);
                            continue block14;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
    }

    private static void parseFilterList(XMLStreamReader reader, MultiplePathFilterBuilder builder) throws XMLStreamException {
        block10: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case INCLUDE: {
                            ModuleXmlParser.parsePath(reader, true, builder);
                            continue block10;
                        }
                        case EXCLUDE: {
                            ModuleXmlParser.parsePath(reader, false, builder);
                            continue block10;
                        }
                        case INCLUDE_SET: {
                            ModuleXmlParser.parseSet(reader, true, builder);
                            continue block10;
                        }
                        case EXCLUDE_SET: {
                            ModuleXmlParser.parseSet(reader, false, builder);
                            continue block10;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        throw ModuleXmlParser.endOfDocument(reader.getLocation());
    }

    private static void parsePath(XMLStreamReader reader, boolean include, MultiplePathFilterBuilder builder) throws XMLStreamException {
        boolean literal;
        String path = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATH);
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case PATH: {
                    path = reader.getAttributeValue(i);
                    continue block3;
                }
                default: {
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader.getLocation(), required);
        }
        boolean bl = literal = path.indexOf(42) == -1 && path.indexOf(63) == -1;
        if (literal) {
            if (path.charAt(path.length() - 1) == '/') {
                builder.addFilter(PathFilters.isChildOf(path), include);
            } else {
                builder.addFilter(PathFilters.is(path), include);
            }
        } else {
            builder.addFilter(PathFilters.match(path), include);
        }
        ModuleXmlParser.parseNoContent(reader);
    }

    private static Set<String> parseSet(XMLStreamReader reader) throws XMLStreamException {
        FastCopyHashSet<String> set = new FastCopyHashSet<String>();
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return set;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case PATH: {
                            ModuleXmlParser.parsePathName(reader, set);
                        }
                    }
                }
            }
        }
        return set;
    }

    private static void parseSet(XMLStreamReader reader, boolean include, MultiplePathFilterBuilder builder) throws XMLStreamException {
        builder.addFilter(PathFilters.in(ModuleXmlParser.parseSet(reader)), include);
    }

    private static void parsePathName(XMLStreamReader reader, Set<String> set) throws XMLStreamException {
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block3;
                }
                default: {
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader.getLocation(), required);
        }
        set.add(name);
        ModuleXmlParser.parseNoContent(reader);
    }

    private static void parseProperties(XMLStreamReader reader, ModuleSpec.Builder specBuilder) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case PROPERTY: {
                            ModuleXmlParser.parseProperty(reader, specBuilder);
                            continue block7;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        throw ModuleXmlParser.endOfDocument(reader.getLocation());
    }

    private static void parseProperty(XMLStreamReader reader, ModuleSpec.Builder specBuilder) throws XMLStreamException {
        String name = null;
        String value = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block6;
                }
                case VALUE: {
                    value = reader.getAttributeValue(i);
                    continue block6;
                }
                default: {
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader.getLocation(), required);
        }
        specBuilder.addProperty(name, value == null ? "true" : value);
        if ("jboss.assertions".equals(name)) {
            try {
                specBuilder.setAssertionSetting(AssertionSetting.valueOf(value.toUpperCase(Locale.US)));
            }
            catch (IllegalArgumentException ignored) {
                // empty catch block
            }
        }
        ModuleXmlParser.parseNoContent(reader);
    }

    private static void parseNoContent(XMLStreamReader reader) throws XMLStreamException {
        if (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        throw ModuleXmlParser.endOfDocument(reader.getLocation());
    }

    private static void parseEndDocument(XMLStreamReader reader) throws XMLStreamException {
        block5: while (reader.hasNext()) {
            switch (reader.next()) {
                case 8: {
                    return;
                }
                case 4: {
                    if (reader.isWhiteSpace()) continue block5;
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
                case 5: 
                case 6: {
                    continue block5;
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
    }

    static enum Disposition {
        NONE("none"),
        IMPORT("import"),
        EXPORT("export");

        private static final Map<String, Disposition> values;
        private final String value;

        private Disposition(String value) {
            this.value = value;
        }

        static Disposition of(String value) {
            Disposition disposition = values.get(value);
            return disposition == null ? NONE : disposition;
        }

        static {
            HashMap<String, Disposition> map = new HashMap<String, Disposition>();
            for (Disposition d : Disposition.values()) {
                map.put(d.value, d);
            }
            values = map;
        }
    }

    static enum Attribute {
        NAME,
        SLOT,
        EXPORT,
        SERVICES,
        PATH,
        OPTIONAL,
        DEFAULT_LOADER,
        TARGET_NAME,
        TARGET_SLOT,
        VALUE,
        UNKNOWN;

        private static final Map<QName, Attribute> attributes;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName);
            return attribute == null ? UNKNOWN : attribute;
        }

        static {
            HashMap<QName, Attribute> attributesMap = new HashMap<QName, Attribute>();
            attributesMap.put(new QName("name"), NAME);
            attributesMap.put(new QName("slot"), SLOT);
            attributesMap.put(new QName("export"), EXPORT);
            attributesMap.put(new QName("services"), SERVICES);
            attributesMap.put(new QName("path"), PATH);
            attributesMap.put(new QName("optional"), OPTIONAL);
            attributesMap.put(new QName("default-loader"), DEFAULT_LOADER);
            attributesMap.put(new QName("target-name"), TARGET_NAME);
            attributesMap.put(new QName("target-slot"), TARGET_SLOT);
            attributesMap.put(new QName("value"), VALUE);
            attributes = attributesMap;
        }
    }

    static enum Element {
        MODULE,
        DEPENDENCIES,
        EXPORTS,
        IMPORTS,
        INCLUDE,
        INCLUDE_SET,
        EXCLUDE,
        EXCLUDE_SET,
        RESOURCES,
        MAIN_CLASS,
        RESOURCE_ROOT,
        PATH,
        FILTER,
        CONFIGURATION,
        LOADER,
        MODULE_PATH,
        IMPORT,
        SYSTEM,
        PATHS,
        MODULE_ALIAS,
        PROPERTIES,
        PROPERTY,
        MODULE_ABSENT,
        UNKNOWN;

        private static final Map<String, Element> elements;

        static Element of(QName qName) {
            Namespace namespace = Namespace.of(qName);
            if (namespace == Namespace.UNKNOWN) {
                return UNKNOWN;
            }
            Element element = elements.get(qName.getLocalPart());
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Element> elementsMap = new HashMap<String, Element>();
            elementsMap.put("module", MODULE);
            elementsMap.put("dependencies", DEPENDENCIES);
            elementsMap.put("resources", RESOURCES);
            elementsMap.put("main-class", MAIN_CLASS);
            elementsMap.put("resource-root", RESOURCE_ROOT);
            elementsMap.put("path", PATH);
            elementsMap.put("exports", EXPORTS);
            elementsMap.put("imports", IMPORTS);
            elementsMap.put("include", INCLUDE);
            elementsMap.put("exclude", EXCLUDE);
            elementsMap.put("include-set", INCLUDE_SET);
            elementsMap.put("exclude-set", EXCLUDE_SET);
            elementsMap.put("filter", FILTER);
            elementsMap.put("configuration", CONFIGURATION);
            elementsMap.put("loader", LOADER);
            elementsMap.put("module-path", MODULE_PATH);
            elementsMap.put("import", IMPORT);
            elementsMap.put("system", SYSTEM);
            elementsMap.put("paths", PATHS);
            elementsMap.put("module-alias", MODULE_ALIAS);
            elementsMap.put("properties", PROPERTIES);
            elementsMap.put("property", PROPERTY);
            elements = elementsMap;
        }
    }

    static enum Namespace {
        UNKNOWN,
        MODULE_1_0,
        MODULE_1_1,
        MODULE_1_2;

        private static final Map<String, Namespace> namespaces;

        static Namespace of(QName qName) {
            Namespace namespace = namespaces.get(qName.getNamespaceURI());
            return namespace == null ? UNKNOWN : namespace;
        }

        static {
            HashMap<String, Namespace> namespacesMap = new HashMap<String, Namespace>();
            namespacesMap.put("urn:jboss:module:1.0", MODULE_1_0);
            namespacesMap.put("urn:jboss:module:1.1", MODULE_1_1);
            namespacesMap.put("urn:jboss:module:1.2", MODULE_1_2);
            namespaces = namespacesMap;
        }
    }

    static interface ResourceRootFactory {
        public ResourceLoader createResourceLoader(String var1, String var2, String var3) throws IOException;
    }
}

