/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.File;
import org.jboss.modules.LayeredModulePathFactory;
import org.jboss.modules.ModuleFinder;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.ModuleXmlParser;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;

public final class LocalModuleFinder
implements ModuleFinder {
    private final File[] repoRoots;
    private final PathFilter pathFilter;

    public LocalModuleFinder(File[] repoRoots, PathFilter pathFilter) {
        this.repoRoots = repoRoots;
        this.pathFilter = pathFilter;
    }

    public LocalModuleFinder(File[] repoRoots) {
        this(repoRoots, PathFilters.acceptAll());
    }

    public LocalModuleFinder() {
        this(true);
    }

    public LocalModuleFinder(boolean supportLayersAndAddOns) {
        String modulePath = System.getProperty("module.path", System.getenv("JAVA_MODULEPATH"));
        File[] basicRoots = modulePath == null ? new File[]{} : LocalModuleFinder.getFiles(modulePath, 0, 0);
        this.repoRoots = supportLayersAndAddOns ? LayeredModulePathFactory.resolveLayeredModulePath(basicRoots) : basicRoots;
        this.pathFilter = PathFilters.acceptAll();
    }

    static File[] getFiles(String modulePath, int stringIdx, int arrayIdx) {
        File[] files;
        int i = modulePath.indexOf(File.pathSeparatorChar, stringIdx);
        if (i == -1) {
            files = new File[arrayIdx + 1];
            files[arrayIdx] = new File(modulePath.substring(stringIdx)).getAbsoluteFile();
        } else {
            files = LocalModuleFinder.getFiles(modulePath, i + 1, arrayIdx + 1);
            files[arrayIdx] = new File(modulePath.substring(stringIdx, i)).getAbsoluteFile();
        }
        return files;
    }

    static String toPathString(ModuleIdentifier moduleIdentifier) {
        StringBuilder builder = new StringBuilder(40);
        builder.append(moduleIdentifier.getName().replace('.', File.separatorChar));
        builder.append(File.separatorChar).append(moduleIdentifier.getSlot());
        builder.append(File.separatorChar);
        return builder.toString();
    }

    @Override
    public ModuleSpec findModule(ModuleIdentifier identifier, ModuleLoader delegateLoader) throws ModuleLoadException {
        String child = LocalModuleFinder.toPathString(identifier);
        if (this.pathFilter.accept(child)) {
            for (File root : this.repoRoots) {
                File file = new File(root, child);
                File moduleXml = new File(file, "module.xml");
                if (!moduleXml.exists()) continue;
                ModuleSpec spec = ModuleXmlParser.parseModuleXml(identifier, file, moduleXml);
                if (spec == null) break;
                return spec;
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("local module finder @").append(Integer.toHexString(this.hashCode())).append(" (roots: ");
        int repoRootsLength = this.repoRoots.length;
        for (int i = 0; i < repoRootsLength; ++i) {
            File root = this.repoRoots[i];
            b.append(root);
            if (i == repoRootsLength - 1) continue;
            b.append(',');
        }
        b.append(')');
        return b.toString();
    }
}

