/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.telephony.ua;

import akka.actor.ActorContext;
import akka.actor.ActorSystem;
import akka.actor.ReceiveTimeout;
import akka.actor.UntypedActor;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContext;
import javax.servlet.sip.Address;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import org.apache.commons.configuration.Configuration;
import org.joda.time.DateTime;
import org.mobicents.servlet.restcomm.dao.ClientsDao;
import org.mobicents.servlet.restcomm.dao.DaoManager;
import org.mobicents.servlet.restcomm.dao.RegistrationsDao;
import org.mobicents.servlet.restcomm.entities.Client;
import org.mobicents.servlet.restcomm.entities.Registration;
import org.mobicents.servlet.restcomm.entities.Sid;
import org.mobicents.servlet.restcomm.util.DigestAuthentication;
import org.mobicents.servlet.restcomm.util.HexadecimalUtils;
import scala.concurrent.duration.Duration;

public final class UserAgentManager
extends UntypedActor {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private boolean authenticateUsers = true;
    private final SipFactory factory;
    private final DaoManager storage;
    private final ServletContext servletContext;

    public UserAgentManager(Configuration configuration, SipFactory factory, DaoManager storage, ServletContext servletContext) {
        this.servletContext = servletContext;
        Configuration runtime = configuration.subset("runtime-settings");
        this.authenticateUsers = runtime.getBoolean("authenticate");
        this.factory = factory;
        this.storage = storage;
        ActorContext context = this.context();
        context.setReceiveTimeout((Duration)Duration.create((long)60L, (TimeUnit)TimeUnit.SECONDS));
    }

    private void clean() {
        RegistrationsDao registrations = this.storage.getRegistrationsDao();
        List results = registrations.getRegistrations();
        for (Registration result : results) {
            DateTime expires = result.getDateExpires();
            if (!expires.isBeforeNow() && !expires.isEqualNow()) continue;
            registrations.removeRegistration(result);
        }
    }

    private String header(String nonce, String realm, String scheme) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(scheme).append(" ");
        buffer.append("realm=\"").append(realm).append("\", ");
        buffer.append("nonce=\"").append(nonce).append("\"");
        return buffer.toString();
    }

    private void authenticate(Object message) throws IOException {
        SipServletRequest request = (SipServletRequest)message;
        SipServletResponse response = request.createResponse(407);
        String nonce = this.nonce();
        SipURI uri = (SipURI)request.getTo().getURI();
        String realm = uri.getHost();
        String header = this.header(nonce, realm, "Digest");
        response.addHeader("Proxy-Authenticate", header);
        response.send();
    }

    private void keepAlive() throws Exception {
        RegistrationsDao registrations = this.storage.getRegistrationsDao();
        List results = registrations.getRegistrations();
        for (Registration result : results) {
            String to = result.getLocation();
            this.ping(to);
        }
    }

    private String nonce() {
        byte[] uuid = UUID.randomUUID().toString().getBytes();
        char[] hex = HexadecimalUtils.toHex((byte[])uuid);
        return new String(hex).substring(0, 31);
    }

    public void onReceive(Object message) throws Exception {
        if (message instanceof ReceiveTimeout) {
            this.clean();
            this.keepAlive();
        } else if (message instanceof SipServletRequest) {
            SipServletRequest request = (SipServletRequest)message;
            String method = request.getMethod();
            if ("REGISTER".equalsIgnoreCase(method)) {
                if (this.authenticateUsers) {
                    String authorization = request.getHeader("Proxy-Authorization");
                    if (authorization != null && this.permitted(authorization, method)) {
                        this.register(message);
                    } else {
                        this.authenticate(message);
                    }
                } else {
                    this.register(message);
                }
            }
        } else if (message instanceof SipServletResponse) {
            this.pong(message);
        }
    }

    private void patch(SipURI uri, String address, int port) throws UnknownHostException {
        InetAddress host = InetAddress.getByName(uri.getHost());
        String ip = host.getHostAddress();
        uri.setHost(address);
        uri.setPort(port);
    }

    private boolean permitted(String authorization, String method) {
        Map<String, String> map = this.toMap(authorization);
        String user = map.get("username");
        String algorithm = map.get("algorithm");
        String realm = map.get("realm");
        String uri = map.get("uri");
        String nonce = map.get("nonce");
        String nc = map.get("nc");
        String cnonce = map.get("cnonce");
        String qop = map.get("qop");
        String response = map.get("response");
        ClientsDao clients = this.storage.getClientsDao();
        Client client = clients.getClient(user);
        if (client != null && 1 == client.getStatus()) {
            String password = client.getPassword();
            String result = DigestAuthentication.response((String)algorithm, (String)user, (String)realm, (String)password, (String)nonce, (String)nc, (String)cnonce, (String)method, (String)uri, null, (String)qop);
            return result.equals(response);
        }
        return false;
    }

    private void ping(String to) throws Exception {
        SipApplicationSession application = this.factory.createApplicationSession();
        String toTransport = ((SipURI)this.factory.createURI(to)).getTransportParam();
        if (toTransport == null) {
            toTransport = "udp";
        }
        if (toTransport.equalsIgnoreCase("ws") || toTransport.equalsIgnoreCase("wss")) {
            return;
        }
        SipURI outboundInterface = this.outboundInterface(toTransport);
        StringBuilder buffer = new StringBuilder();
        buffer.append("sip:restcomm").append("@").append(outboundInterface.getHost());
        String from = buffer.toString();
        SipServletRequest ping = this.factory.createRequest(application, "OPTIONS", from, to);
        SipURI uri = (SipURI)this.factory.createURI(to);
        ping.pushRoute(uri);
        ping.setRequestURI((URI)uri);
        SipSession session = ping.getSession();
        session.setHandler("UserAgentManager");
        ping.send();
    }

    private void pong(Object message) {
        SipServletResponse response = (SipServletResponse)message;
        if (response.getApplicationSession().isValid()) {
            response.getApplicationSession().invalidate();
        }
    }

    private SipURI outboundInterface(String toTransport) {
        SipURI result = null;
        List uris = (List)this.servletContext.getAttribute("javax.servlet.sip.outboundInterfaces");
        for (SipURI uri : uris) {
            String transport = uri.getTransportParam();
            if (toTransport == null || !toTransport.equalsIgnoreCase(transport)) continue;
            result = uri;
        }
        return result;
    }

    private void register(Object message) throws Exception {
        SipServletRequest request = (SipServletRequest)message;
        Address contact = request.getAddressHeader("Contact");
        int ttl = contact.getExpires();
        if (ttl == -1) {
            String expires = request.getHeader("Expires");
            ttl = expires != null ? Integer.parseInt(expires) : 3600;
        }
        if (ttl > 3600) {
            ttl = 3600;
        }
        String name = contact.getDisplayName();
        String ua = request.getHeader("User-Agent");
        SipURI to = (SipURI)request.getTo().getURI();
        String aor = to.toString();
        String user = to.getUser();
        SipURI uri = (SipURI)contact.getURI();
        String ip = request.getInitialRemoteAddr();
        int port = request.getInitialRemotePort();
        String transport = uri.getTransportParam();
        String initialIpBeforeLB = request.getHeader("X-Sip-Balancer-InitialRemoteAddr");
        String initialPortBeforeLB = request.getHeader("X-Sip-Balancer-InitialRemotePort");
        if (initialIpBeforeLB != null && !initialIpBeforeLB.isEmpty() && initialPortBeforeLB != null && !initialPortBeforeLB.isEmpty()) {
            this.logger.info("Client in front of LB. Patching URI: " + uri.toString() + " with IP: " + initialIpBeforeLB + " and PORT: " + initialPortBeforeLB + " for USER: " + user);
            this.patch(uri, initialIpBeforeLB, Integer.valueOf(initialPortBeforeLB));
        } else {
            this.logger.info("Patching URI: " + uri.toString() + " with IP: " + ip + " and PORT: " + port + " for USER: " + user);
            this.patch(uri, ip, port);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("sip:").append(user).append("@").append(uri.getHost()).append(":").append(uri.getPort());
        if (transport != null) {
            buffer.append(";transport=").append(transport);
        }
        String address = buffer.toString();
        SipServletResponse response = request.createResponse(200);
        Sid sid = Sid.generate((Sid.Type)Sid.Type.REGISTRATION);
        DateTime now = DateTime.now();
        if (name == null) {
            name = user;
        }
        if (ua == null) {
            ua = "GenericUA";
        }
        Registration registration = new Registration(sid, now, now, aor, name, user, ua, ttl, address);
        RegistrationsDao registrations = this.storage.getRegistrationsDao();
        if (ttl == 0) {
            registrations.removeRegistration(registration);
            response.setHeader("Expires", "0");
            this.logger.info("The user agent manager unregistered " + user + " at address " + address);
        } else {
            if (registrations.hasRegistration(registration)) {
                registrations.updateRegistration(registration);
                this.logger.info("The user agent manager updated " + user + " at address " + address);
            } else {
                registrations.addRegistration(registration);
                this.logger.info("The user agent manager registered " + user + " at address " + address);
            }
            response.setHeader("Contact", this.contact(uri, ttl));
        }
        response.send();
        if (request.getApplicationSession().isValid()) {
            try {
                request.getApplicationSession().invalidate();
            }
            catch (IllegalStateException exception) {
                // empty catch block
            }
        }
    }

    private String contact(SipURI uri, int expires) {
        Address contact = this.factory.createAddress((URI)uri);
        contact.setExpires(expires);
        return contact.toString();
    }

    private Map<String, String> toMap(String header) {
        String[] tokens;
        HashMap<String, String> map = new HashMap<String, String>();
        int endOfScheme = header.indexOf(" ");
        map.put("scheme", header.substring(0, endOfScheme).trim());
        for (String token : tokens = header.substring(endOfScheme + 1).split(",")) {
            String[] values = token.trim().split("=");
            map.put(values[0].toLowerCase(), values[1].replace("\"", ""));
        }
        return map;
    }
}

