/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.telephony.proxy;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorFactory;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServlet;
import javax.servlet.sip.SipServletContextEvent;
import javax.servlet.sip.SipServletListener;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.mobicents.servlet.restcomm.dao.DaoManager;
import org.mobicents.servlet.restcomm.telephony.proxy.ProxyManager;

public final class ProxyManagerProxy
extends SipServlet
implements SipServletListener {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(ProxyManagerProxy.class);
    private ActorSystem system;
    private ActorRef manager;
    private ServletContext context;

    public void destroy() {
        if (this.system != null) {
            this.system.stop(this.manager);
        }
    }

    protected void doRequest(SipServletRequest request) throws ServletException, IOException {
        this.manager.tell((Object)request, null);
    }

    protected void doResponse(SipServletResponse response) throws ServletException, IOException {
        this.manager.tell((Object)response, null);
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    private ActorRef manager(final ServletContext servletContext, final SipFactory factory, final DaoManager storage, final String address) {
        return this.system.actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new ProxyManager(servletContext, factory, storage, address);
            }
        }));
    }

    public void servletInitialized(SipServletContextEvent event) {
        if (event.getSipServlet().getClass().equals(ProxyManagerProxy.class)) {
            logger.info((Object)"ProxyManagerProxy sip servlet initialized. Will proceed to create ProxyManager");
            this.context = event.getServletContext();
            SipFactory factory = (SipFactory)this.context.getAttribute("javax.servlet.sip.SipFactory");
            Configuration configuration = (Configuration)this.context.getAttribute(Configuration.class.getName());
            configuration = configuration.subset("runtime-settings");
            String address = configuration.getString("external-ip");
            DaoManager storage = (DaoManager)this.context.getAttribute(DaoManager.class.getName());
            this.system = (ActorSystem)this.context.getAttribute(ActorSystem.class.getName());
            this.manager = this.manager(this.context, factory, storage, address);
            this.context.setAttribute(ProxyManager.class.getName(), (Object)this.manager);
        }
    }
}

