/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.telephony;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.UntypedActor;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import jain.protocol.ip.mgcp.message.parms.ConnectionMode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.mobicents.servlet.restcomm.annotations.concurrency.Immutable;
import org.mobicents.servlet.restcomm.fsm.Action;
import org.mobicents.servlet.restcomm.fsm.FiniteStateMachine;
import org.mobicents.servlet.restcomm.fsm.State;
import org.mobicents.servlet.restcomm.fsm.Transition;
import org.mobicents.servlet.restcomm.mscontrol.messages.CreateMediaSession;
import org.mobicents.servlet.restcomm.mscontrol.messages.JoinCall;
import org.mobicents.servlet.restcomm.mscontrol.messages.JoinComplete;
import org.mobicents.servlet.restcomm.mscontrol.messages.Leave;
import org.mobicents.servlet.restcomm.mscontrol.messages.MediaServerControllerStateChanged;
import org.mobicents.servlet.restcomm.mscontrol.messages.Play;
import org.mobicents.servlet.restcomm.mscontrol.messages.StartRecording;
import org.mobicents.servlet.restcomm.mscontrol.messages.Stop;
import org.mobicents.servlet.restcomm.mscontrol.messages.StopMediaGroup;
import org.mobicents.servlet.restcomm.mscontrol.messages.StopRecording;
import org.mobicents.servlet.restcomm.patterns.Observe;
import org.mobicents.servlet.restcomm.patterns.Observing;
import org.mobicents.servlet.restcomm.patterns.StopObserving;
import org.mobicents.servlet.restcomm.telephony.AddParticipant;
import org.mobicents.servlet.restcomm.telephony.ConferenceInfo;
import org.mobicents.servlet.restcomm.telephony.ConferenceModeratorPresent;
import org.mobicents.servlet.restcomm.telephony.ConferenceResponse;
import org.mobicents.servlet.restcomm.telephony.ConferenceStateChanged;
import org.mobicents.servlet.restcomm.telephony.GetConferenceInfo;
import org.mobicents.servlet.restcomm.telephony.RemoveParticipant;
import org.mobicents.servlet.restcomm.telephony.StartConference;
import org.mobicents.servlet.restcomm.telephony.StopConference;

@Immutable
public final class Conference
extends UntypedActor {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private final FiniteStateMachine fsm;
    private final State uninitialized;
    private final State initializing;
    private final State waiting;
    private final State running;
    private final State stopping;
    private final State stopped;
    private final State failed;
    private final String name;
    private final List<ActorRef> calls;
    private final List<ActorRef> observers;
    private final ActorRef mscontroller;

    public Conference(String name, ActorRef msController) {
        ActorRef source = this.self();
        this.uninitialized = new State("uninitialized", null, null);
        this.initializing = new State("initialiing", (Action)new Initializing(source), null);
        this.waiting = new State("waiting", (Action)new Waiting(source), null);
        this.running = new State("running", (Action)new Running(source), null);
        this.stopping = new State("stopping", (Action)new Stopping(source), null);
        this.stopped = new State("stopped", (Action)new Stopped(source), null);
        this.failed = new State("failed", (Action)new Failed(source), null);
        HashSet<Transition> transitions = new HashSet<Transition>();
        transitions.add(new Transition(this.uninitialized, this.initializing));
        transitions.add(new Transition(this.initializing, this.waiting));
        transitions.add(new Transition(this.initializing, this.stopping));
        transitions.add(new Transition(this.initializing, this.failed));
        transitions.add(new Transition(this.waiting, this.running));
        transitions.add(new Transition(this.waiting, this.stopping));
        transitions.add(new Transition(this.running, this.stopping));
        transitions.add(new Transition(this.stopping, this.stopped));
        transitions.add(new Transition(this.stopping, this.failed));
        this.fsm = new FiniteStateMachine(this.uninitialized, transitions);
        this.name = name;
        this.mscontroller = msController;
        this.calls = new ArrayList<ActorRef>();
        this.observers = new ArrayList<ActorRef>();
    }

    private boolean is(State state) {
        return this.fsm.state().equals((Object)state);
    }

    private boolean isRunning() {
        return this.is(this.waiting) || this.is(this.running);
    }

    private void broadcast(Object message) {
        if (!this.observers.isEmpty()) {
            ActorRef self = this.self();
            for (ActorRef observer : this.observers) {
                observer.tell(message, self);
            }
        }
    }

    public void onReceive(Object message) throws Exception {
        Class<?> klass = message.getClass();
        ActorRef sender = this.sender();
        ActorRef self = this.self();
        State state = this.fsm.state();
        if (this.logger.isInfoEnabled()) {
            this.logger.info(" ********** Conference " + this.self().path() + " Current State: " + state.toString());
            this.logger.info(" ********** Conference " + this.self().path() + " Processing Message: " + klass.getName());
        }
        if (Observe.class.equals(klass)) {
            this.onObserve((Observe)message, self, sender);
        } else if (StopObserving.class.equals(klass)) {
            this.onStopObserving((StopObserving)message, self, sender);
        } else if (GetConferenceInfo.class.equals(klass)) {
            this.onGetConferenceInfo((GetConferenceInfo)message, self, sender);
        } else if (StartConference.class.equals(klass)) {
            this.onStartConference((StartConference)message, self, sender);
        } else if (StopConference.class.equals(klass)) {
            this.onStopConference((StopConference)message, self, sender);
        } else if (ConferenceModeratorPresent.class.equals(klass)) {
            this.onConferenceModeratorPresent((ConferenceModeratorPresent)message, self, sender);
        } else if (AddParticipant.class.equals(klass)) {
            this.onAddParticipant((AddParticipant)message, self, sender);
        } else if (RemoveParticipant.class.equals(klass)) {
            this.onRemoveParticipant((RemoveParticipant)message, self, sender);
        } else if (JoinComplete.class.equals(klass)) {
            this.onJoinComplete((JoinComplete)message, self, sender);
        } else if (MediaServerControllerStateChanged.class.equals(klass)) {
            this.onMediaServerControllerStateChanged((MediaServerControllerStateChanged)message, self, sender);
        } else if (Play.class.equals(klass)) {
            this.onPlay((Play)message, self, sender);
        } else if (StartRecording.class.equals(klass)) {
            this.onStartRecording((StartRecording)message, self, sender);
        } else if (StopRecording.class.equals(klass)) {
            this.onStopRecording((StopRecording)message, self, sender);
        }
    }

    private void onObserve(Observe message, ActorRef self, ActorRef sender) {
        ActorRef observer = message.observer();
        if (observer != null) {
            this.observers.add(observer);
            observer.tell((Object)new Observing(self), self);
        }
    }

    private void onStopObserving(StopObserving message, ActorRef self, ActorRef sender) {
        ActorRef observer = message.observer();
        if (observer != null) {
            this.observers.remove(observer);
        }
    }

    private void onGetConferenceInfo(GetConferenceInfo message, ActorRef self, ActorRef sender) throws Exception {
        ConferenceInfo information = null;
        if (this.is(this.waiting)) {
            information = new ConferenceInfo(this.calls, ConferenceStateChanged.State.RUNNING_MODERATOR_ABSENT, this.name);
        } else if (this.is(this.running)) {
            information = new ConferenceInfo(this.calls, ConferenceStateChanged.State.RUNNING_MODERATOR_PRESENT, this.name);
        } else if (this.is(this.stopped)) {
            information = new ConferenceInfo(this.calls, ConferenceStateChanged.State.COMPLETED, this.name);
        }
        sender.tell((Object)new ConferenceResponse((Object)information), self);
    }

    private void onStartConference(StartConference message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.uninitialized)) {
            this.fsm.transition((Object)message, this.initializing);
        }
    }

    private void onStopConference(StopConference message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.initializing)) {
            this.fsm.transition((Object)message, this.stopped);
        } else if (this.is(this.waiting) || this.is(this.running)) {
            this.fsm.transition((Object)message, this.stopping);
        }
    }

    private void onConferenceModeratorPresent(ConferenceModeratorPresent message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.waiting)) {
            this.fsm.transition((Object)message, this.running);
        }
    }

    private void onAddParticipant(AddParticipant message, ActorRef self, ActorRef sender) {
        if (this.isRunning()) {
            JoinCall joinCall = new JoinCall(message.call(), ConnectionMode.Confrnce);
            this.mscontroller.tell((Object)joinCall, self);
        }
    }

    private void onRemoveParticipant(RemoveParticipant message, ActorRef self, ActorRef sender) throws Exception {
        if (this.isRunning()) {
            ActorRef call = message.call();
            if (this.calls.remove(call)) {
                Leave leave = new Leave();
                call.tell((Object)leave, self);
            }
            if (this.calls.size() == 0) {
                this.fsm.transition((Object)message, this.stopping);
            }
        }
    }

    private void onMediaServerControllerStateChanged(MediaServerControllerStateChanged message, ActorRef self, ActorRef sender) throws Exception {
        MediaServerControllerStateChanged.MediaServerControllerState state = message.getState();
        switch (state) {
            case ACTIVE: {
                if (!this.is(this.initializing)) break;
                this.fsm.transition((Object)message, this.waiting);
                break;
            }
            case INACTIVE: {
                if (!this.is(this.stopping)) break;
                this.fsm.transition((Object)message, this.stopped);
                break;
            }
            case FAILED: {
                if (!this.is(this.initializing)) break;
                this.fsm.transition((Object)message, this.failed);
                break;
            }
        }
    }

    private void onJoinComplete(JoinComplete message, ActorRef self, ActorRef sender) {
        this.calls.add(sender);
    }

    private void onPlay(Play message, ActorRef self, ActorRef sender) {
        if (this.isRunning()) {
            this.mscontroller.tell((Object)message, sender);
        }
    }

    private void onStartRecording(StartRecording message, ActorRef self, ActorRef sender) {
        if (this.isRunning()) {
            this.mscontroller.tell((Object)message, sender);
        }
    }

    private void onStopRecording(StopRecording message, ActorRef self, ActorRef sender) {
        if (this.isRunning()) {
            this.mscontroller.tell((Object)message, sender);
        }
    }

    private final class Failed
    extends FinalizingAction {
        public Failed(ActorRef source) {
            super(source, ConferenceStateChanged.State.FAILED);
        }
    }

    private final class Stopped
    extends FinalizingAction {
        public Stopped(ActorRef source) {
            super(source, ConferenceStateChanged.State.COMPLETED);
        }
    }

    private abstract class FinalizingAction
    extends AbstractAction {
        protected final ConferenceStateChanged.State finalState;

        public FinalizingAction(ActorRef source, ConferenceStateChanged.State state) {
            super(source);
            this.finalState = state;
        }

        public void execute(Object message) throws Exception {
            Conference.this.broadcast(new ConferenceStateChanged(Conference.this.name, this.finalState));
            Conference.this.observers.clear();
        }
    }

    private class Stopping
    extends AbstractAction {
        public Stopping(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            if (!Conference.this.calls.isEmpty()) {
                for (ActorRef call : Conference.this.calls) {
                    Leave leave = new Leave();
                    call.tell((Object)leave, this.source);
                }
                Conference.this.calls.clear();
            }
            Conference.this.mscontroller.tell((Object)new Stop(), this.source);
        }
    }

    private final class Running
    extends AbstractAction {
        public Running(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Conference.this.mscontroller.tell((Object)new StopMediaGroup(), this.source);
            Conference.this.broadcast(new ConferenceStateChanged(Conference.this.name, ConferenceStateChanged.State.RUNNING_MODERATOR_PRESENT));
        }
    }

    private final class Waiting
    extends AbstractAction {
        public Waiting(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Conference.this.broadcast(new ConferenceStateChanged(Conference.this.name, ConferenceStateChanged.State.RUNNING_MODERATOR_ABSENT));
        }
    }

    private class Initializing
    extends AbstractAction {
        public Initializing(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Observe observe = new Observe(this.source);
            Conference.this.mscontroller.tell((Object)observe, this.source);
            CreateMediaSession createMediaSession = new CreateMediaSession();
            Conference.this.mscontroller.tell((Object)createMediaSession, this.source);
        }
    }

    private abstract class AbstractAction
    implements Action {
        protected final ActorRef source;

        public AbstractAction(ActorRef source) {
            this.source = source;
        }
    }
}

