/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.telephony;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.ReceiveTimeout;
import akka.actor.ReceiveTimeout$;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorContext;
import akka.actor.UntypedActorFactory;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import akka.pattern.Patterns;
import akka.util.Timeout;
import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.sip.AuthInfo;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipApplicationSessionEvent;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import org.apache.commons.configuration.Configuration;
import org.joda.time.DateTime;
import org.mobicents.servlet.restcomm.dao.AccountsDao;
import org.mobicents.servlet.restcomm.dao.ApplicationsDao;
import org.mobicents.servlet.restcomm.dao.ClientsDao;
import org.mobicents.servlet.restcomm.dao.DaoManager;
import org.mobicents.servlet.restcomm.dao.IncomingPhoneNumbersDao;
import org.mobicents.servlet.restcomm.dao.NotificationsDao;
import org.mobicents.servlet.restcomm.dao.RegistrationsDao;
import org.mobicents.servlet.restcomm.entities.Account;
import org.mobicents.servlet.restcomm.entities.Application;
import org.mobicents.servlet.restcomm.entities.Client;
import org.mobicents.servlet.restcomm.entities.IncomingPhoneNumber;
import org.mobicents.servlet.restcomm.entities.Notification;
import org.mobicents.servlet.restcomm.entities.Registration;
import org.mobicents.servlet.restcomm.entities.Sid;
import org.mobicents.servlet.restcomm.interpreter.StartInterpreter;
import org.mobicents.servlet.restcomm.interpreter.StopInterpreter;
import org.mobicents.servlet.restcomm.interpreter.VoiceInterpreterBuilder;
import org.mobicents.servlet.restcomm.mscontrol.MediaServerControllerFactory;
import org.mobicents.servlet.restcomm.patterns.StopObserving;
import org.mobicents.servlet.restcomm.telephony.Call;
import org.mobicents.servlet.restcomm.telephony.CallManagerResponse;
import org.mobicents.servlet.restcomm.telephony.CallResponse;
import org.mobicents.servlet.restcomm.telephony.CallStateChanged;
import org.mobicents.servlet.restcomm.telephony.CreateCall;
import org.mobicents.servlet.restcomm.telephony.DestroyCall;
import org.mobicents.servlet.restcomm.telephony.ExecuteCallScript;
import org.mobicents.servlet.restcomm.telephony.GetActiveProxy;
import org.mobicents.servlet.restcomm.telephony.GetCall;
import org.mobicents.servlet.restcomm.telephony.GetCallObservers;
import org.mobicents.servlet.restcomm.telephony.GetOutboundCall;
import org.mobicents.servlet.restcomm.telephony.GetProxies;
import org.mobicents.servlet.restcomm.telephony.Hangup;
import org.mobicents.servlet.restcomm.telephony.InitializeOutbound;
import org.mobicents.servlet.restcomm.telephony.SwitchProxy;
import org.mobicents.servlet.restcomm.telephony.UpdateCallScript;
import org.mobicents.servlet.restcomm.telephony.util.B2BUAHelper;
import org.mobicents.servlet.restcomm.telephony.util.CallControlHelper;
import org.mobicents.servlet.restcomm.util.UriUtils;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;

public final class CallManager
extends UntypedActor {
    static final int ERROR_NOTIFICATION = 0;
    static final int WARNING_NOTIFICATION = 1;
    static final Pattern PATTERN = Pattern.compile("[\\*#0-9]{1,12}");
    static final String EMAIL_SENDER = "restcomm@restcomm.org";
    static final String EMAIL_SUBJECT = "RestComm Error Notification - Attention Required";
    private final ActorSystem system;
    private final Configuration configuration;
    private final ServletContext context;
    private final MediaServerControllerFactory msControllerFactory;
    private final ActorRef conferences;
    private final ActorRef bridges;
    private final ActorRef sms;
    private final SipFactory sipFactory;
    private final DaoManager storage;
    private boolean useTo;
    private boolean authenticateUsers;
    private AtomicInteger numberOfFailedCalls;
    private AtomicBoolean useFallbackProxy;
    private boolean allowFallback;
    private boolean allowFallbackToPrimary;
    private int maxNumberOfFailedCalls;
    private String primaryProxyUri;
    private String primaryProxyUsername;
    private String primaryProxyPassword;
    private String fallBackProxyUri;
    private String fallBackProxyUsername;
    private String fallBackProxyPassword;
    private String activeProxy;
    private String activeProxyUsername;
    private String activeProxyPassword;
    private String mediaExternalIp;
    private String myHostIp;
    private String proxyIp;
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private CreateCall createCallRequest;
    private SwitchProxy switchProxyRequest;

    private void sendNotification(String errMessage, int errCode, String errType, boolean createNotification) {
        NotificationsDao notifications = this.storage.getNotificationsDao();
        if (errType == "warning") {
            this.logger.warning(errMessage);
            if (createNotification) {
                Notification notification = this.notification(0, errCode, errMessage);
                notifications.addNotification(notification);
            }
        } else if (errType == "error") {
            this.logger.error(errMessage);
            if (createNotification) {
                Notification notification = this.notification(0, errCode, errMessage);
                notifications.addNotification(notification);
            }
        } else if (errType == "info") {
            this.logger.info(errMessage);
        }
    }

    public CallManager(Configuration configuration, ServletContext context, ActorSystem system, MediaServerControllerFactory msControllerFactory, ActorRef conferences, ActorRef bridges, ActorRef sms, SipFactory factory, DaoManager storage) {
        this.system = system;
        this.configuration = configuration;
        this.context = context;
        this.msControllerFactory = msControllerFactory;
        this.conferences = conferences;
        this.bridges = bridges;
        this.sms = sms;
        this.sipFactory = factory;
        this.storage = storage;
        Configuration runtime = configuration.subset("runtime-settings");
        Configuration outboundProxyConfig = runtime.subset("outbound-proxy");
        SipURI outboundIntf = this.outboundInterface("udp");
        if (outboundIntf != null) {
            this.myHostIp = outboundIntf.getHost().toString();
        } else {
            String errMsg = "SipURI outboundIntf is null";
            this.sendNotification(errMsg, 14001, "error", false);
            if (context == null) {
                errMsg = "SipServlet context is null";
            }
            this.sendNotification(errMsg, 14002, "error", false);
        }
        Configuration mediaConf = configuration.subset("media-server-manager");
        this.mediaExternalIp = mediaConf.getString("mgcp-server.external-address");
        this.proxyIp = runtime.subset("telestax-proxy").getString("uri").replaceAll("http://", "").replaceAll(":2080", "");
        if (this.mediaExternalIp == null || this.mediaExternalIp.isEmpty()) {
            this.mediaExternalIp = this.myHostIp;
        }
        if (this.proxyIp == null || this.proxyIp.isEmpty()) {
            this.proxyIp = this.myHostIp;
        }
        this.useTo = runtime.getBoolean("use-to");
        this.authenticateUsers = runtime.getBoolean("authenticate");
        this.primaryProxyUri = outboundProxyConfig.getString("outbound-proxy-uri");
        this.primaryProxyUsername = outboundProxyConfig.getString("outbound-proxy-user");
        this.primaryProxyPassword = outboundProxyConfig.getString("outbound-proxy-password");
        this.fallBackProxyUri = outboundProxyConfig.getString("fallback-outbound-proxy-uri");
        this.fallBackProxyUsername = outboundProxyConfig.getString("fallback-outbound-proxy-user");
        this.fallBackProxyPassword = outboundProxyConfig.getString("fallback-outbound-proxy-password");
        this.activeProxy = this.primaryProxyUri;
        this.activeProxyUsername = this.primaryProxyUsername;
        this.activeProxyPassword = this.primaryProxyPassword;
        this.numberOfFailedCalls = new AtomicInteger();
        this.numberOfFailedCalls.set(0);
        this.useFallbackProxy = new AtomicBoolean();
        this.useFallbackProxy.set(false);
        Boolean bool = outboundProxyConfig.getBoolean("allow-fallback");
        this.allowFallback = bool != null ? bool : false;
        Integer value = outboundProxyConfig.getInt("max-failed-calls");
        this.maxNumberOfFailedCalls = value != null ? value : 20;
        bool = outboundProxyConfig.getBoolean("allow-fallback-to-primary");
        this.allowFallbackToPrimary = bool != null ? bool : false;
    }

    private ActorRef call() {
        return this.system.actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new Call(CallManager.this.sipFactory, CallManager.this.msControllerFactory.provideCallController());
            }
        }));
    }

    private void check(Object message) throws IOException {
        SipServletRequest request = (SipServletRequest)message;
        String content = new String(request.getRawContent());
        if (request.getContentLength() == 0 || !"application/sdp".equals(request.getContentType()) && !content.contains("application/sdp")) {
            SipServletResponse response = request.createResponse(400);
            response.send();
        }
    }

    private void destroy(Object message) throws Exception {
        UntypedActorContext context = this.getContext();
        DestroyCall request = (DestroyCall)message;
        ActorRef call = request.call();
        if (call != null) {
            context.stop(request.call());
        }
    }

    private void invite(Object message) throws IOException, NumberParseException, ServletParseException {
        String errMsg;
        ActorRef self = this.self();
        SipServletRequest request = (SipServletRequest)message;
        if (!request.isInitial()) {
            SipServletResponse okay = request.createResponse(200);
            okay.send();
            return;
        }
        AccountsDao accounts = this.storage.getAccountsDao();
        ApplicationsDao applications = this.storage.getApplicationsDao();
        SipURI fromUri = (SipURI)request.getFrom().getURI();
        String fromUser = fromUri.getUser();
        ClientsDao clients = this.storage.getClientsDao();
        Client client = clients.getClient(fromUser);
        if (client != null) {
            if (!this.authenticateUsers || CallControlHelper.checkAuthentication((SipServletRequest)request, (DaoManager)this.storage)) {
                if (this.redirectToClientVoiceApp(self, request, accounts, applications, client)) {
                    return;
                }
            } else {
                return;
            }
        }
        String toUser = CallControlHelper.getUserSipId((SipServletRequest)request, (boolean)this.useTo);
        String ruri = ((SipURI)request.getRequestURI()).getHost();
        String toHost = ((SipURI)request.getTo().getURI()).getHost();
        String toPort = String.valueOf(((SipURI)request.getTo().getURI()).getPort()).equalsIgnoreCase("-1") ? "5060" : String.valueOf(((SipURI)request.getTo().getURI()).getHost());
        String transport = ((SipURI)request.getTo().getURI()).getTransportParam() == null ? "udp" : ((SipURI)request.getTo().getURI()).getTransportParam();
        SipURI outboundIntf = this.outboundInterface(transport);
        this.logger.info("ToHost: " + toHost);
        this.logger.info("ruri: " + ruri);
        this.logger.info("myHostIp: " + this.myHostIp);
        this.logger.info("mediaExternalIp: " + this.mediaExternalIp);
        this.logger.info("proxyIp: " + this.proxyIp);
        if (client != null) {
            this.logger.info("Client is not null: " + client.getLogin() + " will try to proxy to client: " + request.getRequestURI().toString());
            Client toClient = clients.getClient(toUser);
            if (toClient != null) {
                if (B2BUAHelper.redirectToB2BUA((SipServletRequest)request, (Client)client, (Client)toClient, (DaoManager)this.storage, (SipFactory)this.sipFactory)) {
                    this.logger.info("Call to CLIENT.  myHostIp: " + this.myHostIp + " mediaExternalIp: " + this.mediaExternalIp + " toHost: " + toHost + " fromClient: " + client.getUri() + " toClient: " + toClient.getUri());
                    return;
                }
                errMsg = "Cannot Connect to Client: " + toClient.getFriendlyName() + " : Make sure the Client exist or is registered with Restcomm";
                this.sendNotification(errMsg, 11001, "warning", true);
            } else {
                if (this.redirectToHostedVoiceApp(self, request, accounts, applications, toUser)) {
                    return;
                }
                errMsg = "A Restcomm Client is trying to call a Number/DID that is not registered with Restcomm";
                this.sendNotification(errMsg, 11002, "warning", true);
                String proxyURI = this.activeProxy;
                String proxyUsername = this.activeProxyUsername;
                String proxyPassword = this.activeProxyPassword;
                SipURI from = null;
                SipURI to = null;
                boolean callToSipUri = false;
                if (proxyURI != null && !proxyURI.isEmpty()) {
                    Configuration runtime = this.configuration.subset("runtime-settings");
                    boolean useLocalAddressAtFromHeader = runtime.getBoolean("use-local-address", false);
                    boolean outboudproxyUserAtFromHeader = runtime.subset("outbound-proxy").getBoolean("outboudproxy-user-at-from-header", true);
                    if (this.myHostIp.equalsIgnoreCase(toHost) || this.mediaExternalIp.equalsIgnoreCase(toHost)) {
                        this.logger.info("Call to NUMBER.  myHostIp: " + this.myHostIp + " mediaExternalIp: " + this.mediaExternalIp + " toHost: " + toHost + " proxyUri: " + proxyURI);
                        try {
                            from = useLocalAddressAtFromHeader ? (outboudproxyUserAtFromHeader ? this.sipFactory.createSipURI(proxyUsername, this.mediaExternalIp + ":" + outboundIntf.getPort()) : this.sipFactory.createSipURI(((SipURI)request.getFrom().getURI()).getUser(), this.mediaExternalIp + ":" + outboundIntf.getPort())) : (outboudproxyUserAtFromHeader ? this.sipFactory.createSipURI(proxyUsername, proxyURI) : this.sipFactory.createSipURI(((SipURI)request.getFrom().getURI()).getUser(), proxyURI));
                            to = this.sipFactory.createSipURI(((SipURI)request.getTo().getURI()).getUser(), proxyURI);
                        }
                        catch (Exception exception) {
                            this.logger.info("Exception: " + exception);
                        }
                    } else {
                        this.logger.info("Call to SIP URI. myHostIp: " + this.myHostIp + " mediaExternalIp: " + this.mediaExternalIp + " toHost: " + toHost + " proxyUri: " + proxyURI);
                        from = this.sipFactory.createSipURI(((SipURI)request.getFrom().getURI()).getUser(), outboundIntf.getHost() + ":" + outboundIntf.getPort());
                        to = this.sipFactory.createSipURI(toUser, toHost + ":" + toPort);
                        callToSipUri = true;
                    }
                    if (B2BUAHelper.redirectToB2BUA((SipServletRequest)request, (Client)client, (SipURI)from, (SipURI)to, (String)proxyUsername, (String)proxyPassword, (DaoManager)this.storage, (SipFactory)this.sipFactory, (boolean)callToSipUri)) {
                        return;
                    }
                } else {
                    String msg = "Restcomm tried to proxy this call to an outbound party but it seems the outbound proxy is not configured.";
                    this.sendNotification(errMsg, 11004, "warning", true);
                }
            }
        } else if (this.redirectToHostedVoiceApp(self, request, accounts, applications, toUser)) {
            return;
        }
        SipServletResponse response = request.createResponse(404);
        response.send();
        errMsg = "Restcomm cannot process this call because the destination number " + toUser + "cannot be found or there is application attached to that";
        this.sendNotification(errMsg, 11005, "error", true);
    }

    private void info(SipServletRequest request) throws IOException {
        ActorRef self = this.self();
        SipApplicationSession application = request.getApplicationSession();
        SipSession linkedB2BUASession = B2BUAHelper.getLinkedSession((SipServletMessage)request);
        if (linkedB2BUASession != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(String.format("B2BUA: Got INFO request: \n %s", request));
            }
            request.getSession().setAttribute("lastRequest", (Object)request);
            SipServletRequest clonedInfo = linkedB2BUASession.createRequest("INFO");
            linkedB2BUASession.setAttribute("lastRequest", (Object)clonedInfo);
            SipURI toInetUri = (SipURI)request.getSession().getAttribute("toInetUri");
            SipURI fromInetUri = (SipURI)request.getSession().getAttribute("fromInetUri");
            InetAddress infoRURI = null;
            try {
                infoRURI = InetAddress.getByName(((SipURI)clonedInfo.getRequestURI()).getHost());
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
            if (toInetUri != null && infoRURI == null) {
                this.logger.info("Using the real ip address of the sip client " + toInetUri.toString() + " as a request uri of the CloneBye request");
                clonedInfo.setRequestURI((URI)toInetUri);
            } else if (toInetUri != null && (infoRURI.isSiteLocalAddress() || infoRURI.isAnyLocalAddress() || infoRURI.isLoopbackAddress())) {
                this.logger.info("Using the real ip address of the sip client " + toInetUri.toString() + " as a request uri of the CloneInfo request");
                clonedInfo.setRequestURI((URI)toInetUri);
            } else if (fromInetUri != null && (infoRURI.isSiteLocalAddress() || infoRURI.isAnyLocalAddress() || infoRURI.isLoopbackAddress())) {
                this.logger.info("Using the real ip address of the sip client " + fromInetUri.toString() + " as a request uri of the CloneInfo request");
                clonedInfo.setRequestURI((URI)fromInetUri);
            }
            clonedInfo.send();
        } else {
            ActorRef call = (ActorRef)application.getAttribute(Call.class.getName());
            call.tell((Object)request, self);
        }
    }

    private boolean redirectToHostedVoiceApp(ActorRef self, SipServletRequest request, AccountsDao accounts, ApplicationsDao applications, String phone) {
        boolean isFoundHostedApp = false;
        PhoneNumberUtil phoneNumberUtil = PhoneNumberUtil.getInstance();
        String formatedPhone = null;
        try {
            formatedPhone = phoneNumberUtil.format(phoneNumberUtil.parse(phone, "US"), PhoneNumberUtil.PhoneNumberFormat.E164);
        }
        catch (Exception e) {
            // empty catch block
        }
        IncomingPhoneNumber number = null;
        try {
            IncomingPhoneNumbersDao numbers = this.storage.getIncomingPhoneNumbersDao();
            number = numbers.getIncomingPhoneNumber(formatedPhone);
            if (number == null) {
                number = numbers.getIncomingPhoneNumber(phone);
            }
            if (number == null) {
                number = numbers.getIncomingPhoneNumber("*");
            }
            if (number != null) {
                VoiceInterpreterBuilder builder = new VoiceInterpreterBuilder(this.system);
                builder.setConfiguration(this.configuration);
                builder.setStorage(this.storage);
                builder.setCallManager(self);
                builder.setConferenceManager(this.conferences);
                builder.setBridgeManager(this.bridges);
                builder.setSmsService(this.sms);
                builder.setAccount(number.getAccountSid());
                builder.setVersion(number.getApiVersion());
                Account account = accounts.getAccount(number.getAccountSid());
                builder.setEmailAddress(account.getEmailAddress());
                Sid sid = number.getVoiceApplicationSid();
                if (sid != null) {
                    Application application = applications.getApplication(sid);
                    builder.setUrl(UriUtils.resolve((String)request.getLocalAddr(), (int)8080, (java.net.URI)application.getVoiceUrl()));
                    builder.setMethod(application.getVoiceMethod());
                    builder.setFallbackUrl(application.getVoiceFallbackUrl());
                    builder.setFallbackMethod(application.getVoiceFallbackMethod());
                    builder.setStatusCallback(application.getStatusCallback());
                    builder.setStatusCallbackMethod(application.getStatusCallbackMethod());
                } else {
                    builder.setUrl(UriUtils.resolve((String)request.getLocalAddr(), (int)8080, (java.net.URI)number.getVoiceUrl()));
                    builder.setMethod(number.getVoiceMethod());
                    builder.setFallbackUrl(number.getVoiceFallbackUrl());
                    builder.setFallbackMethod(number.getVoiceFallbackMethod());
                    builder.setStatusCallback(number.getStatusCallback());
                    builder.setStatusCallbackMethod(number.getStatusCallbackMethod());
                }
                ActorRef interpreter = builder.build();
                ActorRef call = this.call();
                SipApplicationSession application = request.getApplicationSession();
                application.setAttribute(Call.class.getName(), (Object)call);
                call.tell((Object)request, self);
                interpreter.tell((Object)new StartInterpreter(call), self);
                isFoundHostedApp = true;
            }
        }
        catch (Exception notANumber) {
            String errMsg = number != null ? "The number " + number.getPhoneNumber() + "does not have a Restcomm hosted application attached" : "The number does not have a Restcomm hosted application attached";
            this.sendNotification(errMsg, 11007, "error", false);
            isFoundHostedApp = false;
        }
        return isFoundHostedApp;
    }

    private boolean redirectToClientVoiceApp(ActorRef self, SipServletRequest request, AccountsDao accounts, ApplicationsDao applications, Client client) {
        boolean isClientManaged;
        java.net.URI clientAppVoiceUril = client.getVoiceUrl();
        boolean bl = isClientManaged = clientAppVoiceUril != null;
        if (isClientManaged) {
            VoiceInterpreterBuilder builder = new VoiceInterpreterBuilder(this.system);
            builder.setConfiguration(this.configuration);
            builder.setStorage(this.storage);
            builder.setCallManager(self);
            builder.setConferenceManager(this.conferences);
            builder.setBridgeManager(this.bridges);
            builder.setSmsService(this.sms);
            builder.setAccount(client.getAccountSid());
            builder.setVersion(client.getApiVersion());
            Account account = accounts.getAccount(client.getAccountSid());
            builder.setEmailAddress(account.getEmailAddress());
            Sid sid = client.getVoiceApplicationSid();
            if (sid != null) {
                Application application = applications.getApplication(sid);
                builder.setUrl(application.getVoiceUrl());
                builder.setMethod(application.getVoiceMethod());
                builder.setFallbackUrl(application.getVoiceFallbackUrl());
                builder.setFallbackMethod(application.getVoiceFallbackMethod());
            } else {
                builder.setUrl(clientAppVoiceUril);
                builder.setMethod(client.getVoiceMethod());
                builder.setFallbackUrl(client.getVoiceFallbackUrl());
                builder.setFallbackMethod(client.getVoiceFallbackMethod());
            }
            ActorRef interpreter = builder.build();
            ActorRef call = this.call();
            SipApplicationSession application = request.getApplicationSession();
            application.setAttribute(Call.class.getName(), (Object)call);
            call.tell((Object)request, self);
            interpreter.tell((Object)new StartInterpreter(call), self);
        }
        return isClientManaged;
    }

    private void pong(Object message) throws IOException {
        SipServletRequest request = (SipServletRequest)message;
        SipServletResponse response = request.createResponse(200);
        response.send();
    }

    public void onReceive(Object message) throws Exception {
        Class<?> klass = message.getClass();
        ActorRef self = this.self();
        ActorRef sender = this.sender();
        this.logger.debug("######### CallManager new message received, message instanceof : " + klass + " from sender : " + sender.getClass());
        if (message instanceof SipServletRequest) {
            SipServletRequest request = (SipServletRequest)message;
            String method = request.getMethod();
            if ("INVITE".equals(method)) {
                this.check(request);
                this.invite(request);
            } else if ("OPTIONS".equals(method)) {
                this.pong(request);
            } else if ("ACK".equals(method)) {
                this.ack(request);
            } else if ("CANCEL".equals(method)) {
                this.cancel(request);
            } else if ("BYE".equals(method)) {
                this.bye(request);
            } else if ("INFO".equals(method)) {
                this.info(request);
            }
        } else if (CreateCall.class.equals(klass)) {
            try {
                this.createCallRequest = (CreateCall)message;
                sender.tell((Object)new CallManagerResponse((Object)this.outbound(message)), self);
            }
            catch (Exception exception) {
                sender.tell((Object)new CallManagerResponse((Throwable)exception), self);
            }
        } else if (ExecuteCallScript.class.equals(klass)) {
            this.execute(message);
        } else if (UpdateCallScript.class.equals(klass)) {
            try {
                this.update(message);
            }
            catch (Exception exception) {
                sender.tell((Object)new CallManagerResponse((Throwable)exception), self);
            }
        } else if (DestroyCall.class.equals(klass)) {
            this.destroy(message);
        } else if (message instanceof SipServletResponse) {
            this.response(message);
        } else if (message instanceof SipApplicationSessionEvent) {
            this.timeout(message);
        } else if (GetCall.class.equals(klass)) {
            sender.tell((Object)this.lookup(message), self);
        } else if (GetActiveProxy.class.equals(klass)) {
            sender.tell(this.getActiveProxy(), self);
        } else if (SwitchProxy.class.equals(klass)) {
            this.switchProxyRequest = (SwitchProxy)message;
            sender.tell(this.switchProxy(), self);
        } else if (GetProxies.class.equals(klass)) {
            sender.tell(this.getProxies(message), self);
        }
    }

    private void ack(SipServletRequest request) throws IOException {
        SipServletResponse response = B2BUAHelper.getLinkedResponse((SipServletMessage)request);
        if (response != null) {
            SipServletRequest ack = response.createAck();
            if (!ack.getHeaders("Route").hasNext()) {
                InetAddress ackRURI = null;
                try {
                    ackRURI = InetAddress.getByName(((SipURI)ack.getRequestURI()).getHost());
                }
                catch (UnknownHostException e) {
                    // empty catch block
                }
                SipURI toInetUri = (SipURI)request.getSession().getAttribute("toInetUri");
                if (toInetUri != null && ackRURI == null) {
                    this.logger.info("Using the real ip address of the sip client " + toInetUri.toString() + " as a request uri of the ACK request");
                    ack.setRequestURI((URI)toInetUri);
                } else if (toInetUri != null && (ackRURI.isSiteLocalAddress() || ackRURI.isAnyLocalAddress() || ackRURI.isLoopbackAddress())) {
                    this.logger.info("Using the real ip address of the sip client " + toInetUri.toString() + " as a request uri of the ACK request");
                    ack.setRequestURI((URI)toInetUri);
                }
            }
            ack.send();
            SipApplicationSession sipApplicationSession = request.getApplicationSession();
            sipApplicationSession.setExpires(60);
        }
    }

    private void execute(Object message) {
        ExecuteCallScript request = (ExecuteCallScript)message;
        ActorRef self = this.self();
        VoiceInterpreterBuilder builder = new VoiceInterpreterBuilder(this.system);
        builder.setConfiguration(this.configuration);
        builder.setStorage(this.storage);
        builder.setCallManager(self);
        builder.setConferenceManager(this.conferences);
        builder.setBridgeManager(this.bridges);
        builder.setSmsService(this.sms);
        builder.setAccount(request.account());
        builder.setVersion(request.version());
        builder.setUrl(request.url());
        builder.setMethod(request.method());
        builder.setFallbackUrl(request.fallbackUrl());
        builder.setFallbackMethod(request.fallbackMethod());
        builder.setStatusCallback(request.callback());
        builder.setStatusCallbackMethod(request.callbackMethod());
        ActorRef interpreter = builder.build();
        interpreter.tell((Object)new StartInterpreter(request.call()), self);
    }

    private void update(Object message) throws Exception {
        UpdateCallScript request = (UpdateCallScript)message;
        ActorRef self = this.self();
        ActorRef call = request.call();
        Boolean moveConnectedCallLeg = request.moveConnecteCallLeg();
        Timeout expires = new Timeout(Duration.create((long)60L, (TimeUnit)TimeUnit.SECONDS));
        Future future = Patterns.ask((ActorRef)call, (Object)new GetCallObservers(), (Timeout)expires);
        CallResponse response = (CallResponse)Await.result((Awaitable)future, (Duration)Duration.create((long)10L, (TimeUnit)TimeUnit.SECONDS));
        List callObservers = (List)response.get();
        ActorRef existingInterpreter = (ActorRef)callObservers.iterator().next();
        future = Patterns.ask((ActorRef)existingInterpreter, (Object)new GetOutboundCall(), (Timeout)expires);
        Object answer = Await.result((Awaitable)future, (Duration)Duration.create((long)10L, (TimeUnit)TimeUnit.SECONDS));
        ActorRef outboundCall = null;
        if (answer instanceof ActorRef) {
            outboundCall = (ActorRef)answer;
        }
        this.logger.info("About to start Live Call Modification");
        this.logger.info("Initial Call path: " + call.path());
        if (outboundCall != null) {
            this.logger.info("Outbound Call path: " + outboundCall.path());
        }
        this.logger.info("Will tell Call actors to stop observing existing Interpreters");
        call.tell((Object)new StopObserving(), this.self());
        if (outboundCall != null) {
            outboundCall.tell((Object)new StopObserving(), this.self());
        }
        this.logger.info("Existing observers removed from Calls actors");
        this.logger.info("Existing Interpreter path: " + existingInterpreter.path() + " will be stopped");
        existingInterpreter.tell((Object)new StopInterpreter(true), null);
        VoiceInterpreterBuilder builder = new VoiceInterpreterBuilder(this.system);
        builder.setConfiguration(this.configuration);
        builder.setStorage(this.storage);
        builder.setCallManager(self);
        builder.setConferenceManager(this.conferences);
        builder.setBridgeManager(this.bridges);
        builder.setSmsService(this.sms);
        builder.setAccount(request.account());
        builder.setVersion(request.version());
        builder.setUrl(request.url());
        builder.setMethod(request.method());
        builder.setFallbackUrl(request.fallbackUrl());
        builder.setFallbackMethod(request.fallbackMethod());
        builder.setStatusCallback(request.callback());
        builder.setStatusCallbackMethod(request.callbackMethod());
        ActorRef interpreter = builder.build();
        this.system.scheduler().scheduleOnce(Duration.create((long)2000L, (TimeUnit)TimeUnit.MILLISECONDS), interpreter, (Object)new StartInterpreter(request.call()), (ExecutionContext)this.system.dispatcher());
        this.logger.info("New Intepreter for first call leg: " + interpreter.path() + " started");
        if (outboundCall != null) {
            if (moveConnectedCallLeg.booleanValue()) {
                ActorRef outboundInterpreter = builder.build();
                this.logger.info("About to redirect outbound Call :" + outboundCall.path() + " with 200ms delay to outbound interpreter: " + outboundInterpreter.path());
                this.system.scheduler().scheduleOnce(Duration.create((long)3000L, (TimeUnit)TimeUnit.MILLISECONDS), outboundInterpreter, (Object)new StartInterpreter(outboundCall), (ExecutionContext)this.system.dispatcher());
                this.logger.info("New Intepreter for Second call leg: " + outboundInterpreter.path() + " started");
            } else {
                this.logger.info("moveConnectedCallLeg is: " + moveConnectedCallLeg + " so will hangup outboundCall");
                outboundCall.tell((Object)new Hangup(), null);
                this.getContext().stop(outboundCall);
            }
        }
    }

    private ActorRef outbound(Object message) throws ServletParseException {
        CreateCall request = (CreateCall)message;
        Configuration runtime = this.configuration.subset("runtime-settings");
        boolean useLocalAddressAtFromHeader = runtime.getBoolean("use-local-address", false);
        String uri = this.activeProxy;
        String proxyUsername = request.username() != null ? request.username() : this.activeProxyUsername;
        String proxyPassword = request.password() != null ? request.password() : this.activeProxyPassword;
        SipURI from = null;
        SipURI to = null;
        switch (request.type()) {
            case CLIENT: {
                SipURI outboundIntf = this.outboundInterface("udp");
                from = request.from() != null && request.from().contains("@") ? (SipURI)this.sipFactory.createURI(request.from()) : (request.from() != null ? this.sipFactory.createSipURI(request.from(), this.mediaExternalIp + ":" + outboundIntf.getPort()) : outboundIntf);
                RegistrationsDao registrations = this.storage.getRegistrationsDao();
                Registration registration = registrations.getRegistration(request.to().replaceFirst("client:", ""));
                if (registration != null) {
                    String location = registration.getLocation();
                    to = (SipURI)this.sipFactory.createURI(location);
                    break;
                }
                String errMsg = "The SIP Client is not registered or does not exist";
                this.sendNotification(errMsg, 11008, "error", true);
                throw new NullPointerException(request.to() + " is not currently registered.");
            }
            case PSTN: {
                to = this.sipFactory.createSipURI(request.to(), uri);
                String transport = to.getTransportParam() != null ? to.getTransportParam() : "udp";
                SipURI outboundIntf = this.outboundInterface(transport);
                boolean outboudproxyUserAtFromHeader = runtime.subset("outbound-proxy").getBoolean("outboudproxy-user-at-from-header");
                from = request.from() != null && request.from().contains("@") ? (SipURI)this.sipFactory.createURI(request.from()) : (useLocalAddressAtFromHeader ? this.sipFactory.createSipURI(request.from(), this.mediaExternalIp + ":" + outboundIntf.getPort()) : (outboudproxyUserAtFromHeader ? this.sipFactory.createSipURI(proxyUsername, uri) : this.sipFactory.createSipURI(request.from(), uri)));
                if (from.getUser() != null && from.getUser() != "") break;
                if (uri != null) {
                    from = this.sipFactory.createSipURI(request.from(), uri);
                    break;
                }
                from = (SipURI)this.sipFactory.createURI(request.from());
                break;
            }
            case SIP: {
                to = (SipURI)this.sipFactory.createURI(request.to());
                String transport = to.getTransportParam() != null ? to.getTransportParam() : "udp";
                SipURI outboundIntf = this.outboundInterface(transport);
                if (request.from() == null) {
                    from = this.outboundInterface(transport);
                    break;
                }
                if (request.from() != null && request.from().contains("@")) {
                    from = (SipURI)this.sipFactory.createURI(request.from());
                    break;
                }
                from = this.sipFactory.createSipURI(request.from(), outboundIntf.getHost() + ":" + outboundIntf.getPort());
                break;
            }
        }
        if (from == null || to == null) {
            throw new ServletParseException("From and/or To are null, we cannot proceed to the outbound call");
        }
        ActorRef call = this.call();
        ActorRef self = this.self();
        boolean userAtDisplayedName = runtime.subset("outbound-proxy").getBoolean("user-at-displayed-name");
        InitializeOutbound init = request.from() != null && !request.from().contains("@") && userAtDisplayedName ? new InitializeOutbound(request.from(), from, to, proxyUsername, proxyPassword, (long)request.timeout(), request.isFromApi(), runtime.getString("api-version"), request.accountId(), request.type(), this.storage) : new InitializeOutbound(null, from, to, proxyUsername, proxyPassword, (long)request.timeout(), request.isFromApi(), runtime.getString("api-version"), request.accountId(), request.type(), this.storage);
        call.tell((Object)init, self);
        return call;
    }

    public void cancel(Object message) throws IOException {
        ActorRef self = this.self();
        SipServletRequest request = (SipServletRequest)message;
        SipApplicationSession application = request.getApplicationSession();
        SipServletRequest originalRequest = B2BUAHelper.getLinkedRequest((SipServletMessage)request);
        SipSession linkedB2BUASession = B2BUAHelper.getLinkedSession((SipServletMessage)request);
        if (originalRequest != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(String.format("B2BUA: Got CANCEL request: \n %s", request));
            }
            request.getSession().setAttribute("lastRequest", (Object)request);
            String sessionState = linkedB2BUASession.getState().name();
            SipServletResponse lastFinalResponse = (SipServletResponse)originalRequest.getSession().getAttribute("lastFinalResponse");
            if ((sessionState == SipSession.State.INITIAL.name() || sessionState == SipSession.State.EARLY.name()) && (lastFinalResponse == null || lastFinalResponse.getStatus() != 401 && lastFinalResponse.getStatus() != 407)) {
                SipServletRequest clonedCancel = originalRequest.createCancel();
                linkedB2BUASession.setAttribute("lastRequest", (Object)clonedCancel);
                clonedCancel.send();
            } else {
                SipServletRequest clonedBye = linkedB2BUASession.createRequest("BYE");
                linkedB2BUASession.setAttribute("lastRequest", (Object)clonedBye);
                clonedBye.send();
            }
        } else {
            ActorRef call = (ActorRef)application.getAttribute(Call.class.getName());
            call.tell((Object)request, self);
        }
    }

    public void bye(Object message) throws IOException {
        ActorRef self = this.self();
        SipServletRequest request = (SipServletRequest)message;
        SipApplicationSession application = request.getApplicationSession();
        SipSession linkedB2BUASession = B2BUAHelper.getLinkedSession((SipServletMessage)request);
        if (linkedB2BUASession != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(String.format("B2BUA: Got BYE request: \n %s", request));
            }
            request.getSession().setAttribute("lastRequest", (Object)request);
            SipServletRequest clonedBye = linkedB2BUASession.createRequest("BYE");
            linkedB2BUASession.setAttribute("lastRequest", (Object)clonedBye);
            if (!clonedBye.getHeaders("Route").hasNext()) {
                SipURI toInetUri = (SipURI)request.getSession().getAttribute("toInetUri");
                SipURI fromInetUri = (SipURI)request.getSession().getAttribute("fromInetUri");
                InetAddress byeRURI = null;
                try {
                    byeRURI = InetAddress.getByName(((SipURI)clonedBye.getRequestURI()).getHost());
                }
                catch (UnknownHostException e) {
                    // empty catch block
                }
                if (toInetUri != null && byeRURI == null) {
                    this.logger.info("Using the real ip address of the sip client " + toInetUri.toString() + " as a request uri of the CloneBye request");
                    clonedBye.setRequestURI((URI)toInetUri);
                } else if (toInetUri != null && (byeRURI.isSiteLocalAddress() || byeRURI.isAnyLocalAddress() || byeRURI.isLoopbackAddress())) {
                    this.logger.info("Using the real ip address of the sip client " + toInetUri.toString() + " as a request uri of the CloneBye request");
                    clonedBye.setRequestURI((URI)toInetUri);
                } else if (fromInetUri != null && (byeRURI.isSiteLocalAddress() || byeRURI.isAnyLocalAddress() || byeRURI.isLoopbackAddress())) {
                    this.logger.info("Using the real ip address of the sip client " + fromInetUri.toString() + " as a request uri of the CloneBye request");
                    clonedBye.setRequestURI((URI)fromInetUri);
                }
            }
            B2BUAHelper.updateCDR((SipServletMessage)request, (CallStateChanged.State)CallStateChanged.State.COMPLETED);
            SipServletResponse okay = request.createResponse(200);
            okay.send();
            clonedBye.send();
        } else {
            ActorRef call = (ActorRef)application.getAttribute(Call.class.getName());
            if (call != null) {
                call.tell((Object)request, self);
            }
        }
    }

    public void response(Object message) throws IOException {
        ActorRef self = this.self();
        SipServletResponse response = (SipServletResponse)message;
        if (this.allowFallback) {
            this.checkErrorResponse(response);
        }
        SipApplicationSession application = response.getApplicationSession();
        if (B2BUAHelper.isB2BUASession((SipServletMessage)response)) {
            if (response.getStatus() == 407 || response.getStatus() == 401) {
                AuthInfo authInfo = this.sipFactory.createAuthInfo();
                String authHeader = response.getHeader("Proxy-Authenticate");
                if (authHeader == null) {
                    authHeader = response.getHeader("WWW-Authenticate");
                }
                String tempRealm = authHeader.substring(authHeader.indexOf("realm=\"") + "realm=\"".length());
                String realm = tempRealm.substring(0, tempRealm.indexOf("\""));
                authInfo.addAuthInfo(response.getStatus(), realm, this.activeProxyUsername, this.activeProxyPassword);
                SipServletRequest challengeRequest = response.getSession().createRequest(response.getRequest().getMethod());
                response.getSession().setAttribute("lastFinalResponse", (Object)response);
                challengeRequest.addAuthHeader(response, authInfo);
                SipServletRequest invite = response.getRequest();
                challengeRequest.setContent(invite.getContent(), invite.getContentType());
                invite = challengeRequest;
                challengeRequest.send();
            } else {
                B2BUAHelper.forwardResponse((SipServletResponse)response);
            }
        } else if (application.isValid()) {
            ActorRef call = (ActorRef)application.getAttribute(Call.class.getName());
            call.tell((Object)response, self);
        }
    }

    public ActorRef lookup(Object message) {
        GetCall getCall = (GetCall)message;
        String callPath = getCall.callPath();
        UntypedActorContext context = this.getContext();
        return context.actorFor(callPath);
    }

    public void timeout(Object message) {
        ActorRef self = this.self();
        SipApplicationSessionEvent event = (SipApplicationSessionEvent)message;
        SipApplicationSession application = event.getApplicationSession();
        ActorRef call = (ActorRef)application.getAttribute(Call.class.getName());
        ReceiveTimeout$ timeout = ReceiveTimeout.getInstance();
        call.tell((Object)timeout, self);
    }

    public void checkErrorResponse(SipServletResponse response) {
        int status;
        if (!response.isBranchResponse() && response.getRequest().getMethod().equalsIgnoreCase("INVITE") && response.getRequest().isInitial() && (status = response.getStatus()) != 401 && status != 407 && status != 404 && status > 400) {
            int failures = this.numberOfFailedCalls.incrementAndGet();
            this.logger.info("A total number of " + failures + " failures have now been counted.");
            if (failures >= this.maxNumberOfFailedCalls) {
                this.logger.info("Max number of failed calls has been reached trying to switch over proxy.");
                this.logger.info("Current proxy: " + this.getActiveProxy().get("ActiveProxy"));
                this.switchProxy();
                this.logger.info("Switched to proxy: " + this.getActiveProxy().get("ActiveProxy"));
                this.numberOfFailedCalls.set(0);
            }
        }
    }

    public Map<String, String> getActiveProxy() {
        ConcurrentHashMap<String, String> activeProxyMap = new ConcurrentHashMap<String, String>();
        activeProxyMap.put("ActiveProxy", this.activeProxy);
        return activeProxyMap;
    }

    public Map<String, String> switchProxy() {
        if (this.activeProxy.equalsIgnoreCase(this.primaryProxyUri)) {
            this.activeProxy = this.fallBackProxyUri;
            this.activeProxyUsername = this.fallBackProxyUsername;
            this.activeProxyPassword = this.fallBackProxyPassword;
            this.useFallbackProxy.set(true);
        } else if (this.allowFallbackToPrimary) {
            this.activeProxy = this.primaryProxyUri;
            this.activeProxyUsername = this.primaryProxyUsername;
            this.activeProxyPassword = this.primaryProxyPassword;
            this.useFallbackProxy.set(false);
        }
        Notification notification = this.notification(1, 14110, "Max number of failed calls has been reached! Outbound proxy switched");
        NotificationsDao notifications = this.storage.getNotificationsDao();
        notifications.addNotification(notification);
        return this.getActiveProxy();
    }

    public Map<String, String> getProxies(Object message) {
        ConcurrentHashMap<String, String> proxies = new ConcurrentHashMap<String, String>();
        proxies.put("ActiveProxy", this.activeProxy);
        proxies.put("UsingFallBackProxy", this.useFallbackProxy.toString());
        proxies.put("AllowFallbackToPrimary", String.valueOf(this.allowFallbackToPrimary));
        proxies.put("PrimaryProxy", this.primaryProxyUri);
        proxies.put("FallbackProxy", this.fallBackProxyUri);
        return proxies;
    }

    private Notification notification(int log, int error, String message) {
        String version = this.configuration.subset("runtime-settings").getString("api-version");
        Sid accountId = null;
        accountId = this.createCallRequest != null ? this.createCallRequest.accountId() : (this.switchProxyRequest != null ? this.switchProxyRequest.getSid() : new Sid("ACae6e420f425248d6a26948c17a9e2acf"));
        Notification.Builder builder = Notification.builder();
        Sid sid = Sid.generate((Sid.Type)Sid.Type.NOTIFICATION);
        builder.setSid(sid);
        builder.setAccountSid(accountId);
        builder.setApiVersion(version);
        builder.setLog(log);
        builder.setErrorCode(error);
        String base = this.configuration.subset("runtime-settings").getString("error-dictionary-uri");
        StringBuilder buffer = new StringBuilder();
        buffer.append(base);
        if (!base.endsWith("/")) {
            buffer.append("/");
        }
        buffer.append(error).append(".html");
        java.net.URI info = java.net.URI.create(buffer.toString());
        builder.setMoreInfo(info);
        builder.setMessageText(message);
        DateTime now = DateTime.now();
        builder.setMessageDate(now);
        try {
            builder.setRequestUrl(new java.net.URI(""));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        builder.setRequestMethod("");
        builder.setRequestVariables("");
        buffer = new StringBuilder();
        buffer.append("/").append(version).append("/Accounts/");
        buffer.append(accountId.toString()).append("/Notifications/");
        buffer.append(sid.toString());
        java.net.URI uri = java.net.URI.create(buffer.toString());
        builder.setUri(uri);
        return builder.build();
    }

    private SipURI outboundInterface(String transport) {
        SipURI result = null;
        List uris = (List)this.context.getAttribute("javax.servlet.sip.outboundInterfaces");
        for (SipURI uri : uris) {
            String interfaceTransport = uri.getTransportParam();
            if (!transport.equalsIgnoreCase(interfaceTransport)) continue;
            result = uri;
        }
        return result;
    }
}

