/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.telephony;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ReceiveTimeout;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorContext;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import javax.sdp.SdpException;
import javax.servlet.sip.Address;
import javax.servlet.sip.AuthInfo;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import org.apache.commons.configuration.Configuration;
import org.joda.time.DateTime;
import org.mobicents.javax.servlet.sip.SipSessionExt;
import org.mobicents.servlet.restcomm.annotations.concurrency.Immutable;
import org.mobicents.servlet.restcomm.dao.CallDetailRecordsDao;
import org.mobicents.servlet.restcomm.dao.DaoManager;
import org.mobicents.servlet.restcomm.entities.CallDetailRecord;
import org.mobicents.servlet.restcomm.entities.Sid;
import org.mobicents.servlet.restcomm.fsm.Action;
import org.mobicents.servlet.restcomm.fsm.FiniteStateMachine;
import org.mobicents.servlet.restcomm.fsm.State;
import org.mobicents.servlet.restcomm.fsm.Transition;
import org.mobicents.servlet.restcomm.mscontrol.messages.CloseMediaSession;
import org.mobicents.servlet.restcomm.mscontrol.messages.Collect;
import org.mobicents.servlet.restcomm.mscontrol.messages.CreateMediaSession;
import org.mobicents.servlet.restcomm.mscontrol.messages.JoinBridge;
import org.mobicents.servlet.restcomm.mscontrol.messages.JoinComplete;
import org.mobicents.servlet.restcomm.mscontrol.messages.JoinConference;
import org.mobicents.servlet.restcomm.mscontrol.messages.Leave;
import org.mobicents.servlet.restcomm.mscontrol.messages.Left;
import org.mobicents.servlet.restcomm.mscontrol.messages.MediaGroupResponse;
import org.mobicents.servlet.restcomm.mscontrol.messages.MediaServerControllerStateChanged;
import org.mobicents.servlet.restcomm.mscontrol.messages.MediaSessionInfo;
import org.mobicents.servlet.restcomm.mscontrol.messages.Mute;
import org.mobicents.servlet.restcomm.mscontrol.messages.Play;
import org.mobicents.servlet.restcomm.mscontrol.messages.Record;
import org.mobicents.servlet.restcomm.mscontrol.messages.StartRecording;
import org.mobicents.servlet.restcomm.mscontrol.messages.Stop;
import org.mobicents.servlet.restcomm.mscontrol.messages.StopMediaGroup;
import org.mobicents.servlet.restcomm.mscontrol.messages.StopRecording;
import org.mobicents.servlet.restcomm.mscontrol.messages.Unmute;
import org.mobicents.servlet.restcomm.mscontrol.messages.UpdateMediaSession;
import org.mobicents.servlet.restcomm.patterns.Observe;
import org.mobicents.servlet.restcomm.patterns.Observing;
import org.mobicents.servlet.restcomm.patterns.StopObserving;
import org.mobicents.servlet.restcomm.telephony.Answer;
import org.mobicents.servlet.restcomm.telephony.CallInfo;
import org.mobicents.servlet.restcomm.telephony.CallResponse;
import org.mobicents.servlet.restcomm.telephony.CallStateChanged;
import org.mobicents.servlet.restcomm.telephony.Cancel;
import org.mobicents.servlet.restcomm.telephony.ChangeCallDirection;
import org.mobicents.servlet.restcomm.telephony.CreateCall;
import org.mobicents.servlet.restcomm.telephony.Dial;
import org.mobicents.servlet.restcomm.telephony.GetCallInfo;
import org.mobicents.servlet.restcomm.telephony.GetCallObservers;
import org.mobicents.servlet.restcomm.telephony.Hangup;
import org.mobicents.servlet.restcomm.telephony.InitializeOutbound;
import org.mobicents.servlet.restcomm.telephony.Reject;
import org.mobicents.servlet.restcomm.telephony.RemoveParticipant;
import org.mobicents.servlet.restcomm.util.SdpUtils;
import scala.concurrent.duration.Duration;

@Immutable
public final class Call
extends UntypedActor {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private static final String INBOUND = "inbound";
    private static final String OUTBOUND_API = "outbound-api";
    private static final String OUTBOUND_DIAL = "outbound-dial";
    private final FiniteStateMachine fsm;
    private final State uninitialized;
    private final State initializing;
    private final State queued;
    private final State failingBusy;
    private final State ringing;
    private final State busy;
    private final State notFound;
    private final State canceling;
    private final State canceled;
    private final State failingNoAnswer;
    private final State noAnswer;
    private final State dialing;
    private final State updatingMediaSession;
    private final State inProgress;
    private final State joining;
    private final State leaving;
    private final State stopping;
    private final State completed;
    private final State failed;
    private boolean fail;
    private final SipFactory factory;
    private String apiVersion;
    private Sid accountId;
    private String name;
    private SipURI from;
    private SipURI to;
    private Map<String, String> headers;
    private String username;
    private String password;
    private CreateCall.Type type;
    private long timeout;
    private SipServletRequest invite;
    private SipServletResponse lastResponse;
    private final Sid id;
    private CallStateChanged.State external;
    private String direction;
    private String forwardedFrom;
    private DateTime created;
    private final List<ActorRef> observers;
    private boolean receivedBye;
    private ActorRef conference;
    private boolean conferencing;
    private ActorRef bridge;
    private final ActorRef msController;
    private MediaSessionInfo mediaSessionInfo;
    private CallDetailRecord outgoingCallRecord;
    private CallDetailRecordsDao recordsDao;
    private DaoManager daoManager;
    private boolean liveCallModification;
    private boolean recording;
    private Configuration runtimeSettings;

    public Call(SipFactory factory, ActorRef mediaSessionController) {
        ActorRef source = this.self();
        this.uninitialized = new State("uninitialized", null, null);
        this.initializing = new State("initializing", (Action)new Initializing(source), null);
        this.queued = new State("queued", (Action)new Queued(source), null);
        this.ringing = new State("ringing", (Action)new Ringing(source), null);
        this.failingBusy = new State("failing busy", (Action)new FailingBusy(source), null);
        this.busy = new State("busy", (Action)new Busy(source), null);
        this.notFound = new State("not found", (Action)new NotFound(source), null);
        this.canceling = new State("canceling", (Action)new Canceling(source), null);
        this.canceled = new State("canceled", (Action)new Canceled(source), null);
        this.failingNoAnswer = new State("failing no answer", (Action)new FailingNoAnswer(source), null);
        this.noAnswer = new State("no answer", (Action)new NoAnswer(source), null);
        this.dialing = new State("dialing", (Action)new Dialing(source), null);
        this.updatingMediaSession = new State("updating media session", (Action)new UpdatingMediaSession(source), null);
        this.inProgress = new State("in progress", (Action)new InProgress(source), null);
        this.joining = new State("joining", (Action)new Joining(source), null);
        this.leaving = new State("leaving", (Action)new Leaving(source), null);
        this.stopping = new State("stopping", (Action)new Stopping(source), null);
        this.completed = new State("completed", (Action)new Completed(source), null);
        this.failed = new State("failed", (Action)new Failed(source), null);
        HashSet<Transition> transitions = new HashSet<Transition>();
        transitions.add(new Transition(this.uninitialized, this.ringing));
        transitions.add(new Transition(this.uninitialized, this.queued));
        transitions.add(new Transition(this.queued, this.canceled));
        transitions.add(new Transition(this.queued, this.initializing));
        transitions.add(new Transition(this.ringing, this.busy));
        transitions.add(new Transition(this.ringing, this.notFound));
        transitions.add(new Transition(this.ringing, this.canceling));
        transitions.add(new Transition(this.ringing, this.canceled));
        transitions.add(new Transition(this.ringing, this.failingNoAnswer));
        transitions.add(new Transition(this.ringing, this.failingBusy));
        transitions.add(new Transition(this.ringing, this.noAnswer));
        transitions.add(new Transition(this.ringing, this.initializing));
        transitions.add(new Transition(this.ringing, this.updatingMediaSession));
        transitions.add(new Transition(this.ringing, this.stopping));
        transitions.add(new Transition(this.initializing, this.canceling));
        transitions.add(new Transition(this.initializing, this.dialing));
        transitions.add(new Transition(this.initializing, this.failed));
        transitions.add(new Transition(this.initializing, this.inProgress));
        transitions.add(new Transition(this.initializing, this.stopping));
        transitions.add(new Transition(this.dialing, this.canceling));
        transitions.add(new Transition(this.dialing, this.stopping));
        transitions.add(new Transition(this.dialing, this.failingBusy));
        transitions.add(new Transition(this.dialing, this.ringing));
        transitions.add(new Transition(this.dialing, this.updatingMediaSession));
        transitions.add(new Transition(this.inProgress, this.stopping));
        transitions.add(new Transition(this.inProgress, this.joining));
        transitions.add(new Transition(this.inProgress, this.leaving));
        transitions.add(new Transition(this.joining, this.inProgress));
        transitions.add(new Transition(this.joining, this.stopping));
        transitions.add(new Transition(this.joining, this.failed));
        transitions.add(new Transition(this.leaving, this.inProgress));
        transitions.add(new Transition(this.leaving, this.stopping));
        transitions.add(new Transition(this.leaving, this.failed));
        transitions.add(new Transition(this.canceling, this.canceled));
        transitions.add(new Transition(this.failingBusy, this.busy));
        transitions.add(new Transition(this.failingNoAnswer, this.noAnswer));
        transitions.add(new Transition(this.failingNoAnswer, this.canceling));
        transitions.add(new Transition(this.updatingMediaSession, this.inProgress));
        transitions.add(new Transition(this.updatingMediaSession, this.failed));
        transitions.add(new Transition(this.stopping, this.completed));
        this.fsm = new FiniteStateMachine(this.uninitialized, transitions);
        this.factory = factory;
        this.conferencing = false;
        this.msController = mediaSessionController;
        this.fail = false;
        this.id = Sid.generate((Sid.Type)Sid.Type.CALL);
        this.created = DateTime.now();
        this.observers = Collections.synchronizedList(new ArrayList());
        this.receivedBye = false;
        this.liveCallModification = false;
        this.recording = false;
    }

    private boolean is(State state) {
        return this.fsm.state().equals((Object)state);
    }

    private boolean isInbound() {
        return INBOUND.equals(this.direction);
    }

    private boolean isOutbound() {
        return !this.isInbound();
    }

    private CallResponse<CallInfo> info() {
        String from = this.from.getUser();
        String to = this.to.getUser();
        CallInfo info = new CallInfo(this.id, this.external, this.type, this.direction, this.created, this.forwardedFrom, this.name, from, to, this.invite, this.lastResponse);
        return new CallResponse((Object)info);
    }

    private void forwarding(Object message) {
    }

    private SipURI getInitialIpAddressPort(SipServletMessage message) throws ServletParseException, UnknownHostException {
        String realIP = message.getInitialRemoteAddr();
        Integer realPort = message.getInitialRemotePort();
        if (realPort == null || realPort == -1) {
            realPort = 5060;
        }
        ListIterator recordRouteHeaders = message.getHeaders("Record-Route");
        Address contactAddr = this.factory.createAddress(message.getHeader("Contact"));
        InetAddress contactInetAddress = InetAddress.getByName(((SipURI)contactAddr.getURI()).getHost());
        InetAddress inetAddress = InetAddress.getByName(realIP);
        int remotePort = message.getRemotePort();
        int contactPort = ((SipURI)contactAddr.getURI()).getPort();
        String remoteAddress = message.getRemoteAddr();
        String initialIpBeforeLB = message.getHeader("X-Sip-Balancer-InitialRemoteAddr");
        String initialPortBeforeLB = message.getHeader("X-Sip-Balancer-InitialRemotePort");
        String contactAddress = ((SipURI)contactAddr.getURI()).getHost();
        SipURI uri = null;
        if (initialIpBeforeLB != null) {
            if (initialPortBeforeLB == null) {
                initialPortBeforeLB = "5060";
            }
            this.logger.info("We are behind load balancer, storing Initial Remote Address " + initialIpBeforeLB + ":" + initialPortBeforeLB + " to the session for later use");
            realIP = initialIpBeforeLB + ":" + initialPortBeforeLB;
            uri = this.factory.createSipURI(null, realIP);
        } else if (contactInetAddress.isSiteLocalAddress() && !recordRouteHeaders.hasNext() && !contactInetAddress.toString().equalsIgnoreCase(inetAddress.toString())) {
            this.logger.info("Contact header address " + contactAddr.toString() + " is a private network ip address, storing Initial Remote Address " + realIP + ":" + realPort + " to the session for later use");
            realIP = realIP + ":" + realPort;
            uri = this.factory.createSipURI(null, realIP);
        }
        return uri;
    }

    public void onReceive(Object message) throws Exception {
        Class<?> klass = message.getClass();
        ActorRef self = this.self();
        ActorRef sender = this.sender();
        State state = this.fsm.state();
        this.logger.info("********** Call's " + this.self().path() + " Current State: \"" + state.toString());
        this.logger.info("********** Call " + this.self().path() + " Processing Message: \"" + klass.getName() + " sender : " + sender.getClass());
        if (Observe.class.equals(klass)) {
            this.onObserve((Observe)message, self, sender);
        } else if (StopObserving.class.equals(klass)) {
            this.onStopObserving((StopObserving)message, self, sender);
        } else if (GetCallObservers.class.equals(klass)) {
            this.onGetCallObservers((GetCallObservers)message, self, sender);
        } else if (GetCallInfo.class.equals(klass)) {
            this.onGetCallInfo((GetCallInfo)message, self, sender);
        } else if (InitializeOutbound.class.equals(klass)) {
            this.onInitializeOutbound((InitializeOutbound)message, self, sender);
        } else if (ChangeCallDirection.class.equals(klass)) {
            this.onChangeCallDirection((ChangeCallDirection)message, self, sender);
        } else if (Answer.class.equals(klass)) {
            this.onAnswer((Answer)message, self, sender);
        } else if (Dial.class.equals(klass)) {
            this.onDial((Dial)message, self, sender);
        } else if (Reject.class.equals(klass)) {
            this.onReject((Reject)message, self, sender);
        } else if (JoinComplete.class.equals(klass)) {
            this.onJoinComplete((JoinComplete)message, self, sender);
        } else if (StartRecording.class.equals(klass)) {
            this.onStartRecordingCall((StartRecording)message, self, sender);
        } else if (StopRecording.class.equals(klass)) {
            this.onStopRecordingCall((StopRecording)message, self, sender);
        } else if (Cancel.class.equals(klass)) {
            this.onCancel((Cancel)message, self, sender);
        } else if (message instanceof ReceiveTimeout) {
            this.onReceiveTimeout((ReceiveTimeout)message, self, sender);
        } else if (message instanceof SipServletRequest) {
            this.onSipServletRequest((SipServletRequest)message, self, sender);
        } else if (message instanceof SipServletResponse) {
            this.onSipServletResponse((SipServletResponse)message, self, sender);
        } else if (Hangup.class.equals(klass)) {
            this.onHangup((Hangup)message, self, sender);
        } else if (org.mobicents.servlet.restcomm.telephony.NotFound.class.equals(klass)) {
            this.onNotFound((org.mobicents.servlet.restcomm.telephony.NotFound)message, self, sender);
        } else if (MediaServerControllerStateChanged.class.equals(klass)) {
            this.onMediaServerControllerStateChanged((MediaServerControllerStateChanged)message, self, sender);
        } else if (JoinConference.class.equals(klass)) {
            this.onJoinConference((JoinConference)message, self, sender);
        } else if (JoinBridge.class.equals(klass)) {
            this.onJoinBridge((JoinBridge)message, self, sender);
        } else if (Leave.class.equals(klass)) {
            this.onLeave((Leave)message, self, sender);
        } else if (Left.class.equals(klass)) {
            this.onLeft((Left)message, self, sender);
        } else if (Record.class.equals(klass)) {
            this.onRecord((Record)message, self, sender);
        } else if (Play.class.equals(klass)) {
            this.onPlay((Play)message, self, sender);
        } else if (Collect.class.equals(klass)) {
            this.onCollect((Collect)message, self, sender);
        } else if (StopMediaGroup.class.equals(klass)) {
            this.onStopMediaGroup((StopMediaGroup)message, self, sender);
        } else if (Mute.class.equals(klass)) {
            this.onMute((Mute)message, self, sender);
        } else if (Unmute.class.equals(klass)) {
            this.onUnmute((Unmute)message, self, sender);
        }
    }

    private void sendCallInfoToObservers() {
        for (ActorRef observer : this.observers) {
            observer.tell(this.info(), this.self());
        }
    }

    private void processInfo(SipServletRequest request) throws IOException {
        SipServletResponse okay = request.createResponse(200);
        okay.send();
        String digits = null;
        if (request.getContentType().equalsIgnoreCase("application/dtmf-relay")) {
            String content = new String(request.getRawContent());
            digits = content.split("\n")[0].replaceFirst("Signal=", "").trim();
        } else {
            digits = new String(request.getRawContent());
        }
        if (digits != null) {
            MediaGroupResponse infoResponse = new MediaGroupResponse((Object)digits);
            for (ActorRef observer : this.observers) {
                observer.tell((Object)infoResponse, this.self());
            }
            this.msController.tell((Object)new Stop(), this.self());
        }
    }

    private void onRecord(Record message, ActorRef self, ActorRef sender) {
        if (this.is(this.inProgress)) {
            this.recording = true;
            this.msController.tell((Object)message, sender);
        }
    }

    private void onPlay(Play message, ActorRef self, ActorRef sender) {
        if (this.is(this.inProgress)) {
            this.msController.tell((Object)message, sender);
        }
    }

    private void onCollect(Collect message, ActorRef self, ActorRef sender) {
        if (this.is(this.inProgress)) {
            this.msController.tell((Object)message, sender);
        }
    }

    private void onStopMediaGroup(StopMediaGroup message, ActorRef self, ActorRef sender) {
        if (this.is(this.inProgress)) {
            this.msController.tell((Object)message, sender);
        }
    }

    private void onMute(Mute message, ActorRef self, ActorRef sender) {
        if (this.is(this.inProgress)) {
            this.msController.tell((Object)message, sender);
        }
    }

    private void onUnmute(Unmute message, ActorRef self, ActorRef sender) {
        if (this.is(this.inProgress)) {
            this.msController.tell((Object)message, sender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onObserve(Observe message, ActorRef self, ActorRef sender) throws Exception {
        ActorRef observer = message.observer();
        if (observer != null) {
            List<ActorRef> list = this.observers;
            synchronized (list) {
                this.observers.add(observer);
                observer.tell((Object)new Observing(self), self);
            }
        }
    }

    private void onStopObserving(StopObserving message, ActorRef self, ActorRef sender) throws Exception {
        ActorRef observer = message.observer();
        if (observer != null) {
            this.observers.remove(observer);
        } else {
            this.observers.clear();
        }
    }

    private void onGetCallObservers(GetCallObservers message, ActorRef self, ActorRef sender) throws Exception {
        sender.tell((Object)new CallResponse(this.observers), self);
    }

    private void onGetCallInfo(GetCallInfo message, ActorRef self, ActorRef sender) throws Exception {
        sender.tell(this.info(), self);
    }

    private void onInitializeOutbound(InitializeOutbound message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.uninitialized)) {
            this.fsm.transition((Object)message, this.queued);
        }
    }

    private void onChangeCallDirection(ChangeCallDirection message, ActorRef self, ActorRef sender) {
        this.direction = INBOUND;
        this.liveCallModification = true;
        this.conferencing = false;
        this.conference = null;
        this.bridge = null;
    }

    private void onAnswer(Answer message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.ringing)) {
            this.fsm.transition((Object)message, this.initializing);
        }
    }

    private void onDial(Dial message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.queued)) {
            this.fsm.transition((Object)message, this.initializing);
        }
    }

    private void onReject(Reject message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.ringing)) {
            this.fsm.transition((Object)message, this.busy);
        }
    }

    private void onCancel(Cancel message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.initializing) || this.is(this.dialing) || this.is(this.ringing) || this.is(this.failingNoAnswer)) {
            this.fsm.transition((Object)message, this.canceling);
        }
    }

    private void onReceiveTimeout(ReceiveTimeout message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.ringing)) {
            this.fsm.transition((Object)message, this.failingNoAnswer);
        } else {
            this.logger.info("Timeout received. Sender: " + sender.path().toString() + " State: " + this.fsm.state() + " Direction: " + this.direction + " From: " + this.from + " To: " + this.to);
        }
    }

    private void onSipServletRequest(SipServletRequest message, ActorRef self, ActorRef sender) throws Exception {
        String method = message.getMethod();
        if ("INVITE".equalsIgnoreCase(method)) {
            if (this.is(this.uninitialized)) {
                this.fsm.transition((Object)message, this.ringing);
            }
        } else if ("CANCEL".equalsIgnoreCase(method)) {
            if (this.is(this.initializing)) {
                this.fsm.transition((Object)message, this.canceling);
            } else if (this.is(this.ringing) && this.isInbound()) {
                this.fsm.transition((Object)message, this.canceled);
            }
        } else if ("BYE".equalsIgnoreCase(method)) {
            this.receivedBye = true;
            SipServletRequest bye = message;
            SipServletResponse okay = bye.createResponse(200);
            okay.send();
            if (this.recording) {
                if (!this.direction.contains("outbound")) {
                    this.recording = false;
                    this.logger.info("Call Direction: " + this.direction);
                    this.logger.info("Initial Call - Will stop recording now");
                    this.msController.tell((Object)new Stop(false), self);
                } else if (this.conference != null) {
                    this.conference.tell((Object)new StopRecording(this.accountId, this.runtimeSettings, this.daoManager), null);
                }
            }
            if (this.conferencing) {
                this.conference.tell((Object)new RemoveParticipant(self), self);
            } else {
                this.fsm.transition((Object)message, this.stopping);
            }
        } else if ("INFO".equalsIgnoreCase(method)) {
            this.processInfo(message);
        }
    }

    private void onSipServletResponse(SipServletResponse message, ActorRef self, ActorRef sender) throws Exception {
        this.lastResponse = message;
        int code = message.getStatus();
        switch (code) {
            case 181: {
                this.forwarding(message);
                break;
            }
            case 180: 
            case 183: {
                if (this.is(this.ringing)) break;
                this.logger.info("Got 180 Ringing for Call: " + this.self().path() + " To: " + this.to + " sender: " + sender.path() + " observers size: " + this.observers.size());
                this.fsm.transition((Object)message, this.ringing);
                break;
            }
            case 486: 
            case 600: {
                this.sendCallInfoToObservers();
                if (this.is(this.dialing)) break;
                this.fsm.transition((Object)message, this.failingBusy);
                break;
            }
            case 401: 
            case 407: {
                if (this.username == null || this.password == null) {
                    this.sendCallInfoToObservers();
                    this.fsm.transition((Object)message, this.failed);
                    break;
                }
                AuthInfo authInfo = this.factory.createAuthInfo();
                String authHeader = message.getHeader("Proxy-Authenticate");
                if (authHeader == null) {
                    authHeader = message.getHeader("WWW-Authenticate");
                }
                String tempRealm = authHeader.substring(authHeader.indexOf("realm=\"") + "realm=\"".length());
                String realm = tempRealm.substring(0, tempRealm.indexOf("\""));
                authInfo.addAuthInfo(message.getStatus(), realm, this.username, this.password);
                SipServletRequest challengeRequest = message.getSession().createRequest(message.getRequest().getMethod());
                challengeRequest.addAuthHeader(message, authInfo);
                challengeRequest.setContent(this.invite.getContent(), this.invite.getContentType());
                this.invite = challengeRequest;
                this.invite.setContent(message.getRequest().getContent(), "application/sdp");
                challengeRequest.send();
                break;
            }
            case 200: {
                if (!this.is(this.dialing) && (!this.is(this.ringing) || INBOUND.equals(this.direction))) break;
                this.fsm.transition((Object)message, this.updatingMediaSession);
                break;
            }
            default: {
                if (code < 400 || code == 487) break;
                this.fail = true;
                this.sendCallInfoToObservers();
                this.fsm.transition((Object)message, this.stopping);
            }
        }
    }

    private void onHangup(Hangup message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.updatingMediaSession) || this.is(this.ringing) || this.is(this.queued) || this.is(this.dialing) || this.is(this.inProgress)) {
            if (!this.receivedBye) {
                this.sendBye();
            }
            if (this.recording) {
                this.recording = false;
                this.logger.info("Call - Will stop recording now");
                this.msController.tell((Object)new Stop(true), self);
            }
            this.fsm.transition((Object)message, this.stopping);
        }
    }

    private void sendBye() throws IOException {
        SipSession session = this.invite.getSession();
        SipServletRequest bye = session.createRequest("BYE");
        SipURI realInetUri = (SipURI)session.getAttribute("realInetUri");
        InetAddress byeRURI = InetAddress.getByName(((SipURI)bye.getRequestURI()).getHost());
        this.invite.getHeaders("Record-Route");
        ListIterator recordRouteList = this.invite.getHeaders("Record-Route");
        if (this.invite.getHeader("X-Sip-Balancer") != null) {
            this.logger.info("We are behind LoadBalancer and will remove the first two RecordRoutes since they are the LB node");
            recordRouteList.next();
            recordRouteList.remove();
            recordRouteList.next();
            recordRouteList.remove();
        }
        if (recordRouteList.hasNext()) {
            this.logger.info("Record Route is set, wont change the Request URI");
        } else if (realInetUri != null && (byeRURI.isSiteLocalAddress() || byeRURI.isAnyLocalAddress() || byeRURI.isLoopbackAddress())) {
            this.logger.info("Using the real ip address of the sip client " + realInetUri.toString() + " as a request uri of the BYE request");
            bye.setRequestURI((URI)realInetUri);
        }
        bye.send();
    }

    private void onNotFound(org.mobicents.servlet.restcomm.telephony.NotFound message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.ringing)) {
            this.fsm.transition((Object)message, this.notFound);
        }
    }

    private void onMediaServerControllerStateChanged(MediaServerControllerStateChanged message, ActorRef self, ActorRef sender) throws Exception {
        switch (message.getState()) {
            case PENDING: {
                if (!this.is(this.initializing)) break;
                this.fsm.transition((Object)message, this.dialing);
                break;
            }
            case ACTIVE: {
                if (!this.is(this.initializing) && !this.is(this.updatingMediaSession)) break;
                SipSession.State sessionState = this.invite.getSession().getState();
                if (!SipSession.State.CONFIRMED.equals((Object)sessionState) && !SipSession.State.TERMINATED.equals((Object)sessionState)) {
                    this.mediaSessionInfo = message.getMediaSession();
                    SipServletResponse okay = this.invite.createResponse(200);
                    byte[] sdp = this.mediaSessionInfo.getLocalSdp().getBytes();
                    String answer = null;
                    if (this.mediaSessionInfo.usesNat()) {
                        String externalIp = this.mediaSessionInfo.getExternalAddress().getHostAddress();
                        answer = SdpUtils.patch((String)"application/sdp", (byte[])sdp, (String)externalIp);
                    } else {
                        answer = this.mediaSessionInfo.getLocalSdp().toString();
                    }
                    answer = SdpUtils.endWithNewLine((String)answer);
                    okay.setContent((Object)answer, "application/sdp");
                    okay.send();
                } else if (SipSession.State.CONFIRMED.equals((Object)sessionState)) {
                    SipServletRequest reInvite = this.invite.getSession().createRequest("INVITE");
                    this.mediaSessionInfo = message.getMediaSession();
                    byte[] sdp = this.mediaSessionInfo.getLocalSdp().getBytes();
                    String answer = null;
                    if (this.mediaSessionInfo.usesNat()) {
                        String externalIp = this.mediaSessionInfo.getExternalAddress().getHostAddress();
                        answer = SdpUtils.patch((String)"application/sdp", (byte[])sdp, (String)externalIp);
                    } else {
                        answer = this.mediaSessionInfo.getLocalSdp().toString();
                    }
                    answer = SdpUtils.endWithNewLine((String)answer);
                    reInvite.setContent((Object)answer, "application/sdp");
                    reInvite.send();
                }
                this.invite.getApplicationSession().setExpires(0);
                this.fsm.transition((Object)message, this.inProgress);
                break;
            }
            case INACTIVE: {
                if (this.is(this.stopping)) {
                    if (this.fail) {
                        this.fsm.transition((Object)message, this.failed);
                        break;
                    }
                    this.fsm.transition((Object)message, this.completed);
                    break;
                }
                if (this.is(this.canceling)) {
                    this.fsm.transition((Object)message, this.canceled);
                    break;
                }
                if (this.is(this.failingBusy)) {
                    this.fsm.transition((Object)message, this.busy);
                    break;
                }
                if (!this.is(this.failingNoAnswer)) break;
                this.fsm.transition((Object)message, this.noAnswer);
                break;
            }
            case FAILED: {
                if (!this.is(this.initializing) && !this.is(this.updatingMediaSession) && !this.is(this.joining) && !this.is(this.leaving)) break;
                this.fsm.transition((Object)message, this.failed);
                break;
            }
        }
    }

    private void onJoinBridge(JoinBridge message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.inProgress)) {
            this.bridge = sender;
            this.fsm.transition((Object)message, this.joining);
        }
    }

    private void onJoinConference(JoinConference message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.inProgress)) {
            this.conferencing = true;
            this.conference = sender;
            this.fsm.transition((Object)message, this.joining);
        }
    }

    private void onJoinComplete(JoinComplete message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.joining)) {
            if (this.conferencing) {
                this.conference.tell((Object)message, self);
            } else {
                this.bridge.tell((Object)message, self);
            }
            this.fsm.transition((Object)message, this.inProgress);
        }
    }

    private void onLeave(Leave message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.inProgress)) {
            this.fsm.transition((Object)message, this.leaving);
        }
    }

    private void onLeft(Left message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.leaving)) {
            this.fsm.transition((Object)message, this.inProgress);
        }
    }

    private void onStartRecordingCall(StartRecording message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.inProgress)) {
            if (this.runtimeSettings == null) {
                this.runtimeSettings = message.getRuntimeSetting();
            }
            if (this.daoManager == null) {
                this.daoManager = message.getDaoManager();
            }
            if (this.accountId == null) {
                this.accountId = message.getAccountId();
            }
            message.setCallId(this.id);
            this.msController.tell((Object)message, sender);
            this.recording = true;
        }
    }

    private void onStopRecordingCall(StopRecording message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.inProgress) && this.recording) {
            this.msController.tell((Object)message, sender);
            this.recording = false;
        }
    }

    private final class Completed
    extends AbstractAction {
        public Completed(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Call.this.logger.info("Completing Call");
            if (Call.this.invite.getSession().isValid()) {
                Call.this.invite.getSession().invalidate();
            }
            if (Call.this.invite.getApplicationSession().isValid()) {
                Call.this.invite.getApplicationSession().invalidate();
            }
            Call.this.external = CallStateChanged.State.COMPLETED;
            CallStateChanged event = new CallStateChanged(Call.this.external);
            for (ActorRef observer : Call.this.observers) {
                observer.tell((Object)event, this.source);
            }
            if (Call.this.outgoingCallRecord != null && Call.this.isOutbound()) {
                Call.this.outgoingCallRecord = Call.this.outgoingCallRecord.setStatus(Call.this.external.name());
                DateTime now = DateTime.now();
                Call.this.outgoingCallRecord = Call.this.outgoingCallRecord.setEndTime(now);
                int seconds = (int)((now.getMillis() - Call.this.outgoingCallRecord.getStartTime().getMillis()) / 1000L);
                Call.this.outgoingCallRecord = Call.this.outgoingCallRecord.setDuration(Integer.valueOf(seconds));
                Call.this.recordsDao.updateCallDetailRecord(Call.this.outgoingCallRecord);
                Call.this.logger.debug("Start: " + Call.this.outgoingCallRecord.getStartTime());
                Call.this.logger.debug("End: " + Call.this.outgoingCallRecord.getEndTime());
                Call.this.logger.debug("Duration: " + seconds);
                Call.this.logger.debug("Just updated CDR for completed call");
            }
        }
    }

    private final class Stopping
    extends AbstractAction {
        public Stopping(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Call.this.msController.tell((Object)new CloseMediaSession(), this.source);
        }
    }

    private final class Leaving
    extends AbstractAction {
        public Leaving(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Call.this.msController.tell(message, this.source);
        }
    }

    private final class Joining
    extends AbstractAction {
        public Joining(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Call.this.msController.tell(message, this.source);
        }
    }

    private final class InProgress
    extends AbstractAction {
        public InProgress(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Call.this.external = CallStateChanged.State.IN_PROGRESS;
            CallStateChanged event = new CallStateChanged(Call.this.external);
            for (ActorRef observer : Call.this.observers) {
                observer.tell((Object)event, this.source);
            }
            if (Call.this.outgoingCallRecord != null && Call.this.isOutbound() && !Call.this.outgoingCallRecord.getStatus().equalsIgnoreCase("in_progress")) {
                Call.this.outgoingCallRecord = Call.this.outgoingCallRecord.setStatus(Call.this.external.name());
                Call.this.outgoingCallRecord = Call.this.outgoingCallRecord.setStartTime(DateTime.now());
                Call.this.outgoingCallRecord = Call.this.outgoingCallRecord.setAnsweredBy(Call.this.to.getUser());
                Call.this.recordsDao.updateCallDetailRecord(Call.this.outgoingCallRecord);
            }
        }
    }

    private final class UpdatingMediaSession
    extends AbstractAction {
        public UpdatingMediaSession(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            SipServletResponse response;
            if (Call.this.is(Call.this.dialing) || Call.this.is(Call.this.ringing)) {
                UntypedActorContext context = Call.this.getContext();
                context.setReceiveTimeout((Duration)Duration.Undefined());
            }
            if ((response = (SipServletResponse)message).getStatus() == 200 && Call.this.isOutbound()) {
                SipServletRequest ack = response.createAck();
                SipServletRequest originalInvite = response.getRequest();
                SipURI realInetUri = (SipURI)originalInvite.getRequestURI();
                InetAddress ackRURI = InetAddress.getByName(((SipURI)ack.getRequestURI()).getHost());
                if (realInetUri != null && (ackRURI.isSiteLocalAddress() || ackRURI.isAnyLocalAddress() || ackRURI.isLoopbackAddress())) {
                    Call.this.logger.info("Using the real ip address of the sip client " + realInetUri.toString() + " as a request uri of the ACK");
                    ack.setRequestURI((URI)realInetUri);
                }
                ack.send();
                Call.this.logger.info("Just sent out ACK : " + ack.toString());
            }
            String externalIp = response.getInitialRemoteAddr();
            byte[] sdp = response.getRawContent();
            String answer = SdpUtils.patch((String)response.getContentType(), (byte[])sdp, (String)externalIp);
            UpdateMediaSession update = new UpdateMediaSession(answer);
            Call.this.msController.tell((Object)update, this.source);
        }
    }

    private final class Initializing
    extends AbstractAction {
        public Initializing(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Observe observe = new Observe(this.source);
            Call.this.msController.tell((Object)observe, this.source);
            CreateMediaSession command = null;
            if (Call.this.isOutbound()) {
                command = new CreateMediaSession("sendrecv", "", true);
            } else if (!Call.this.liveCallModification) {
                command = this.generateRequest((SipServletMessage)Call.this.invite);
            } else if (Call.this.lastResponse != null && Call.this.lastResponse.getStatus() == 200) {
                command = this.generateRequest((SipServletMessage)Call.this.lastResponse);
            }
            Call.this.msController.tell((Object)command, this.source);
        }

        private CreateMediaSession generateRequest(SipServletMessage sipMessage) throws IOException, SdpException {
            String externalIp = sipMessage.getInitialRemoteAddr();
            byte[] sdp = sipMessage.getRawContent();
            String offer = SdpUtils.patch((String)sipMessage.getContentType(), (byte[])sdp, (String)externalIp);
            return new CreateMediaSession("sendrecv", offer, false);
        }
    }

    private final class Failed
    extends AbstractAction {
        public Failed(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            if (Call.this.isInbound()) {
                Call.this.invite.createResponse(503, "Problem to setup services").send();
            }
            if (Call.this.invite.getSession().isValid()) {
                Call.this.invite.getSession().setInvalidateWhenReady(true);
            }
            if (Call.this.invite.getApplicationSession().isValid()) {
                Call.this.invite.getApplicationSession().setInvalidateWhenReady(true);
            }
            Call.this.external = CallStateChanged.State.FAILED;
            CallStateChanged event = new CallStateChanged(Call.this.external);
            for (ActorRef observer : Call.this.observers) {
                observer.tell((Object)event, this.source);
            }
            if (Call.this.outgoingCallRecord != null && Call.this.isOutbound()) {
                Call.this.outgoingCallRecord = Call.this.outgoingCallRecord.setStatus(Call.this.external.name());
                Call.this.recordsDao.updateCallDetailRecord(Call.this.outgoingCallRecord);
            }
        }
    }

    private final class NoAnswer
    extends AbstractAction {
        public NoAnswer(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Call.this.external = CallStateChanged.State.NO_ANSWER;
            CallStateChanged event = new CallStateChanged(Call.this.external);
            for (ActorRef observer : Call.this.observers) {
                observer.tell((Object)event, this.source);
            }
            if (Call.this.outgoingCallRecord != null && Call.this.isOutbound()) {
                Call.this.outgoingCallRecord = Call.this.outgoingCallRecord.setStatus(Call.this.external.name());
                Call.this.recordsDao.updateCallDetailRecord(Call.this.outgoingCallRecord);
            }
        }
    }

    private final class NotFound
    extends AbstractAction {
        public NotFound(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Class<?> klass = message.getClass();
            if (org.mobicents.servlet.restcomm.telephony.NotFound.class.equals(klass) && Call.this.isInbound()) {
                SipServletResponse notFound = Call.this.invite.createResponse(404);
                notFound.send();
            }
            Call.this.external = CallStateChanged.State.NOT_FOUND;
            CallStateChanged event = new CallStateChanged(Call.this.external);
            for (ActorRef observer : Call.this.observers) {
                observer.tell((Object)event, this.source);
            }
            if (Call.this.outgoingCallRecord != null && Call.this.isOutbound()) {
                Call.this.outgoingCallRecord = Call.this.outgoingCallRecord.setStatus(Call.this.external.name());
                Call.this.recordsDao.updateCallDetailRecord(Call.this.outgoingCallRecord);
            }
        }
    }

    private final class Busy
    extends AbstractAction {
        public Busy(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Class<?> klass = message.getClass();
            if (Reject.class.equals(klass) && Call.this.is(Call.this.ringing) && Call.this.isInbound()) {
                SipServletResponse busy = Call.this.invite.createResponse(486);
                busy.send();
            }
            Call.this.external = CallStateChanged.State.BUSY;
            CallStateChanged event = new CallStateChanged(Call.this.external);
            for (ActorRef observer : Call.this.observers) {
                observer.tell((Object)event, this.source);
            }
            if (Call.this.outgoingCallRecord != null && Call.this.isOutbound()) {
                Call.this.outgoingCallRecord = Call.this.outgoingCallRecord.setStatus(Call.this.external.name());
                Call.this.recordsDao.updateCallDetailRecord(Call.this.outgoingCallRecord);
            }
        }
    }

    private final class FailingNoAnswer
    extends Failing {
        public FailingNoAnswer(ActorRef source) {
            super(source);
        }

        @Override
        public void execute(Object message) throws Exception {
            Call.this.logger.info("Call moves to failing state because no answer");
            Call.this.fsm.transition(message, Call.this.noAnswer);
        }
    }

    private final class FailingBusy
    extends Failing {
        public FailingBusy(ActorRef source) {
            super(source);
        }
    }

    private abstract class Failing
    extends AbstractAction {
        public Failing(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            if (message instanceof ReceiveTimeout) {
                UntypedActorContext context = Call.this.getContext();
                context.setReceiveTimeout((Duration)Duration.Undefined());
            }
            Call.this.msController.tell((Object)new CloseMediaSession(), this.source);
        }
    }

    private final class Canceled
    extends AbstractAction {
        public Canceled(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Call.this.external = CallStateChanged.State.CANCELED;
            CallStateChanged event = new CallStateChanged(Call.this.external);
            for (ActorRef observer : Call.this.observers) {
                observer.tell((Object)event, this.source);
            }
            if (Call.this.outgoingCallRecord != null && Call.this.isOutbound()) {
                Call.this.outgoingCallRecord = Call.this.outgoingCallRecord.setStatus(Call.this.external.name());
                Call.this.recordsDao.updateCallDetailRecord(Call.this.outgoingCallRecord);
            }
            Call.this.fsm.transition(message, Call.this.completed);
        }
    }

    private final class Canceling
    extends AbstractAction {
        public Canceling(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            if (Call.this.isOutbound()) {
                UntypedActorContext context = Call.this.getContext();
                context.setReceiveTimeout((Duration)Duration.Undefined());
                SipServletRequest cancel = Call.this.invite.createCancel();
                cancel.send();
            }
            Call.this.msController.tell((Object)new CloseMediaSession(), this.source);
        }
    }

    private final class Ringing
    extends AbstractAction {
        public Ringing(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            if (message instanceof SipServletRequest) {
                Call.this.invite = (SipServletRequest)message;
                Call.this.from = (SipURI)Call.this.invite.getFrom().getURI();
                Call.this.to = (SipURI)Call.this.invite.getTo().getURI();
                Call.this.timeout = -1L;
                Call.this.direction = Call.INBOUND;
                SipServletResponse ringing = Call.this.invite.createResponse(180);
                ringing.send();
                SipURI initialInetUri = Call.this.getInitialIpAddressPort((SipServletMessage)Call.this.invite);
                if (initialInetUri != null) {
                    Call.this.invite.getSession().setAttribute("realInetUri", (Object)initialInetUri);
                }
            } else if (message instanceof SipServletResponse) {
                // empty if block
            }
            Call.this.external = CallStateChanged.State.RINGING;
            CallStateChanged event = new CallStateChanged(Call.this.external);
            for (ActorRef observer : Call.this.observers) {
                observer.tell((Object)event, this.source);
            }
            if (Call.this.outgoingCallRecord != null && Call.this.isOutbound()) {
                Call.this.outgoingCallRecord = Call.this.outgoingCallRecord.setStatus(Call.this.external.name());
                Call.this.recordsDao.updateCallDetailRecord(Call.this.outgoingCallRecord);
            }
        }
    }

    private final class Dialing
    extends AbstractAction {
        public Dialing(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            MediaServerControllerStateChanged response = (MediaServerControllerStateChanged)message;
            ActorRef self = Call.this.self();
            Call.this.mediaSessionInfo = response.getMediaSession();
            StringBuilder buffer = new StringBuilder();
            buffer.append(Call.this.to.getHost());
            if (Call.this.to.getPort() > -1) {
                buffer.append(":").append(Call.this.to.getPort());
            }
            SipURI uri = Call.this.factory.createSipURI(null, buffer.toString());
            SipApplicationSession application = Call.this.factory.createApplicationSession();
            application.setAttribute(Call.class.getName(), (Object)self);
            if (Call.this.name != null && !Call.this.name.isEmpty()) {
                Address fromAddress = Call.this.factory.createAddress((URI)Call.this.from, Call.this.name);
                Address toAddress = Call.this.factory.createAddress((URI)Call.this.to);
                Call.this.invite = Call.this.factory.createRequest(application, "INVITE", fromAddress, toAddress);
            } else {
                Call.this.invite = Call.this.factory.createRequest(application, "INVITE", (URI)Call.this.from, (URI)Call.this.to);
            }
            Call.this.invite.pushRoute(uri);
            if (Call.this.headers != null) {
                Set entrySet = Call.this.headers.entrySet();
                for (Map.Entry entry : entrySet) {
                    Call.this.invite.addHeader("X-" + (String)entry.getKey(), (String)entry.getValue());
                }
            }
            Call.this.invite.addHeader("X-RestComm-ApiVersion", Call.this.apiVersion);
            Call.this.invite.addHeader("X-RestComm-AccountSid", Call.this.accountId.toString());
            Call.this.invite.addHeader("X-RestComm-CallSid", Call.this.id.toString());
            SipSession session = Call.this.invite.getSession();
            session.setHandler("CallManager");
            if (Call.this.type.equals((Object)CreateCall.Type.CLIENT) || Call.this.type.equals((Object)CreateCall.Type.SIP)) {
                ((SipSessionExt)session).setBypassLoadBalancer(true);
                ((SipSessionExt)session).setBypassProxy(true);
            }
            String offer = null;
            if (Call.this.mediaSessionInfo.usesNat()) {
                String externalIp = Call.this.mediaSessionInfo.getExternalAddress().getHostAddress();
                byte[] sdp = Call.this.mediaSessionInfo.getLocalSdp().getBytes();
                offer = SdpUtils.patch((String)"application/sdp", (byte[])sdp, (String)externalIp);
            } else {
                offer = Call.this.mediaSessionInfo.getLocalSdp();
            }
            offer = SdpUtils.endWithNewLine((String)offer);
            Call.this.invite.setContent((Object)offer, "application/sdp");
            Call.this.invite.send();
            UntypedActorContext context = Call.this.getContext();
            context.setReceiveTimeout((Duration)Duration.create((long)Call.this.timeout, (TimeUnit)TimeUnit.SECONDS));
        }
    }

    private final class Queued
    extends AbstractAction {
        public Queued(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            InitializeOutbound request = (InitializeOutbound)message;
            Call.this.name = request.name();
            Call.this.from = request.from();
            Call.this.to = request.to();
            Call.this.apiVersion = request.apiVersion();
            Call.this.accountId = request.accountId();
            Call.this.username = request.username();
            Call.this.password = request.password();
            Call.this.type = request.type();
            Call.this.recordsDao = request.getDaoManager().getCallDetailRecordsDao();
            String toHeaderString = Call.this.to.toString();
            if (toHeaderString.indexOf(63) != -1) {
                Call.this.headers = new HashMap();
                Call.this.to = (SipURI)Call.this.factory.createURI(toHeaderString.substring(0, toHeaderString.lastIndexOf(63)));
                String headersString = toHeaderString.substring(toHeaderString.lastIndexOf(63) + 1);
                StringTokenizer tokenizer = new StringTokenizer(headersString, "&");
                while (tokenizer.hasMoreTokens()) {
                    String headerNameValue = tokenizer.nextToken();
                    String headerName = headerNameValue.substring(0, headerNameValue.lastIndexOf(61));
                    String headerValue = headerNameValue.substring(headerNameValue.lastIndexOf(61) + 1);
                    Call.this.headers.put(headerName, headerValue);
                }
            }
            Call.this.timeout = request.timeout();
            Call.this.direction = request.isFromApi() ? Call.OUTBOUND_API : Call.OUTBOUND_DIAL;
            Call.this.external = CallStateChanged.State.QUEUED;
            CallStateChanged event = new CallStateChanged(Call.this.external);
            for (ActorRef observer : Call.this.observers) {
                observer.tell((Object)event, this.source);
            }
            if (Call.this.recordsDao != null) {
                CallDetailRecord cdr = Call.this.recordsDao.getCallDetailRecord(Call.this.id);
                if (cdr == null) {
                    CallDetailRecord.Builder builder = CallDetailRecord.builder();
                    builder.setSid(Call.this.id);
                    builder.setDateCreated(Call.this.created);
                    builder.setAccountSid(Call.this.accountId);
                    builder.setTo(Call.this.to.getUser());
                    builder.setCallerName(Call.this.name);
                    String fromString = Call.this.from.getUser() != null ? Call.this.from.getUser() : "CALLS REST API";
                    builder.setFrom(fromString);
                    builder.setStatus(Call.this.external.name());
                    builder.setDirection(Call.OUTBOUND_API);
                    builder.setApiVersion(Call.this.apiVersion);
                    builder.setPrice(new BigDecimal("0.00"));
                    builder.setPriceUnit(Currency.getInstance("USD"));
                    StringBuilder buffer = new StringBuilder();
                    buffer.append("/").append(Call.this.apiVersion).append("/Accounts/");
                    buffer.append(Call.this.accountId.toString()).append("/Calls/");
                    buffer.append(Call.this.id.toString());
                    java.net.URI uri = java.net.URI.create(buffer.toString());
                    builder.setUri(uri);
                    builder.setCallPath(Call.this.self().path().toString());
                    Call.this.outgoingCallRecord = builder.build();
                    Call.this.recordsDao.addCallDetailRecord(Call.this.outgoingCallRecord);
                } else {
                    cdr.setStatus(Call.this.external.name());
                }
            }
        }
    }

    private abstract class AbstractAction
    implements Action {
        protected final ActorRef source;

        public AbstractAction(ActorRef source) {
            this.source = source;
        }
    }
}

