/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.telephony;

import akka.actor.ActorRef;
import akka.actor.Props;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorFactory;
import org.mobicents.servlet.restcomm.mscontrol.MediaServerControllerFactory;
import org.mobicents.servlet.restcomm.patterns.Observe;
import org.mobicents.servlet.restcomm.telephony.Bridge;
import org.mobicents.servlet.restcomm.telephony.BridgeManagerResponse;
import org.mobicents.servlet.restcomm.telephony.BridgeStateChanged;
import org.mobicents.servlet.restcomm.telephony.CreateBridge;

public class BridgeManager
extends UntypedActor {
    private final MediaServerControllerFactory factory;

    public BridgeManager(MediaServerControllerFactory factory) {
        this.factory = factory;
    }

    private ActorRef createBridge() {
        return this.getContext().actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new Bridge(BridgeManager.this.factory.provideBridgeController());
            }
        }));
    }

    public void onReceive(Object message) throws Exception {
        Class<?> klass = message.getClass();
        ActorRef self = this.self();
        ActorRef sender = this.sender();
        if (CreateBridge.class.equals(klass)) {
            this.onCreateBridge((CreateBridge)message, self, sender);
        } else if (BridgeStateChanged.class.equals(klass)) {
            this.onBridgeStateChanged((BridgeStateChanged)message, self, sender);
        }
    }

    private void onCreateBridge(CreateBridge message, ActorRef self, ActorRef sender) {
        ActorRef bridge = this.createBridge();
        bridge.tell((Object)new Observe(self), self);
        BridgeManagerResponse response = new BridgeManagerResponse(bridge);
        sender.tell((Object)response, self);
    }

    private void onBridgeStateChanged(BridgeStateChanged message, ActorRef self, ActorRef sender) {
        switch (message.getState()) {
            case INACTIVE: 
            case FAILED: {
                this.context().stop(sender);
                break;
            }
        }
    }
}

