/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.srtp;

import java.nio.channels.DatagramChannel;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.bouncycastle.crypto.tls.DTLSServerProtocol;
import org.bouncycastle.crypto.tls.DatagramTransport;
import org.bouncycastle.crypto.tls.TlsServer;
import org.mobicents.media.server.impl.rtp.crypto.DtlsSrtpServer;
import org.mobicents.media.server.impl.rtp.crypto.PacketTransformer;
import org.mobicents.media.server.impl.rtp.crypto.SRTPPolicy;
import org.mobicents.media.server.impl.rtp.crypto.SRTPTransformEngine;
import org.mobicents.media.server.impl.srtp.DtlsListener;
import org.mobicents.media.server.impl.srtp.NioUdpTransport;
import org.mobicents.media.server.utils.Text;

public class DtlsHandler {
    private static final Logger logger = Logger.getLogger(DtlsHandler.class);
    private DtlsSrtpServer server;
    private DatagramChannel channel;
    private volatile boolean handshakeComplete;
    private volatile boolean handshakeFailed;
    private volatile boolean handshaking;
    private Thread worker;
    private String hashFunction;
    private String remoteFingerprint;
    private String localFingerprint;
    private final List<DtlsListener> listeners = new ArrayList<DtlsListener>();
    private PacketTransformer srtpEncoder;
    private PacketTransformer srtpDecoder;
    private PacketTransformer srtcpEncoder;
    private PacketTransformer srtcpDecoder;

    public DtlsHandler(DatagramChannel channel) {
        this.server = new DtlsSrtpServer();
        this.channel = channel;
        this.handshakeComplete = false;
        this.handshakeFailed = false;
        this.handshaking = false;
        this.hashFunction = "";
        this.remoteFingerprint = "";
        this.localFingerprint = "";
    }

    public DtlsHandler() {
        this(null);
    }

    public DatagramChannel getChannel() {
        return this.channel;
    }

    public void setChannel(DatagramChannel channel) {
        this.channel = channel;
    }

    public void addListener(DtlsListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    public boolean isHandshakeFailed() {
        return this.handshakeFailed;
    }

    public boolean isHandshaking() {
        return this.handshaking;
    }

    public Text getLocalFingerprint() {
        if (this.localFingerprint == null || this.localFingerprint.isEmpty()) {
            this.localFingerprint = this.server.generateFingerprint(this.hashFunction);
        }
        return new Text(this.localFingerprint);
    }

    public void resetLocalFingerprint() {
        this.localFingerprint = "";
    }

    public String getHashFunction() {
        return this.hashFunction;
    }

    public String getRemoteFingerprintValue() {
        return this.remoteFingerprint;
    }

    public String getRemoteFingerprint() {
        return this.hashFunction + " " + this.remoteFingerprint;
    }

    public void setRemoteFingerprint(String hashFunction, String fingerprint) {
        this.hashFunction = hashFunction;
        this.remoteFingerprint = fingerprint;
    }

    private byte[] getMasterServerKey() {
        return this.server.getSrtpMasterServerKey();
    }

    private byte[] getMasterServerSalt() {
        return this.server.getSrtpMasterServerSalt();
    }

    private byte[] getMasterClientKey() {
        return this.server.getSrtpMasterClientKey();
    }

    private byte[] getMasterClientSalt() {
        return this.server.getSrtpMasterClientSalt();
    }

    private SRTPPolicy getSrtpPolicy() {
        return this.server.getSrtpPolicy();
    }

    private SRTPPolicy getSrtcpPolicy() {
        return this.server.getSrtcpPolicy();
    }

    public PacketTransformer getSrtpDecoder() {
        return this.srtpDecoder;
    }

    public PacketTransformer getSrtpEncoder() {
        return this.srtpEncoder;
    }

    public PacketTransformer getSrtcpDecoder() {
        return this.srtcpDecoder;
    }

    public PacketTransformer getSrtcpEncoder() {
        return this.srtcpEncoder;
    }

    private PacketTransformer generateRtpEncoder() {
        return new SRTPTransformEngine(this.getMasterServerKey(), this.getMasterServerSalt(), this.getSrtpPolicy(), this.getSrtcpPolicy()).getRTPTransformer();
    }

    private PacketTransformer generateRtpDecoder() {
        return new SRTPTransformEngine(this.getMasterClientKey(), this.getMasterClientSalt(), this.getSrtpPolicy(), this.getSrtcpPolicy()).getRTPTransformer();
    }

    private PacketTransformer generateRtcpEncoder() {
        return new SRTPTransformEngine(this.getMasterServerKey(), this.getMasterServerSalt(), this.getSrtpPolicy(), this.getSrtcpPolicy()).getRTCPTransformer();
    }

    private PacketTransformer generateRtcpDecoder() {
        return new SRTPTransformEngine(this.getMasterClientKey(), this.getMasterClientSalt(), this.getSrtpPolicy(), this.getSrtcpPolicy()).getRTCPTransformer();
    }

    public byte[] decodeRTP(byte[] packet, int offset, int length) {
        return this.srtpDecoder.reverseTransform(packet, offset, length);
    }

    public byte[] encodeRTP(byte[] packet, int offset, int length) {
        return this.srtpEncoder.transform(packet, offset, length);
    }

    public byte[] decodeRTCP(byte[] packet, int offset, int length) {
        return this.srtcpDecoder.reverseTransform(packet, offset, length);
    }

    public byte[] encodeRTCP(byte[] packet, int offset, int length) {
        return this.srtcpEncoder.transform(packet, offset, length);
    }

    public void handshake() {
        if (!this.handshaking && !this.handshakeComplete) {
            this.handshaking = true;
            this.worker = new Thread(new HandshakeWorker());
            this.worker.start();
        }
    }

    private void fireHandshakeComplete() {
        if (this.listeners.size() > 0) {
            Iterator<DtlsListener> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onDtlsHandshakeComplete();
            }
        }
    }

    private void fireHandshakeFailed(Throwable e) {
        if (this.listeners.size() > 0) {
            Iterator<DtlsListener> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onDtlsHandshakeFailed(e);
            }
        }
    }

    public void reset() {
        this.server = new DtlsSrtpServer();
        this.channel = null;
        this.srtcpDecoder = null;
        this.srtcpEncoder = null;
        this.srtpDecoder = null;
        this.srtpEncoder = null;
        this.hashFunction = "";
        this.remoteFingerprint = "";
        this.localFingerprint = "";
        this.handshakeComplete = false;
        this.handshakeFailed = false;
        this.handshaking = false;
    }

    private class HandshakeWorker
    implements Runnable {
        private HandshakeWorker() {
        }

        @Override
        public void run() {
            SecureRandom secureRandom = new SecureRandom();
            DTLSServerProtocol serverProtocol = new DTLSServerProtocol(secureRandom);
            NioUdpTransport transport = new NioUdpTransport(DtlsHandler.this.getChannel());
            try {
                serverProtocol.accept((TlsServer)DtlsHandler.this.server, (DatagramTransport)transport);
                DtlsHandler.this.server.prepareSrtpSharedSecret();
                DtlsHandler.this.srtpDecoder = DtlsHandler.this.generateRtpDecoder();
                DtlsHandler.this.srtpEncoder = DtlsHandler.this.generateRtpEncoder();
                DtlsHandler.this.srtcpDecoder = DtlsHandler.this.generateRtcpDecoder();
                DtlsHandler.this.srtcpEncoder = DtlsHandler.this.generateRtcpEncoder();
                DtlsHandler.this.handshakeComplete = true;
                DtlsHandler.this.handshakeFailed = false;
                DtlsHandler.this.handshaking = false;
                DtlsHandler.this.fireHandshakeComplete();
            }
            catch (Exception e) {
                logger.error((Object)("DTLS handshake failed: " + e.getMessage()), (Throwable)e);
                DtlsHandler.this.handshakeComplete = false;
                DtlsHandler.this.handshakeFailed = true;
                DtlsHandler.this.handshaking = false;
                DtlsHandler.this.fireHandshakeFailed(e);
            }
        }
    }
}

