/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp.statistics;

import org.apache.commons.net.ntp.TimeStamp;
import org.apache.log4j.Logger;
import org.mobicents.media.server.impl.rtcp.RtcpSenderReport;
import org.mobicents.media.server.impl.rtcp.ntp.NtpUtils;
import org.mobicents.media.server.impl.rtp.RtpClock;
import org.mobicents.media.server.impl.rtp.RtpPacket;
import org.mobicents.media.server.scheduler.Clock;

public class RtpMember {
    private static final Logger logger = Logger.getLogger(RtpMember.class);
    public static final int RTP_SEQ_MOD = 65536;
    public static final int MAX_DROPOUT = 100;
    public static final int MAX_MISORDER = 100;
    public static final int MIN_SEQUENTIAL = 2;
    private final RtpClock rtpClock;
    private final Clock wallClock;
    private long ssrc;
    private String cname;
    private long receivedPackets;
    private long receivedOctets;
    private long receivedSinceSR;
    private int roundTripDelay;
    private long lastPacketReceivedOn;
    private int firstSequenceNumber;
    private int highestSequence;
    private int sequenceCycle;
    private int badSequence;
    private int probation;
    private long receivedPrior;
    private long expectedPrior;
    private long currentTransit;
    private long jitter;
    private long lastSrTimestamp;
    private long lastSrReceivedOn;

    public RtpMember(RtpClock clock, long ssrc, String cname) {
        this.rtpClock = clock;
        this.wallClock = clock.getWallClock();
        this.ssrc = ssrc;
        this.cname = cname;
        this.receivedPackets = 0L;
        this.receivedOctets = 0L;
        this.receivedSinceSR = 0L;
        this.lastPacketReceivedOn = -1L;
        this.firstSequenceNumber = -1;
        this.highestSequence = 0;
        this.badSequence = 0;
        this.sequenceCycle = 0;
        this.probation = 0;
        this.receivedPrior = 0L;
        this.expectedPrior = 0L;
        this.currentTransit = 0L;
        this.jitter = -1L;
        this.lastSrTimestamp = 0L;
        this.lastSrReceivedOn = 0L;
        this.roundTripDelay = 0;
    }

    public RtpMember(RtpClock clock, long ssrc) {
        this(clock, ssrc, "");
    }

    public long getSsrc() {
        return this.ssrc;
    }

    public String getCname() {
        return this.cname;
    }

    public void setCname(String cname) {
        this.cname = cname;
    }

    public long getPacketsReceived() {
        return this.receivedPackets;
    }

    public long getPacketsExpected() {
        return this.getExtHighSequence() - this.firstSequenceNumber + 1;
    }

    public long getOctetsReceived() {
        return this.receivedOctets;
    }

    public long getReceivedSinceSR() {
        return this.receivedSinceSR;
    }

    public long getFractionLost() {
        long expected = this.getPacketsExpected();
        long expectedInterval = expected - this.expectedPrior;
        this.expectedPrior = expected;
        long receivedInterval = this.receivedPackets - this.receivedPrior;
        this.receivedPrior = this.receivedPackets;
        long lostInterval = expectedInterval - receivedInterval;
        if (expectedInterval == 0L || lostInterval <= 0L) {
            return 0L;
        }
        return (lostInterval << 8) / expectedInterval;
    }

    public long getPacketsLost() {
        long lost = this.getPacketsExpected() - this.receivedPackets;
        if (lost > 0x7FFFFFL) {
            return 0x7FFFFFL;
        }
        if (lost < -8388608L) {
            return -8388608L;
        }
        return lost;
    }

    public int getSequenceCycle() {
        return this.sequenceCycle >> 16;
    }

    public long getJitter() {
        return this.jitter >> 4;
    }

    public long getLastSR() {
        return this.lastSrTimestamp;
    }

    public long getLastSRdelay() {
        return this.getLastSRdelay(this.wallClock.getCurrentTime(), this.lastSrReceivedOn);
    }

    private long getLastSRdelay(long arrivalTime, long lastSrTime) {
        if (this.lastSrReceivedOn == 0L) {
            return 0L;
        }
        long delay = arrivalTime - lastSrTime;
        return (long)((double)delay * 65.536);
    }

    public int getExtHighSequence() {
        return this.highestSequence + this.sequenceCycle;
    }

    public int getRTT() {
        if (this.roundTripDelay > 0) {
            return this.roundTripDelay;
        }
        return 0;
    }

    private void estimateJitter(RtpPacket packet) {
        long transit = this.rtpClock.getLocalRtpTime() - packet.getTimestamp();
        long d = transit - this.currentTransit;
        this.currentTransit = transit;
        if (d < 0L) {
            d = -d;
        }
        this.jitter += d - (this.jitter + 8L >> 4);
    }

    private void initJitter(RtpPacket packet) {
        this.currentTransit = this.rtpClock.getLocalRtpTime() - packet.getTimestamp();
    }

    public void estimateRtt(long receiptDate, long lastSR, long delaySinceSR) {
        TimeStamp receiptNtp = TimeStamp.getNtpTime((long)receiptDate);
        long receiptNtpTime = NtpUtils.calculateLastSrTimestamp(receiptNtp.getSeconds(), receiptNtp.getFraction());
        long delay = receiptNtpTime - lastSR - delaySinceSR;
        this.roundTripDelay = delay > 4294967L ? 65536 : (int)(delay * 1000L >> 16);
        logger.info((Object)("rtt=" + receiptNtpTime + " - " + lastSR + " - " + delaySinceSR + " = " + delay + " => " + this.roundTripDelay + "ms"));
    }

    private void initSequence(int sequence) {
        this.firstSequenceNumber = sequence;
        this.highestSequence = sequence;
        this.badSequence = 65537;
        this.sequenceCycle = 0;
        this.receivedPrior = 0L;
        this.expectedPrior = 0L;
    }

    private boolean updateSequence(int sequence) {
        int delta = Math.abs(sequence - this.highestSequence);
        if (this.probation > 0) {
            if (sequence == this.highestSequence + 1) {
                --this.probation;
                this.highestSequence = sequence;
                if (this.probation == 0) {
                    this.initSequence(sequence);
                    return true;
                }
            } else {
                this.probation = 1;
                this.highestSequence = sequence;
            }
            return false;
        }
        if (delta < 100) {
            if (sequence < this.highestSequence) {
                this.sequenceCycle += 65536;
            }
            this.highestSequence = sequence;
        } else if (delta <= 65436) {
            if (sequence == this.badSequence) {
                this.initSequence(sequence);
            } else {
                this.badSequence = sequence + 1 & 0xFFFF;
                return false;
            }
        }
        return true;
    }

    public void onReceiveRtp(RtpPacket packet) {
        if (this.validateSequence(packet.getSeqNumber())) {
            ++this.receivedSinceSR;
            ++this.receivedPackets;
            this.receivedOctets += (long)packet.getPayloadLength();
            if (this.lastPacketReceivedOn > 0L) {
                this.estimateJitter(packet);
            } else {
                this.initJitter(packet);
            }
            this.lastPacketReceivedOn = this.rtpClock.getLocalRtpTime();
        }
    }

    private boolean validateSequence(int sequence) {
        if (this.firstSequenceNumber < 0) {
            this.initSequence(sequence);
            this.highestSequence = sequence - 1;
            this.probation = 2;
            return false;
        }
        return this.updateSequence(sequence);
    }

    public void onReceiveSR(RtcpSenderReport report) {
        this.lastSrTimestamp = report.getNtpTs();
        this.lastSrReceivedOn = this.wallClock.getCurrentTime();
        this.receivedSinceSR = 0L;
    }
}

