/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp.sdp;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.mobicents.media.server.impl.rtp.sdp.CandidateField;
import org.mobicents.media.server.impl.rtp.sdp.ConnectionField;
import org.mobicents.media.server.impl.rtp.sdp.MediaDescriptorField;
import org.mobicents.media.server.impl.rtp.sdp.MediaType;
import org.mobicents.media.server.impl.rtp.sdp.OriginField;
import org.mobicents.media.server.impl.rtp.sdp.TimeField;
import org.mobicents.media.server.utils.Text;

public class SessionDescription {
    private Text version;
    private OriginField origin;
    private Text session;
    private ConnectionField connection;
    private TimeField time;
    protected static final Text RTPMAP = new Text("a=rtpmap");
    protected static final Text FMTP = new Text("a=fmtp");
    protected static final Text AUDIO = new Text("audio");
    protected static final Text VIDEO = new Text("video");
    private ArrayList<MediaDescriptorField> mds = new ArrayList(3);
    private MediaDescriptorField md;
    private MediaDescriptorField audioDescriptor;
    private MediaDescriptorField videoDescriptor;
    private MediaDescriptorField applicationDescriptor;
    protected static final Text ICE_UFRAG = new Text("a=ice-ufrag");
    protected static final Text ICE_PWD = new Text("a=ice-pwd");
    protected static final Text ICE_CANDIDATE = CandidateField.CANDIDATE_FIELD;
    private boolean ice = false;
    protected static final Text WEBRTC_FINGERPRINT = new Text("a=fingerprint");
    private Text fingerprint;

    public SessionDescription() {
        this.origin = new OriginField();
        this.connection = new ConnectionField();
        this.time = new TimeField();
    }

    public void parse(byte[] data) throws ParseException {
        Text text = new Text();
        text.strain(data, 0, data.length);
        this.init(text);
    }

    public void init(Text text) throws ParseException {
        this.reset();
        while (text.hasMoreLines()) {
            Text line = text.nextLine();
            if (line.length() == 0) continue;
            block0 : switch (line.charAt(0)) {
                case 'v': {
                    Iterator it = line.split('=').iterator();
                    it.next();
                    this.version = (Text)it.next();
                    this.version.trim();
                    break;
                }
                case 'o': {
                    this.origin.strain(line);
                    break;
                }
                case 's': {
                    Iterator it = line.split('=').iterator();
                    it.next();
                    this.session = (Text)it.next();
                    this.session.trim();
                    break;
                }
                case 'c': {
                    if (this.md == null) {
                        this.connection.strain(line);
                        break;
                    }
                    this.md.setConnection(line);
                    break;
                }
                case 't': {
                    this.time.strain(line);
                    break;
                }
                case 'm': {
                    this.md = new MediaDescriptorField();
                    this.mds.add(this.md);
                    this.md.setDescriptor(line);
                    MediaType mediaType = MediaType.fromDescription(this.md.getMediaType());
                    if (mediaType == null) break;
                    switch (mediaType) {
                        case AUDIO: {
                            this.audioDescriptor = this.md;
                            break block0;
                        }
                        case VIDEO: {
                            this.videoDescriptor = this.md;
                            break block0;
                        }
                        case APPLICATION: {
                            this.applicationDescriptor = this.md;
                            break block0;
                        }
                    }
                    break;
                }
                case 'a': {
                    if (this.md != null) {
                        this.md.addAttribute(line);
                        break;
                    }
                    if (!this.ice) {
                        this.ice = this.isIceAttribute(line);
                    }
                    if (!line.startsWith(WEBRTC_FINGERPRINT)) break;
                    this.addFingerprintAttribute(line);
                }
            }
        }
    }

    public Text getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = new Text(version);
    }

    public OriginField getOrigin() {
        return this.origin;
    }

    public void setOrigin(String name, String sessionID, String sessionVersion, String netType, String addressType, String address) {
        this.origin = new OriginField(name, sessionID, sessionVersion, netType, addressType, address);
    }

    public String getSession() {
        return this.session.toString();
    }

    public ConnectionField getConnection() {
        return this.connection;
    }

    public TimeField getTime() {
        return this.time;
    }

    public Text getFingerprint() {
        return this.fingerprint;
    }

    public Text getFingerprint(MediaType mediaType) {
        if (MediaType.AUDIO.equals((Object)mediaType)) {
            return this.getFingerprint(this.audioDescriptor);
        }
        return this.fingerprint;
    }

    private Text getFingerprint(MediaDescriptorField mediaStream) {
        Text value = mediaStream.getWebRTCFingerprint();
        if (value != null && value.length() > 0) {
            return value;
        }
        return this.fingerprint;
    }

    public Collection<MediaDescriptorField> getMedia() {
        return this.mds;
    }

    public MediaDescriptorField getAudioDescriptor() {
        return this.audioDescriptor;
    }

    public MediaDescriptorField getVideoDescriptor() {
        return this.videoDescriptor;
    }

    public MediaDescriptorField getApplicationDescriptor() {
        return this.applicationDescriptor;
    }

    public boolean hasAudioDescriptor() {
        return this.audioDescriptor != null;
    }

    public boolean hasVideoDescriptor() {
        return this.videoDescriptor != null;
    }

    public boolean hasApplicationDescriptor() {
        return this.applicationDescriptor != null;
    }

    private boolean isIceAttribute(Text line) {
        return line.startsWith(ICE_UFRAG) || line.startsWith(ICE_PWD) || line.startsWith(ICE_CANDIDATE);
    }

    public boolean isIce() {
        return this.ice;
    }

    public boolean isAudioIce() {
        return this.ice || this.getAudioDescriptor().isIce();
    }

    private void addFingerprintAttribute(Text attribute) throws IllegalArgumentException {
        Text fingerprint;
        this.fingerprint = fingerprint = (Text)attribute.subSequence(WEBRTC_FINGERPRINT.length(), attribute.length());
    }

    public void reset() {
        this.version = null;
        this.session = null;
        this.origin.reset();
        this.connection.reset();
        this.time.reset();
        this.mds.clear();
        this.md = null;
        this.audioDescriptor = null;
        this.videoDescriptor = null;
        this.applicationDescriptor = null;
        this.fingerprint = null;
        this.ice = false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("v=%s\n", this.version.toString()));
        builder.append(this.origin.toString());
        return builder.toString();
    }
}

