/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp.sdp;

import java.util.List;
import org.mobicents.media.io.ice.IceCandidate;
import org.mobicents.media.io.ice.LocalCandidateWrapper;
import org.mobicents.media.server.impl.rtp.channels.MediaChannel;
import org.mobicents.media.server.impl.rtp.sdp.RTPFormat;
import org.mobicents.media.server.impl.rtp.sdp.RTPFormats;
import org.mobicents.media.server.io.sdp.MediaProfile;
import org.mobicents.media.server.io.sdp.SessionDescription;
import org.mobicents.media.server.io.sdp.SessionLevelAccessor;
import org.mobicents.media.server.io.sdp.attributes.ConnectionModeAttribute;
import org.mobicents.media.server.io.sdp.attributes.FormatParameterAttribute;
import org.mobicents.media.server.io.sdp.attributes.PacketTimeAttribute;
import org.mobicents.media.server.io.sdp.attributes.RtpMapAttribute;
import org.mobicents.media.server.io.sdp.attributes.SsrcAttribute;
import org.mobicents.media.server.io.sdp.dtls.attributes.FingerprintAttribute;
import org.mobicents.media.server.io.sdp.dtls.attributes.SetupAttribute;
import org.mobicents.media.server.io.sdp.fields.ConnectionField;
import org.mobicents.media.server.io.sdp.fields.MediaDescriptionField;
import org.mobicents.media.server.io.sdp.fields.OriginField;
import org.mobicents.media.server.io.sdp.fields.SessionNameField;
import org.mobicents.media.server.io.sdp.fields.TimingField;
import org.mobicents.media.server.io.sdp.fields.VersionField;
import org.mobicents.media.server.io.sdp.ice.attributes.CandidateAttribute;
import org.mobicents.media.server.io.sdp.ice.attributes.IceLiteAttribute;
import org.mobicents.media.server.io.sdp.ice.attributes.IcePwdAttribute;
import org.mobicents.media.server.io.sdp.ice.attributes.IceUfragAttribute;
import org.mobicents.media.server.io.sdp.rtcp.attributes.RtcpAttribute;
import org.mobicents.media.server.io.sdp.rtcp.attributes.RtcpMuxAttribute;
import org.mobicents.media.server.spi.format.AudioFormat;

public class SdpFactory {
    public static SessionDescription buildSdp(String localAddress, String externalAddress, MediaChannel ... channels) {
        SessionDescription sd = new SessionDescription();
        sd.setVersion(new VersionField(0));
        String originAddress = externalAddress == null || externalAddress.isEmpty() ? localAddress : externalAddress;
        sd.setOrigin(new OriginField("-", String.valueOf(System.currentTimeMillis()), "1", "IN", "IP4", originAddress));
        sd.setSessionName(new SessionNameField("Mobicents Media Server"));
        sd.setConnection(new ConnectionField("IN", "IP4", localAddress));
        sd.setTiming(new TimingField(0, 0));
        boolean ice = false;
        for (MediaChannel channel : channels) {
            MediaDescriptionField md = SdpFactory.buildMediaDescription(channel);
            md.setSession((SessionLevelAccessor)sd);
            sd.addMediaDescription(md);
            if (!md.containsIce()) continue;
            sd.getConnection().setAddress(md.getConnection().getAddress());
            ice = true;
        }
        if (ice) {
            sd.setIceLite(new IceLiteAttribute());
        }
        return sd;
    }

    public static void rejectMediaField(SessionDescription answer, MediaDescriptionField media) {
        MediaDescriptionField rejected = new MediaDescriptionField();
        rejected.setMedia(media.getMedia());
        rejected.setPort(0);
        rejected.setProtocol(media.getProtocol());
        rejected.setPayloadTypes(media.getPayloadTypes());
        rejected.setSession((SessionLevelAccessor)answer);
        answer.addMediaDescription(rejected);
    }

    public static MediaDescriptionField buildMediaDescription(MediaChannel channel) {
        MediaDescriptionField md = new MediaDescriptionField();
        md.setMedia(channel.getMediaType());
        md.setPort(channel.getRtpPort());
        MediaProfile profile = channel.isDtlsEnabled() ? MediaProfile.RTP_SAVPF : MediaProfile.RTP_AVP;
        md.setProtocol(profile.getProfile());
        md.setConnection(new ConnectionField("IN", "IP4", channel.getRtpAddress()));
        md.setPtime(new PacketTimeAttribute(20));
        md.setRtcp(new RtcpAttribute(channel.getRtcpPort(), "IN", "IP4", channel.getRtcpAddress()));
        if (channel.isRtcpMux()) {
            md.setRtcpMux(new RtcpMuxAttribute());
        }
        if (channel.isIceEnabled()) {
            List<LocalCandidateWrapper> rtcpCandidates;
            md.setIceUfrag(new IceUfragAttribute(channel.getIceUfrag()));
            md.setIcePwd(new IcePwdAttribute(channel.getIcePwd()));
            List<LocalCandidateWrapper> rtpCandidates = channel.getRtpCandidates();
            if (!rtpCandidates.isEmpty()) {
                IceCandidate defaultCandidate = channel.getDefaultRtpCandidate().getCandidate();
                md.getConnection().setAddress(defaultCandidate.getHostString());
                md.setPort(defaultCandidate.getPort());
                if (channel.isRtcpMux()) {
                    md.getRtcp().setAddress(defaultCandidate.getHostString());
                    md.getRtcp().setPort(defaultCandidate.getPort());
                }
                for (LocalCandidateWrapper candidate : rtpCandidates) {
                    md.addCandidate(SdpFactory.processCandidate(candidate.getCandidate()));
                }
            }
            if (!channel.isRtcpMux() && !(rtcpCandidates = channel.getRtcpCandidates()).isEmpty()) {
                IceCandidate defaultCandidate = channel.getDefaultRtcpCandidate().getCandidate();
                md.getRtcp().setAddress(defaultCandidate.getHostString());
                md.getRtcp().setPort(defaultCandidate.getPort());
                for (LocalCandidateWrapper candidate : rtcpCandidates) {
                    md.addCandidate(SdpFactory.processCandidate(candidate.getCandidate()));
                }
            }
        }
        RTPFormats negotiatedFormats = channel.getFormats();
        negotiatedFormats.rewind();
        while (negotiatedFormats.hasMore()) {
            RTPFormat f = negotiatedFormats.next();
            RtpMapAttribute rtpMap = new RtpMapAttribute();
            rtpMap.setPayloadType(f.getID());
            rtpMap.setCodec(f.getFormat().getName().toString());
            rtpMap.setClockRate(f.getClockRate());
            switch (channel.getMediaType()) {
                case "audio": {
                    AudioFormat audioFormat = (AudioFormat)f.getFormat();
                    if (audioFormat.getChannels() > 1) {
                        rtpMap.setCodecParams(audioFormat.getChannels());
                    }
                    if (audioFormat.getOptions() == null) break;
                    rtpMap.setParameters(new FormatParameterAttribute(f.getID(), audioFormat.getOptions().toString()));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Media type " + channel.getMediaType() + " not supported.");
                }
            }
            md.addPayloadType(f.getID());
            md.addFormat(rtpMap);
        }
        if (channel.isDtlsEnabled()) {
            md.setSetup(new SetupAttribute("passive"));
            String fingerprint = channel.getDtlsFingerprint();
            int whitespace = fingerprint.indexOf(" ");
            String fingerprintHash = fingerprint.substring(0, whitespace);
            String fingerprintValue = fingerprint.substring(whitespace + 1);
            md.setFingerprint(new FingerprintAttribute(fingerprintHash, fingerprintValue));
        }
        md.setConnectionMode(new ConnectionModeAttribute("sendrecv"));
        SsrcAttribute ssrcAttribute = new SsrcAttribute(Long.toString(channel.getSsrc()));
        ssrcAttribute.addAttribute("cname", channel.getCname());
        md.setSsrc(ssrcAttribute);
        return md;
    }

    private static CandidateAttribute processCandidate(IceCandidate candidate) {
        CandidateAttribute candidateSdp = new CandidateAttribute();
        candidateSdp.setFoundation(candidate.getFoundation());
        candidateSdp.setComponentId(candidate.getComponentId());
        candidateSdp.setProtocol(candidate.getProtocol().getDescription());
        candidateSdp.setPriority(candidate.getPriority());
        candidateSdp.setAddress(candidate.getHostString());
        candidateSdp.setPort(candidate.getPort());
        String candidateType = candidate.getType().getDescription();
        candidateSdp.setCandidateType(candidateType);
        if ("host" != candidateType) {
            candidateSdp.setRelatedAddress(candidate.getBase().getHostString());
            candidateSdp.setRelatedPort(candidate.getBase().getPort());
        }
        candidateSdp.setGeneration(0);
        return candidateSdp;
    }
}

