/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp.sdp;

import java.util.Collection;
import org.mobicents.media.server.impl.rtp.sdp.MediaDescriptorField;
import org.mobicents.media.server.impl.rtp.sdp.RTPFormats;
import org.mobicents.media.server.impl.rtp.sdp.SessionDescription;
import org.mobicents.media.server.utils.Text;

@Deprecated
public class SdpComparator {
    public static final Text AUDIO = new Text("audio");
    public static final Text VIDEO = new Text("video");
    public static final Text APPLICATION = new Text("application");
    private RTPFormats audio = new RTPFormats();
    private RTPFormats video = new RTPFormats();
    private RTPFormats application = new RTPFormats();

    @Deprecated
    public void negotiate(SessionDescription sdp, RTPFormats audio, RTPFormats video) {
        this.audio.clean();
        this.video.clean();
        Collection<MediaDescriptorField> mds = sdp.getMedia();
        for (MediaDescriptorField md : mds) {
            if (md.getMediaType().equals((Object)AUDIO)) {
                if (audio == null) continue;
                md.getFormats().intersection(audio, this.audio);
                continue;
            }
            if (video == null) continue;
            md.getFormats().intersection(video, this.video);
        }
    }

    public RTPFormats negotiateAudio(SessionDescription sdp, RTPFormats formats) {
        this.audio.clean();
        MediaDescriptorField descriptor = sdp.getAudioDescriptor();
        descriptor.getFormats().intersection(formats, this.audio);
        return this.audio;
    }

    public RTPFormats negotiateVideo(SessionDescription sdp, RTPFormats formats) {
        this.video.clean();
        MediaDescriptorField descriptor = sdp.getVideoDescriptor();
        descriptor.getFormats().intersection(formats, this.video);
        return this.video;
    }

    public RTPFormats negotiateApplication(SessionDescription sdp, RTPFormats formats) {
        this.application.clean();
        MediaDescriptorField descriptor = sdp.getApplicationDescriptor();
        descriptor.getFormats().intersection(formats, this.application);
        return this.application;
    }

    public void compare(SessionDescription sdp1, SessionDescription sdp2) {
        this.audio.clean();
        this.video.clean();
        this.application.clean();
        Collection<MediaDescriptorField> mds1 = sdp1.getMedia();
        Collection<MediaDescriptorField> mds2 = sdp2.getMedia();
        for (MediaDescriptorField md1 : mds1) {
            for (MediaDescriptorField md2 : mds2) {
                if (!md1.getMediaType().equals((Object)md2.getMediaType())) continue;
                this.compare(md1, md2);
            }
        }
    }

    private void compare(MediaDescriptorField md1, MediaDescriptorField md2) {
        RTPFormats collector = null;
        if (md1.getMediaType().equals((Object)AUDIO)) {
            collector = this.audio;
        } else if (md1.getMediaType().equals((Object)VIDEO)) {
            collector = this.video;
        } else if (md1.getMediaType().equals((Object)APPLICATION)) {
            collector = this.application;
        } else {
            throw new NullPointerException("Unrecognized collector for media type " + md1.getMediaType());
        }
        md1.getFormats().intersection(md2.getFormats(), collector);
    }

    private RTPFormats compareAudio(SessionDescription sdp1, SessionDescription sdp2) {
        this.audio.clean();
        RTPFormats formats1 = sdp1.getAudioDescriptor().getFormats();
        RTPFormats formats2 = sdp2.getAudioDescriptor().getFormats();
        formats1.intersection(formats2, this.audio);
        return this.audio;
    }

    private RTPFormats compareVideo(SessionDescription sdp1, SessionDescription sdp2) {
        this.video.clean();
        RTPFormats formats1 = sdp1.getVideoDescriptor().getFormats();
        RTPFormats formats2 = sdp2.getVideoDescriptor().getFormats();
        formats1.intersection(formats2, this.video);
        return this.video;
    }

    private RTPFormats compareApplication(SessionDescription sdp1, SessionDescription sdp2) {
        this.application.clean();
        RTPFormats formats1 = sdp1.getApplicationDescriptor().getFormats();
        RTPFormats formats2 = sdp2.getApplicationDescriptor().getFormats();
        formats1.intersection(formats2, this.application);
        return this.application;
    }

    public RTPFormats getAudio() {
        return this.audio;
    }

    public RTPFormats getVideo() {
        return this.video;
    }

    public RTPFormats getApplication() {
        return this.application;
    }
}

