/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp.sdp;

import java.util.ArrayList;
import org.mobicents.media.server.impl.rtp.sdp.AVProfile;
import org.mobicents.media.server.impl.rtp.sdp.RTPFormat;
import org.mobicents.media.server.spi.format.Format;
import org.mobicents.media.server.spi.format.Formats;

public class RTPFormats {
    private static final int size = 10;
    private ArrayList<RTPFormat> rtpFormats;
    private Formats formats = new Formats();
    private int cursor;

    public RTPFormats() {
        this.rtpFormats = new ArrayList(10);
    }

    public int getLen() {
        return this.rtpFormats.size();
    }

    public RTPFormats(int size) {
        this.rtpFormats = new ArrayList(size);
    }

    public void add(RTPFormat rtpFormat) {
        this.rtpFormats.add(rtpFormat);
        this.formats.add(rtpFormat.getFormat());
    }

    public void add(RTPFormats fmts) {
        for (int i = 0; i < fmts.rtpFormats.size(); ++i) {
            this.rtpFormats.add(fmts.rtpFormats.get(i));
            this.formats.add(fmts.rtpFormats.get(i).getFormat());
        }
    }

    public void remove(RTPFormat rtpFormat) {
        int pos = -1;
        for (int i = 0; i < this.rtpFormats.size(); ++i) {
            ++pos;
            if (this.rtpFormats.get(i).getID() == rtpFormat.getID()) break;
        }
        if (pos == -1) {
            throw new IllegalArgumentException("Unknown format " + rtpFormat);
        }
        this.rtpFormats.remove(pos);
        this.formats.remove(rtpFormat.getFormat());
    }

    public void clean() {
        this.rtpFormats.clear();
        this.formats.clean();
        this.cursor = 0;
    }

    public int size() {
        return this.rtpFormats.size();
    }

    public RTPFormat getRTPFormat(int payload) {
        for (int i = 0; i < this.rtpFormats.size(); ++i) {
            if (this.rtpFormats.get(i).getID() != payload) continue;
            return this.rtpFormats.get(i);
        }
        return null;
    }

    public RTPFormat getRTPFormat(Format format) {
        for (int i = 0; i < this.rtpFormats.size(); ++i) {
            if (!this.rtpFormats.get(i).getFormat().matches(format)) continue;
            return this.rtpFormats.get(i);
        }
        return null;
    }

    public RTPFormat[] toArray() {
        RTPFormat[] fmts = new RTPFormat[this.rtpFormats.size()];
        return this.rtpFormats.toArray(fmts);
    }

    public Formats getFormats() {
        return this.formats;
    }

    public RTPFormat find(int p) {
        int size = this.rtpFormats.size();
        for (int i = 0; i < size; ++i) {
            if (this.rtpFormats.get(i).getID() != p) continue;
            return this.rtpFormats.get(i);
        }
        return null;
    }

    public boolean contains(int p) {
        return this.find(p) != null;
    }

    public boolean contains(Format fmt) {
        for (int i = 0; i < this.rtpFormats.size(); ++i) {
            if (!this.rtpFormats.get(i).getFormat().matches(fmt)) continue;
            return true;
        }
        return false;
    }

    public RTPFormat find(Format fmt) {
        for (int i = 0; i < this.rtpFormats.size(); ++i) {
            if (!this.rtpFormats.get(i).getFormat().matches(fmt)) continue;
            return this.rtpFormats.get(i);
        }
        return null;
    }

    public boolean isEmpty() {
        return this.rtpFormats.isEmpty();
    }

    public void rewind() {
        this.cursor = 0;
    }

    public boolean hasMore() {
        return this.cursor != this.rtpFormats.size();
    }

    public RTPFormat next() {
        return this.rtpFormats.get(this.cursor++);
    }

    public boolean hasNonDTMF() {
        for (int i = 0; i < this.rtpFormats.size(); ++i) {
            if (this.rtpFormats.get(i).getFormat().getName().equals((Object)AVProfile.telephoneEvent.getName())) continue;
            return true;
        }
        return false;
    }

    public void intersection(RTPFormats other, RTPFormats res) {
        block0: for (int i = 0; i < this.rtpFormats.size(); ++i) {
            RTPFormat supportedFormat = this.rtpFormats.get(i);
            for (int j = 0; j < other.size(); ++j) {
                RTPFormat offeredFormat = other.rtpFormats.get(j);
                if (!supportedFormat.getFormat().matches(offeredFormat.getFormat())) continue;
                res.add(offeredFormat);
                continue block0;
            }
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("RTPFormats{");
        for (int i = 0; i < this.rtpFormats.size(); ++i) {
            buffer.append(this.rtpFormats.get(i));
            if (i == this.rtpFormats.size() - 1) continue;
            buffer.append(",");
        }
        buffer.append("}");
        return buffer.toString();
    }
}

