/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp.sdp;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.mobicents.media.server.impl.rtp.sdp.AVProfile;
import org.mobicents.media.server.impl.rtp.sdp.CandidateField;
import org.mobicents.media.server.impl.rtp.sdp.ConnectionField;
import org.mobicents.media.server.impl.rtp.sdp.MediaType;
import org.mobicents.media.server.impl.rtp.sdp.RTPFormat;
import org.mobicents.media.server.impl.rtp.sdp.RTPFormats;
import org.mobicents.media.server.impl.rtp.sdp.RtcpMuxField;
import org.mobicents.media.server.impl.rtp.sdp.SessionDescription;
import org.mobicents.media.server.spi.format.ApplicationFormat;
import org.mobicents.media.server.spi.format.AudioFormat;
import org.mobicents.media.server.spi.format.EncodingName;
import org.mobicents.media.server.spi.format.Format;
import org.mobicents.media.server.spi.format.FormatFactory;
import org.mobicents.media.server.spi.format.VideoFormat;
import org.mobicents.media.server.utils.Text;

public class MediaDescriptorField {
    private Text mediaType;
    private int port;
    private Text profile;
    private ConnectionField connection;
    private boolean rtcpMux = false;
    private boolean ice = false;
    private Text iceUfrag;
    private Text icePwd;
    private List<CandidateField> candidates = new ArrayList<CandidateField>();
    private RTPFormats formats = new RTPFormats(15);
    private Text webRTCFingerprint;
    public static final String RTP_AVP_PROFILE = "RTP/AVP";
    public static final String RTP_SAVP_PROFILE = "RTP/SAVP";
    public static final String RTP_SAVPF_PROFILE = "RTP/SAVPF";

    protected void setDescriptor(Text line) throws ParseException {
        line.trim();
        try {
            Iterator it = line.split('=').iterator();
            Text t = (Text)it.next();
            t = (Text)it.next();
            it = t.split(' ').iterator();
            this.mediaType = (Text)it.next();
            this.mediaType.trim();
            t = (Text)it.next();
            t.trim();
            this.port = t.toInteger();
            this.profile = (Text)it.next();
            this.profile.trim();
            while (it.hasNext()) {
                t = (Text)it.next();
                t.trim();
                RTPFormat fmt = AVProfile.getFormat(t.toInteger(), this.mediaType);
                if (fmt == null || this.formats.contains(fmt.getFormat())) continue;
                this.formats.add(fmt.clone());
            }
        }
        catch (Exception e) {
            throw new ParseException("Could not parse media descriptor", 0);
        }
    }

    protected void addAttribute(Text attribute) {
        if (attribute.startsWith(SessionDescription.RTPMAP)) {
            this.addRtpMapAttribute(attribute);
            return;
        }
        if (attribute.startsWith(SessionDescription.FMTP)) {
            this.addFmtAttribute(attribute);
            return;
        }
        if (attribute.startsWith(SessionDescription.WEBRTC_FINGERPRINT)) {
            this.addFingerprintAttribute(attribute);
            return;
        }
        if (attribute.startsWith(SessionDescription.ICE_UFRAG)) {
            this.ice = true;
            this.addIceUfragAttribute(attribute);
            return;
        }
        if (attribute.startsWith(SessionDescription.ICE_PWD)) {
            this.ice = true;
            this.addIcePwdAttribute(attribute);
            return;
        }
        if (attribute.startsWith(CandidateField.CANDIDATE_FIELD)) {
            this.ice = true;
            this.addCandidate(attribute);
            return;
        }
        if (attribute.startsWith(RtcpMuxField.RTCP_MUX_FIELD)) {
            this.rtcpMux = true;
            return;
        }
    }

    private void addIceUfragAttribute(Text attribute) {
        Text attr = new Text();
        attribute.copy(attr);
        attr.trim();
        Iterator it = attribute.split(':').iterator();
        Text token = (Text)it.next();
        token = (Text)it.next();
        token.trim();
        this.iceUfrag = token;
    }

    private void addIcePwdAttribute(Text attribute) {
        Text attr = new Text();
        attribute.copy(attr);
        attr.trim();
        Iterator it = attribute.split(':').iterator();
        Text token = (Text)it.next();
        token = (Text)it.next();
        token.trim();
        this.icePwd = token;
    }

    private void addCandidate(Text attribute) {
        Text attr = new Text();
        attribute.copy(attr);
        attr.trim();
        CandidateField candidateField = new CandidateField(attr);
        this.candidates.add(candidateField);
        Collections.sort(this.candidates, Collections.reverseOrder());
    }

    private void addRtpMapAttribute(Text attribute) throws IllegalArgumentException {
        if (!attribute.startsWith(SessionDescription.RTPMAP)) {
            throw new IllegalArgumentException("Not a valid RTP MAP attribute" + attribute);
        }
        Iterator it = attribute.split(':').iterator();
        Text token = (Text)it.next();
        token = (Text)it.next();
        token.trim();
        it = token.split(' ').iterator();
        token = (Text)it.next();
        token.trim();
        int payload = token.toInteger();
        token = (Text)it.next();
        token.trim();
        this.createFormat(payload, token);
    }

    private void addFmtAttribute(Text attribute) throws IllegalArgumentException {
        if (!attribute.startsWith(SessionDescription.FMTP)) {
            throw new IllegalArgumentException("Not a valid FMT attribute" + attribute);
        }
        Iterator it = attribute.split(':').iterator();
        Text token = (Text)it.next();
        token = (Text)it.next();
        token.trim();
        it = token.split(' ').iterator();
        token = (Text)it.next();
        token.trim();
        int payload = token.toInteger();
        token = (Text)it.next();
        token.trim();
        RTPFormat fmt = this.getFormat(payload);
        if (fmt != null) {
            fmt.getFormat().setOptions(token);
        }
    }

    private void addFingerprintAttribute(Text attribute) throws IllegalArgumentException {
        if (!attribute.startsWith(SessionDescription.WEBRTC_FINGERPRINT)) {
            throw new IllegalArgumentException("Not a valid fingerprint attribute" + attribute);
        }
        Text fingerprint = (Text)attribute.subSequence(SessionDescription.WEBRTC_FINGERPRINT.length(), attribute.length());
        this.setWebRTCFingerprint(fingerprint);
    }

    public ConnectionField getConnection() {
        return this.connection;
    }

    protected void setConnection(Text line) throws ParseException {
        this.connection = new ConnectionField();
        this.connection.strain(line);
        Collections.sort(this.candidates);
    }

    public Text getMediaType() {
        return this.mediaType;
    }

    public int getPort() {
        return this.port;
    }

    public Text getProfile() {
        return this.profile;
    }

    public RTPFormats getFormats() {
        return this.formats;
    }

    private RTPFormat getFormat(int payload) {
        return this.formats.find(payload);
    }

    public boolean isRtcpMux() {
        return this.rtcpMux;
    }

    private RTPFormat createFormat(int payload, Text description) {
        MediaType mtype = MediaType.fromDescription(this.mediaType);
        switch (mtype) {
            case AUDIO: {
                return this.createAudioFormat(payload, description);
            }
            case VIDEO: {
                return this.createVideoFormat(payload, description);
            }
            case APPLICATION: {
                return this.createApplicationFormat(payload, description);
            }
        }
        return null;
    }

    private RTPFormat createAudioFormat(int payload, Text description) {
        RTPFormat rtpFormat;
        Iterator it = description.split('/').iterator();
        Text token = (Text)it.next();
        token.trim();
        EncodingName name = new EncodingName(token);
        token = (Text)it.next();
        token.trim();
        int clockRate = token.toInteger();
        int channels = 1;
        if (it.hasNext()) {
            token = (Text)it.next();
            token.trim();
            channels = token.toInteger();
        }
        if ((rtpFormat = this.getFormat(payload)) == null) {
            this.formats.add(new RTPFormat(payload, (Format)FormatFactory.createAudioFormat((EncodingName)name, (int)clockRate, (int)-1, (int)channels)));
        } else {
            ((AudioFormat)rtpFormat.getFormat()).setName(name);
            ((AudioFormat)rtpFormat.getFormat()).setSampleRate(clockRate);
            ((AudioFormat)rtpFormat.getFormat()).setChannels(channels);
        }
        return rtpFormat;
    }

    private RTPFormat createVideoFormat(int payload, Text description) {
        Iterator it = description.split('/').iterator();
        Text token = (Text)it.next();
        token.trim();
        EncodingName name = new EncodingName(token);
        token = (Text)it.next();
        token.trim();
        int clockRate = token.toInteger();
        RTPFormat rtpFormat = this.getFormat(payload);
        if (rtpFormat == null) {
            this.formats.add(new RTPFormat(payload, (Format)FormatFactory.createVideoFormat((EncodingName)name, (int)clockRate)));
        } else {
            ((VideoFormat)rtpFormat.getFormat()).setName(name);
            ((VideoFormat)rtpFormat.getFormat()).setFrameRate(clockRate);
        }
        return rtpFormat;
    }

    private RTPFormat createApplicationFormat(int payload, Text description) {
        Iterator it = description.split('/').iterator();
        Text token = (Text)it.next();
        token.trim();
        EncodingName name = new EncodingName(token);
        token = (Text)it.next();
        token.trim();
        RTPFormat rtpFormat = this.getFormat(payload);
        if (rtpFormat == null) {
            this.formats.add(new RTPFormat(payload, (Format)FormatFactory.createApplicationFormat((EncodingName)name)));
        } else {
            ((ApplicationFormat)rtpFormat.getFormat()).setName(name);
        }
        return rtpFormat;
    }

    public boolean isWebRTCProfile() {
        return this.getProfile().toString().equals(RTP_SAVP_PROFILE) || this.getProfile().toString().equals(RTP_SAVPF_PROFILE);
    }

    public Text getWebRTCFingerprint() {
        return this.webRTCFingerprint;
    }

    public void setWebRTCFingerprint(Text webRTCFingerprint) {
        this.webRTCFingerprint = webRTCFingerprint;
    }

    public boolean isIce() {
        return this.ice;
    }

    public Text getIceUfrag() {
        return this.iceUfrag;
    }

    public Text getIcePwd() {
        return this.icePwd;
    }

    public List<CandidateField> getCandidates() {
        return this.candidates;
    }

    public CandidateField getMostRelevantCandidate() {
        if (this.candidates == null || this.candidates.isEmpty()) {
            return null;
        }
        return this.candidates.get(0);
    }
}

