/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp.sdp;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.mobicents.media.server.utils.Text;

@Deprecated
public class CandidateField
implements Comparable<CandidateField> {
    public static final Text CANDIDATE_FIELD = new Text("a=candidate");
    private Text foundation;
    private Text componentId;
    private Text protocol;
    private Text weight;
    private Text address;
    private Text port;
    private Text type;
    private Text relatedAddress;
    private Text relatedPort;
    private Text generation;

    public CandidateField(Text line) {
        this.parseCandidateLine(line);
    }

    public Text getFoundation() {
        return this.foundation;
    }

    public Text getComponentId() {
        return this.componentId;
    }

    public Text getProtocol() {
        return this.protocol;
    }

    public Text getWeight() {
        return this.weight;
    }

    public Text getAddress() {
        return this.address;
    }

    public Text getPort() {
        return this.port;
    }

    public Text getType() {
        return this.type;
    }

    public Text getRelatedAddress() {
        return this.relatedAddress;
    }

    public boolean hasRelatedAddress() {
        return this.relatedAddress != null;
    }

    public Text getRelatedPort() {
        return this.relatedPort;
    }

    public Text getGeneration() {
        return this.generation;
    }

    private void parseCandidateLine(Text line) {
        if (!line.startsWith(CANDIDATE_FIELD)) {
            throw new IllegalArgumentException("Not a valid candidate attribute" + line);
        }
        try {
            Text data = (Text)line.subSequence(CANDIDATE_FIELD.length() + 1, line.length());
            Collection tokens = data.split(' ');
            Iterator iterator = tokens.iterator();
            this.foundation = (Text)iterator.next();
            this.componentId = (Text)iterator.next();
            this.protocol = (Text)iterator.next();
            this.weight = (Text)iterator.next();
            this.address = (Text)iterator.next();
            this.port = (Text)iterator.next();
            iterator.next();
            this.type = (Text)iterator.next();
            AddressType addressType = AddressType.fromDescription(this.type);
            if (addressType == null) {
                throw new IllegalArgumentException("Unrecognized address type: " + this.type);
            }
            switch (addressType) {
                case RELAY: 
                case SRFLX: {
                    iterator.next();
                    this.relatedAddress = (Text)iterator.next();
                    iterator.next();
                    this.relatedPort = (Text)iterator.next();
                    break;
                }
            }
            if (iterator.hasNext()) {
                iterator.next();
                this.generation = (Text)iterator.next();
            }
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("Candidate line is badly formated: " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder((CharSequence)CANDIDATE_FIELD).append(":");
        builder.append((CharSequence)this.foundation).append(" ");
        builder.append((CharSequence)this.componentId).append(" ");
        builder.append((CharSequence)this.protocol).append(" ");
        builder.append((CharSequence)this.weight).append(" ");
        builder.append((CharSequence)this.address).append(" ");
        builder.append((CharSequence)this.port).append(" ");
        builder.append("typ ");
        builder.append((CharSequence)this.type).append(" ");
        switch (AddressType.fromDescription(this.type)) {
            case RELAY: 
            case SRFLX: {
                builder.append("raddr ");
                builder.append((CharSequence)this.relatedAddress).append(" ");
                builder.append("rport ");
                builder.append((CharSequence)this.relatedPort).append(" ");
                break;
            }
        }
        builder.append("generation ");
        builder.append((CharSequence)this.generation);
        return builder.toString();
    }

    @Override
    public int compareTo(CandidateField o) {
        int otherWeight;
        if (o == null) {
            return 1;
        }
        int myWeight = this.weight == null ? 0 : this.weight.toInteger();
        int n = otherWeight = o.getWeight() == null ? 0 : o.getWeight().toInteger();
        if (myWeight > otherWeight) {
            return 1;
        }
        if (myWeight < otherWeight) {
            return -1;
        }
        return 0;
    }

    public static enum AddressType {
        HOST("host"),
        RELAY("relay"),
        SRFLX("srflx");

        private Text description;

        private AddressType(String description) {
            this.description = new Text(description);
        }

        public Text getDescription() {
            return this.description;
        }

        public static AddressType fromDescription(Text value) {
            for (AddressType type : AddressType.values()) {
                if (!type.getDescription().equals((Object)value)) continue;
                return type;
            }
            return null;
        }
    }
}

